ORCA/M Asm65816 2.1.0

0001 7C2B                       title 'QD Text              GS ROM 3.0' 
0002 7C2B              ****************************************************************
0003 7C2B              *                                                              *
0004 7C2B              *              TEXT                                            *
0005 7C2B              *                                                              *
0006 7C2B              *
0007 7C2B              * Modification History
0008 7C2B              *
0009 7C2B              * pre Jan 89        Bennet and Steve did a whole buncha stuff!
0010 7C2B              *
0011 7C2B              * 2/20/89           Mensch
0012 7C2B              *
0013 7C2B              * First FastFont stuff done. Modified almost all the routines at least
0014 7C2B              * a little.
0015 7C2B              * 
0016 7C2B              * 2/24/89           Mensch
0017 7C2B              *
0018 7C2B              * Fixed bugs in fastfont clipping and drawing. CalcGood drawstatus
0019 7C2B              * now returns a little more info!
0020 7C2B              *
0021 7C2B              *
0022 7C2B              * 12 Mar 89         Steven Glass
0023 7C2B              *
0024 7C2B              * Changed MakeFastFontInfo called by JSL instead of JSR so 
0025 7C2B              * can be used easily in patch file.
0026 7C2B              *
0027 7C2B              * 4/7/89            Mensch
0028 7C2B              * Made fastfont routines add spExtra and chExtra when calculating the
0029 7C2B              * width of a character. NOTE: the routine now uses a new zpage value
0030 7C2B              * called fastbucket, which is aliased over a variable used to apply styling.
0031 7C2B              *
0032 7C2B              * 4/10/89           Mensch
0033 7C2B              *
0034 7C2B              * God, how I hate mondays! Fixed a really stupid bug in fastfonts that
0035 7C2B              * caused 2 pixels to be added when spextra only indicated 1. Geez, I am
0036 7C2B              * a total spaz, I am so embarassed that I screwed up the build that I will leave
0037 7C2B              * this comment like this for future programmers to see my shame!
0038 7C2B              *
0039 7C2B              * 4/24/89           Mensch
0040 7C2B              * Fixed yet another bug with mono-spacing. That feature is dangerous and should 
0041 7C2B              * be removed (especially since it is only used by bone headed programmers!
0042 7C2B              *
0043 7C2B              * 27-Nov-91         Dave Lyons
0044 7C2B              *
0045 7C2B              * Changed InflateTextBuffer to return errors it gets while resizing
0046 7C2B              * the text buffers (including QD Aux's buffers).
0047 7C2B              *
0048 7C2B              * 3-Dec-91          Dave Lyons
0049 7C2B              *
0050 7C2B              * Finished fixing above--on failure, it needs to restore a few direct page
0051 7C2B              * locations, so we don't think the buffer has been inflated when it hasn't.
0052 7C2B              * (Since QuickDraw Aux chains in *after* the main QD buffer-resize routines,
0053 7C2B              * QD already decided it was okay to store the new buffer size values when
0054 7C2B              * QD Aux found it could not resize its buffers, so we have to undo the damage.)
0055 7C2B              *
0056 7C2B              ****************************************************************
0057 7C2B
0058 7C2B
0059 7C2B              ****************************************************************
0060 7C2B              *                                                              *
0061 7C2B              *                  Copyright (C) 1985-1989,1991                *
0062 7C2B              *                  All Rights Reserved                         *
0063 7C2B              *                  Apple Computer, Inc.                        *
0064 7C2B              *                                                              *
0065 7C2B              ****************************************************************
0066 7C2B
0067 7C2B                       blanks off 
0068 7C2B                       string asis 
0069 7C2B
0070 7C2B                       include 'all.macros' 
0071 7C2B
0072 7C2B
0073 7C2B                       macro 
0074 7C2B                       macswitch 
0075 7C2B                       mend 
0076 7C2B
0077 7C2B
0078 7C2B
0079 7C2B                       include ':QDEquates:qd.data.asm' 
0080 7C2B
0081 7C2B                       INCLUDE ':QDEquates:core.globals1' 
0082 7C2B                       INCLUDE ':QDEquates:core.globals2' 
0083 7C2B                       INCLUDE ':QDEquates:region.equs' 
0084 7C2B                       INCLUDE ':QDEquates:TextEquates' 
0085 7C2B                       INCLUDE ':QDEquates:fontequs' 
0086 7C2B
0087 7C2B
0088 7C2B
0089 7C2B
0090 7C2B
0091 7C2B
0092 7C2B              ;------------------------------------------
0093 7C2B              ;
0094 7C2B              ; Equates from procedure iSetUpFontInfo
0095 7C2B              ;
0096 7C2B              ;------------------------------------------
0097 7C2B              fbrExtent equ   fRectMax
0098 7C2B
0099 7C2B              ;-----------------------------------------------
0100 7C2B              ;
0101 7C2B              ;   Imported addresses
0102 7C2B              ;
0103 7C2B              ;-----------------------------------------------
0104 7C2B
0105 7C2B                       IMPORT BusyEC 
0106 7C2B                       IMPORT BusyEC0 
0107 7C2B                       IMPORT BusyEC10 
0108 7C2B                       IMPORT BusyEC2 
0109 7C2B                       IMPORT BusyEC4 
0110 7C2B                       IMPORT BusyEC6 
0111 7C2B                       IMPORT BusyEC8 
0112 7C2B                       IMPORT ConTable320 
0113 7C2B                       IMPORT ConTable640 
0114 7C2B                       IMPORT ExtendColorWord 
0115 7C2B                       IMPORT QDStart 
0116 7C2B                       IMPORT ShiftOut 
0117 7C2B                       IMPORT ShiftStay 
0118 7C2B                       IMPORT SystemFont 
0119 7C2B                       IMPORT TestGPs 
0120 7C2B                       IMPORT leftBitMask 
0121 7C2B                       IMPORT rightBitMask 
0122 7C2B
0123 7C2B              ;-----------------------------------------------
0124 7C2B              ;
0125 7C2B              ;   Forward addresses and entries
0126 7C2B              ;
0127 7C2B              ;-----------------------------------------------
0128 7C2B
0129 7C2B                       ENTRY CallText 
0130 7C2B                       ENTRY CallTxBounds 
0131 7C2B                       ENTRY CallWidth 
0132 7C2B                       ENTRY FastBigLoop 
0133 7C2B                       ENTRY GetFL 
0134 7C2B                       ENTRY GetRFRec 
0135 7C2B                       ENTRY InflateTB 
0136 7C2B                       ENTRY SlowBigLoop 
0137 7C2B                       ENTRY StuffBig0320 
0138 7C2B                       ENTRY StuffBig0640 
0139 7C2B                       ENTRY StuffBig1320 
0140 7C2B                       ENTRY StuffBig1640 
0141 7C2B                       ENTRY StuffBig2320 
0142 7C2B                       ENTRY StuffBig2640 
0143 7C2B                       ENTRY StuffBig3320 
0144 7C2B                       ENTRY StuffBig3640 
0145 7C2B                       ENTRY StuffBig4320 
0146 7C2B                       ENTRY StuffBig4640 
0147 7C2B                       ENTRY StuffBig5320 
0148 7C2B                       ENTRY StuffBig5640 
0149 7C2B                       ENTRY StuffBig6320 
0150 7C2B                       ENTRY StuffBig6640 
0151 7C2B                       ENTRY StuffBig7320 
0152 7C2B                       ENTRY StuffBig7640 
0153 7C2B                       ENTRY WCString 
0154 7C2B                       ENTRY WChar 
0155 7C2B                       ENTRY WText 
0156 7C2B                       ENTRY iBCString 
0157 7C2B                       ENTRY iBChar 
0158 7C2B                       ENTRY iBText 
0159 7C2B                       ENTRY iDCString 
0160 7C2B                       ENTRY iDChar 
0161 7C2B                       ENTRY iDText 
0162 7C2B
0163 7C2B              ;
0164 7C2B              ;                copy text/TextWidthCalls
0165 7C2B              ****************************************************************
0166 7C2B              *
0167 7C2B              * CharWidth
0168 7C2B              *              Char     word (input)
0169 7C2B              *              Width    word (output)
0170 7C2B              *
0171 7C2B              *
0172 7C2B              ****************************************************************
0173 7C2B                       EXPORT CharWidth 
0174 7C2B              CharWidth PROC 
0175 7C2B              *              USING PicInfo
0176 7C2B              OrigDirect equ   1
0177 7C2B              RTL1     equ   OrigDirect+2
0178 7C2B              RTL2     equ   RTL1+3
0179 7C2B              theChar  equ   RTL2+3
0180 7C2B              resultWidth equ   theChar+2
0181 7C2B
0182 7C2B 20 AA 0F              jsr   QDStart
0183 7C2E
0184 7C2E A3 09                 lda   TheChar,s
0185 7C30 29 FF 00              and   #$00FF                   ; added 2/10/89 mensch
0186 7C33 85 D6                 sta   charToDraw               ; Hey bennet make this right
0187 7C35
0188 7C35 A9 00 00              lda   #DrawCharVerb
0189 7C38 22 9F 7C FE           jsl   CallWidth
0190 7C3C
0191 7C3C A5 DE                 lda   TheWidth
0192 7C3E 83 0B                 sta   ResultWidth,s
0193 7C40
0194 7C40 4C 03 FC              jmp   BusyEC2
0195 7C43
0196 7C43                       ENDP 
0197 7C43              ****************************************************************
0198 7C43              *
0199 7C43              * StringWidth
0200 7C43              *              StringPtr     long (input)
0201 7C43              *              Width         word (output)
0202 7C43              *
0203 7C43              ****************************************************************
0204 7C43                       EXPORT StringWidth 
0205 7C43              StringWidth PROC 
0206 7C43              *              USING PicInfo
0207 7C43              OrigDirect equ   1
0208 7C43              RTL1     equ   OrigDirect+2
0209 7C43              RTL2     equ   RTL1+3
0210 7C43              StrPtr   equ   RTL2+3
0211 7C43              resultWidth equ   StrPtr+4
0212 7C43
0213 7C43 20 AA 0F              jsr   QDStart
0214 7C46
0215 7C46
0216 7C46              * Make this look just like DrawText
0217 7C46
0218 7C46 A3 09                 lda   StrPtr,s                 ; bennet will make these use
0219 7C48 85 DA                 sta   TextPtr                  ; the right names
0220 7C4A A3 0B                 lda   StrPtr+2,s
0221 7C4C 85 DC                 sta   TextPtr+2
0222 7C4E A7 DA                 lda   [TextPtr]
0223 7C50 29 FF 00              and   #lowByte
0224 7C53 85 D8                 sta   TextLength
0225 7C55 E6 DA D0 02           IncLong TextPtr 
0226 7C5B
0227 7C5B A9 01 00              lda   #DrawTextVerb
0228 7C5E 22 9F 7C FE           jsl   CallWidth
0229 7C62 A5 DE                 lda   theWidth
0230 7C64 83 0D                 sta   resultWidth,s
0231 7C66 4C 19 FC              jmp   BusyEC4
0232 7C69
0233 7C69                       ENDP 
0234 7C69
0235 7C69
0236 7C69              ****************************************************************
0237 7C69              *
0238 7C69              * TextWidth
0239 7C69              *              PtrToText : long (input)
0240 7C69              *              TextLength : word (input)
0241 7C69              *              Width:  word (output)
0242 7C69              *
0243 7C69              *
0244 7C69              ****************************************************************
0245 7C69                       EXPORT TextWidth 
0246 7C69              TextWidth PROC 
0247 7C69              *              USING PicInfo
0248 7C69              OrigDirect equ   1
0249 7C69              RTL1     equ   OrigDirect+2
0250 7C69              RTL2     equ   RTL1+3
0251 7C69              TheTextLength equ   RTL2+3
0252 7C69              TheTextPtr equ   TheTextLength+2
0253 7C69              resultWidth equ   theTextPtr+4
0254 7C69
0255 7C69 20 AA 0F              jsr   QDStart
0256 7C6C
0257 7C6C A3 0B                 lda   TheTextPtr,s
0258 7C6E 85 DA                 sta   TextPtr
0259 7C70 A3 0D                 lda   TheTextPtr+2,s
0260 7C72 85 DC                 sta   TextPtr+2
0261 7C74 A3 09                 lda   TheTextLength,s
0262 7C76 85 D8                 sta   TextLength
0263 7C78
0264 7C78 A9 01 00              lda   #DrawTextVerb
0265 7C7B 22 9F 7C FE           jsl   CallWidth
0266 7C7F A5 DE                 lda   theWidth
0267 7C81 83 0F                 sta   resultWidth,s
0268 7C83 4C 2F FC              jmp   BusyEC6
0269 7C86
0270 7C86                       ENDP 
0271 7C86
0272 7C86
0273 7C86
0274 7C86              ****************************************************************
0275 7C86              *
0276 7C86              * CStringWidth
0277 7C86              *              CStrPtr : long (input)
0278 7C86              *              Width:  word (output)
0279 7C86              *
0280 7C86              *
0281 7C86              ****************************************************************
0282 7C86                       EXPORT CStringWidth 
0283 7C86              CStringWidth PROC 
0284 7C86              OrigDirect equ   1
0285 7C86              RTL1     equ   OrigDirect+2
0286 7C86              RTL2     equ   RTL1+3
0287 7C86              CStrPtr  equ   RTL2+3
0288 7C86              resultWidth equ   CStrPtr+4
0289 7C86
0290 7C86 20 AA 0F              jsr   QDStart
0291 7C89
0292 7C89 A3 09                 lda   CStrPtr,s
0293 7C8B 85 DA                 sta   TextPtr
0294 7C8D A3 0B                 lda   CStrPtr+2,s
0295 7C8F 85 DC                 sta   TextPtr+2
0296 7C91
0297 7C91
0298 7C91 A9 02 00              lda   #DrawCStrVerb
0299 7C94 22 9F 7C FE           jsl   CallWidth
0300 7C98 A5 DE                 lda   theWidth
0301 7C9A 83 0D                 sta   resultWidth,s
0302 7C9C 4C 19 FC              jmp   BusyEC4
0303 7C9F
0304 7C9F                       ENDP 
0305 7C9F
0306 7C9F
0307 7C9F
0308 7C9F
0309 7C9F              ****************************************************************
0310 7C9F              *
0311 7C9F              * CallWidth
0312 7C9F              *
0313 7C9F              * This routine called by the entry points standard
0314 7C9F              * text inputs are on zero page.
0315 7C9F              *
0316 7C9F              * Zero page is already switched in by the time it gets here.
0317 7C9F              *
0318 7C9F              ****************************************************************
0319 7C9F                       EXPORT CallWidth 
0320 7C9F              CallWidth PROC 
0321 7C9F              *              using CoreDATA
0322 7C9F              *              using PicInfo
0323 7C9F              *              using QDProcs
0324 7C9F              *              using E0Vectors
0325 7C9F
0326 7C9F 85 38                 sta   DrawVerb
0327 7CA1
0328 7CA1 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
0329 7CA4 B0 04                 bcs   UseLocal
0330 7CA6
0331 7CA6 5C 2C 1E E0           jml   StdTxMeas
0332 7CAA
0333 7CAA
0334 7CAA 8B           UseLocal phb                            ; put extra byte on stack
0335 7CAB A0 28 00              ldy   #o_stdTxMeas             ; get adr of new text width routine
0336 7CAE B7 2A                 lda   [temp],y                 ; put on stack
0337 7CB0 48                    pha   
0338 7CB1 C8                    iny                            ; get bytes 2 and 3
0339 7CB2 B7 2A                 lda   [temp],y
0340 7CB4 83 02                 sta   2,s                      ; store middle byte twice
0341 7CB6 6B                    rtl                            ; call it
0342 7CB7
0343 7CB7                       ENDP 
0344 7CB7
0345 7CB7
0346 7CB7              ****************************************************************
0347 7CB7              *
0348 7CB7              * StdTxMeas
0349 7CB7              *
0350 7CB7              * Common text measuring routine that is central point for
0351 7CB7              * all text measuring routines.
0352 7CB7              *
0353 7CB7              * When control gets here, all inputs are on zero page.
0354 7CB7              *
0355 7CB7              * There are lots of possiblities as to what they are.  And the
0356 7CB7              * Draw verb is what tells us what to do.
0357 7CB7              *
0358 7CB7              *       For CharWidth
0359 7CB7              *               char is on zp at charToDraw
0360 7CB7              *
0361 7CB7              *       For TextWidth
0362 7CB7              *               pointer is on zp
0363 7CB7              *               length is on zp
0364 7CB7              *
0365 7CB7              *       For CStringWidth
0366 7CB7              *               pointer is on zp
0367 7CB7              *
0368 7CB7              ****************************************************************
0369 7CB7                       EXPORT iStdTxMeas 
0370 7CB7              iStdTxMeas PROC 
0371 7CB7              ;soon to be iStdTxMeas
0372 7CB7              *              using CoreDATA
0373 7CB7              *              using PicInfo
0374 7CB7              *              using QDProcs
0375 7CB7
0376 7CB7 A5 38                 lda   DrawVerb                 ; put verb in a
0377 7CB9 0A                    asl   a
0378 7CBA AA                    tax   
0379 7CBB 7C BE 7C              jmp   (DoWidthTable,x)
0380 7CBE
0381 7CBE              DoWidthTable                            ; 
0382 7CBE C4 7C                 DC W:WChar
0383 7CC0 D5 7C                 DC W:WText
0384 7CC2 D5 7C                 DC W:WCString
0385 7CC4
0386 7CC4                       ENDP 
0387 7CC4              ****************************************************************
0388 7CC4              *
0389 7CC4              * WChar
0390 7CC4              *
0391 7CC4              ****************************************************************
0392 7CC4                       EXPORT WChar 
0393 7CC4              WChar    PROC 
0394 7CC4              *              USING E0Vectors
0395 7CC4              *              USING CoreData
0396 7CC4              ;
0397 7CC4 A9 00 00              lda   #0                       ; use old font info
0398 7CC7 22 64 1F E0           jsl   SetUpFontInfo
0399 7CCB 22 50 1F E0           jsl   ValidChar
0400 7CCF 29 FF 00              and   #lowByte
0401 7CD2 85 DE                 sta   theWidth
0402 7CD4              ;
0403 7CD4              ;
0404 7CD4 6B                    rtl   
0405 7CD5
0406 7CD5                       ENDP 
0407 7CD5
0408 7CD5
0409 7CD5
0410 7CD5              ****************************************************************
0411 7CD5              *
0412 7CD5              * WText
0413 7CD5              *
0414 7CD5              *
0415 7CD5              ****************************************************************
0416 7CD5                       EXPORT WText 
0417 7CD5              WText    PROC 
0418 7CD5                       EXPORT WCString 
0419 7CD5              WCString                                ; 
0420 7CD5              *              USING E0Vectors
0421 7CD5              *              USING CoreData
0422 7CD5              ;
0423 7CD5 64 AC                 stz   currPen
0424 7CD7              ;
0425 7CD7 22 54 1F E0           jsl   GetNextChar
0426 7CDB B0 0B                 bcs   NullString
0427 7CDD              ;
0428 7CDD A9 00 00              lda   #0                       ; use old font info
0429 7CE0 22 64 1F E0           jsl   SetUpFontInfo
0430 7CE4 22 78 1F E0           jsl   BumpPen
0431 7CE8              ;
0432 7CE8              ;
0433 7CE8              NullString                              ; 
0434 7CE8 A5 AC                 lda   currPen
0435 7CEA 85 DE                 sta   theWidth
0436 7CEC 6B                    rtl   
0437 7CED              ;
0438 7CED                       ENDP 
0439 7CED              ;
0440 7CED              ;                copy text/TextDrawCalls
0441 7CED              ****************************************************************
0442 7CED              *
0443 7CED              * DrawChar
0444 7CED              *              Char     word
0445 7CED              *
0446 7CED              *
0447 7CED              ****************************************************************
0448 7CED                       EXPORT DrawChar 
0449 7CED              DrawChar PROC 
0450 7CED              *              USING PicInfo
0451 7CED              OrigDirect equ   1
0452 7CED              RTL1     equ   OrigDirect+2
0453 7CED              RTL2     equ   RTL1+3
0454 7CED              TheChar  equ   RTL2+3
0455 7CED
0456 7CED 20 AA 0F              jsr   QDStart
0457 7CF0
0458 7CF0 A3 09                 lda   TheChar,s
0459 7CF2 85 D6                 sta   charToDraw
0460 7CF4
0461 7CF4 A9 00 00              lda   #DrawCharVerb
0462 7CF7 22 4E 7D FE           jsl   CallText
0463 7CFB 4C 03 FC              jmp   BusyEC2
0464 7CFE
0465 7CFE                       ENDP 
0466 7CFE
0467 7CFE              ****************************************************************
0468 7CFE              *
0469 7CFE              * DrawString
0470 7CFE              *              StringPtr     long
0471 7CFE              *
0472 7CFE              ****************************************************************
0473 7CFE                       EXPORT DrawString 
0474 7CFE              DrawString PROC 
0475 7CFE              *              USING PicInfo
0476 7CFE              OrigDirect equ   1
0477 7CFE              RTL1     equ   OrigDirect+2
0478 7CFE              RTL2     equ   RTL1+3
0479 7CFE              StrPtr   equ   RTL2+3
0480 7CFE
0481 7CFE 20 AA 0F              jsr   QDStart
0482 7D01
0483 7D01 A3 09                 lda   StrPtr,s                 ; bennet will make these use
0484 7D03 85 DA                 sta   TextPtr                  ; the right names
0485 7D05 A3 0B                 lda   StrPtr+2,s
0486 7D07 85 DC                 sta   TextPtr+2
0487 7D09 A7 DA                 lda   [TextPtr]
0488 7D0B 29 FF 00              and   #lowByte
0489 7D0E 85 D8                 sta   TextLength
0490 7D10 E6 DA D0 02           IncLong TextPtr 
0491 7D16
0492 7D16 A9 01 00              lda   #DrawTextVerb
0493 7D19 22 4E 7D FE           jsl   CallText
0494 7D1D 4C 19 FC              jmp   BusyEC4
0495 7D20
0496 7D20                       ENDP 
0497 7D20
0498 7D20
0499 7D20              ****************************************************************
0500 7D20              *
0501 7D20              * DrawText
0502 7D20              *              PtrToText : long
0503 7D20              *              TextLength : word
0504 7D20              *
0505 7D20              *
0506 7D20              ****************************************************************
0507 7D20                       EXPORT DrawText 
0508 7D20              DrawText PROC 
0509 7D20              *              USING PicInfo
0510 7D20              OrigDirect equ   1
0511 7D20              RTL1     equ   OrigDirect+2
0512 7D20              RTL2     equ   RTL1+3
0513 7D20              TheTextLength equ   RTL2+3
0514 7D20              TheTextPtr equ   TheTextLength+2
0515 7D20
0516 7D20 20 AA 0F              jsr   QDStart
0517 7D23
0518 7D23 A3 0B                 lda   TheTextPtr,s
0519 7D25              ;
0520 7D25 85 DA                 sta   TextPtr
0521 7D27 A3 0D                 lda   TheTextPtr+2,s
0522 7D29 85 DC                 sta   TextPtr+2
0523 7D2B A3 09                 lda   TheTextLength,s
0524 7D2D 85 D8                 sta   TextLength
0525 7D2F
0526 7D2F A9 01 00              lda   #DrawTextVerb
0527 7D32 22 4E 7D FE           jsl   CallText
0528 7D36 4C 2F FC              jmp   BusyEC6
0529 7D39
0530 7D39                       ENDP 
0531 7D39
0532 7D39
0533 7D39              ****************************************************************
0534 7D39              *
0535 7D39              * DrawCString
0536 7D39              *              CStrPtr : long
0537 7D39              *
0538 7D39              *
0539 7D39              ****************************************************************
0540 7D39                       EXPORT DrawCString 
0541 7D39              DrawCString PROC 
0542 7D39              OrigDirect equ   1
0543 7D39              RTL1     equ   OrigDirect+2
0544 7D39              RTL2     equ   RTL1+3
0545 7D39              CStrPtr  equ   RTL2+3
0546 7D39
0547 7D39 20 AA 0F              jsr   QDStart
0548 7D3C
0549 7D3C A3 09                 lda   CStrPtr,s
0550 7D3E 85 DA                 sta   TextPtr
0551 7D40 A3 0B                 lda   CStrPtr+2,s
0552 7D42 85 DC                 sta   TextPtr+2
0553 7D44
0554 7D44
0555 7D44 A9 02 00              lda   #DrawCStrVerb
0556 7D47 22 4E 7D FE           jsl   CallText
0557 7D4B 4C 19 FC              jmp   BusyEC4
0558 7D4E
0559 7D4E                       ENDP 
0560 7D4E
0561 7D4E
0562 7D4E
0563 7D4E
0564 7D4E              ****************************************************************
0565 7D4E              *
0566 7D4E              * CallText
0567 7D4E              *
0568 7D4E              * This routine called by the entry points standard
0569 7D4E              * text inputs are on zero page.
0570 7D4E              *
0571 7D4E              * Zero page is already switched in by the time it gets here.
0572 7D4E              *
0573 7D4E              ****************************************************************
0574 7D4E                       EXPORT CallText 
0575 7D4E              CallText PROC 
0576 7D4E              *              using CoreDATA
0577 7D4E              *              using PicInfo
0578 7D4E              *              using QDProcs
0579 7D4E              *              using E0Vectors
0580 7D4E
0581 7D4E 85 38                 sta   DrawVerb
0582 7D50
0583 7D50 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
0584 7D53 B0 04                 bcs   UseLocal
0585 7D55
0586 7D55 5C 04 1E E0           jml   StdText
0587 7D59
0588 7D59
0589 7D59 8B           UseLocal phb                            ; put extra byte on stack
0590 7D5A A0 00 00              ldy   #o_stdtext               ; get adr of new text routine
0591 7D5D B7 2A                 lda   [temp],y                 ; put on stack
0592 7D5F 48                    pha   
0593 7D60 C8                    iny                            ; get bytes 2 and 3
0594 7D61 B7 2A                 lda   [temp],y
0595 7D63 83 02                 sta   2,s                      ; store middle byte twice
0596 7D65 6B                    rtl                            ; call it
0597 7D66
0598 7D66                       ENDP 
0599 7D66
0600 7D66
0601 7D66              ****************************************************************
0602 7D66              *
0603 7D66              * StdText
0604 7D66              *
0605 7D66              * Common text routine that is central point for
0606 7D66              * all text drawing routines.
0607 7D66              *
0608 7D66              * When control gets here, all inputs are on zero page.
0609 7D66              *
0610 7D66              * There are lots of possiblities as to what they are.  And the
0611 7D66              * Draw verb is what tells us what to do.
0612 7D66              *
0613 7D66              *       For DrawChar
0614 7D66              *               char is on zp at charToDraw
0615 7D66              *
0616 7D66              *       For DrawText
0617 7D66              *               pointer is on zp
0618 7D66              *               length is on zp
0619 7D66              *
0620 7D66              *       For DrawCString
0621 7D66              *               pointer is on zp
0622 7D66              *
0623 7D66              ****************************************************************
0624 7D66                       EXPORT iStdText 
0625 7D66              iStdText PROC 
0626 7D66              *              using CoreDATA
0627 7D66              *              using PicInfo
0628 7D66              *              using QDProcs
0629 7D66              *              using E0Vectors
0630 7D66
0631 7D66 A9 00 00              lda   #TextNoun
0632 7D69 22 F8 1E E0           jsl   PutPictStuff             ; inputs on zp and in a-reg
0633 7D6D
0634 7D6D A5 38                 lda   DrawVerb                 ; put verb in a
0635 7D6F 0A                    asl   a
0636 7D70 AA                    tax   
0637 7D71 7C 74 7D              jmp   (DoTextTable,x)
0638 7D74
0639 7D74              DoTextTable                             ; 
0640 7D74 7A 7D                 DC W:iDChar
0641 7D76 E1 81                 DC W:iDText
0642 7D78 E1 81                 DC W:iDCString
0643 7D7A                       ENDP 
0644 7D7A
0645 7D7A              *****************************************
0646 7D7A              *                                       *
0647 7D7A              *  current date and time:               *
0648 7D7A              *    11:30 AM, 5/2/86                   *
0649 7D7A              *                                       *
0650 7D7A              *****************************************
0651 7D7A              ;
0652 7D7A              *******************************************************************************
0653 7D7A              *                                                                             *
0654 7D7A              *              subroutine DChar                                               *
0655 7D7A              *                                                                             *
0656 7D7A              *                                       started 4/2/86 or before              *
0657 7D7A              *                                       Bennet Marks x6245                    *
0658 7D7A              *                                                                             *
0659 7D7A              *  ABSTRACT:  this is the framing routine which is used by DrawChar to draw a *
0660 7D7A              *  character into the current grafport's pixelmap.  It does everything that   *
0661 7D7A              *  DrawChar wants - see external documentation.                               *
0662 7D7A              *                                                                             *
0663 7D7A              *  ASSUMPTIONS:  Very few.  QD II must be active.  The character to be drawn  *
0664 7D7A              *  must be in charToDraw.  That kind of thing.                                *
0665 7D7A              *                                                                             *
0666 7D7A              *  RETURNS:  pnLoc.H in the current grafport is increased by the character    *
0667 7D7A              *  width, whether or not the character was actually drawn.                    *
0668 7D7A              *                                                                             *
0669 7D7A              *  ALTERS:  most if not all of the QD II globals may be changed by this rou-  *
0670 7D7A              *  tine.                                                                      *
0671 7D7A              *                                                                             *
0672 7D7A              *  NOTES:  DBR is preserved.                                                  *
0673 7D7A              *                                                                             *
0674 7D7A              *  DChar returns with an RTL.                                                 *
0675 7D7A              *                                                                             *
0676 7D7A              *******************************************************************************
0677 7D7A              ;
0678 7D7A              *****************************************
0679 7D7A              *                                       *
0680 7D7A              *  V.0.1.0 - 4/2/86                     *
0681 7D7A              *    changed for style mods - 5/2/86,   *
0682 7D7A              *    BHM                                *
0683 7D7A              *                                       *
0684 7D7A              *****************************************
0685 7D7A              ;
0686 7D7A                       EXPORT iDChar 
0687 7D7A              iDChar   PROC 
0688 7D7A                       Import fastPutChar 
0689 7D7A              *              using E0Vectors
0690 7D7A              *              using CoreData
0691 7D7A              ;
0692 7D7A 22 3C 1E E0           jsl   PortLoc2ZP               ; bring down the dest info
0693 7D7E 22 A0 1E E0           jsl   SetUpPortRegions
0694 7D82
0695 7D82 A9 FF FF              lda   #-1                      ; flag that says its ok to use fastfont info...
0696 7D85 22 64 1F E0           jsl   SetUpFontInfo
0697 7D89 A0 42 00              ldy   #(O_pnLoc+O_H)
0698 7D8C B7 24                 lda   [portRef],y              ;pnLoc.H
0699 7D8E 85 AC                 sta   currPen
0700 7D90              ;
0701 7D90 22 58 1F E0           jsl   CalcDrawStatus           ;check for invis. pen or null minRect
0702 7D94 90 11                 bcc   GoodDrawStatus
0703 7D96              ;bad draw status:
0704 7D96              ; or, bad fast character, both go here!
0705 7D96 22 50 1F E0           jsl   ValidChar
0706 7D9A 29 FF 00              and   #lowByte                 ;get character width
0707 7D9D 18                    clc   
0708 7D9E 65 AC                 adc   currPen                  ;add to current pen
0709 7DA0 A0 42 00              ldy   #(O_pnLoc+O_H)
0710 7DA3 97 24                 sta   [portRef],y              ;and replace in grafport
0711 7DA5 80 41                 bra   BadDrawStatus
0712 7DA7              ;
0713 7DA7              ; This is where we fall when you have a bad fastDrawStatus
0714 7DA7              ;
0715 7DA7              GoodDrawStatus                          ; 
0716 7DA7              ;
0717 7DA7              ; Modified 2/10/89
0718 7DA7              ; This tests for fast font routines...
0719 7DA7              ; first test the high bit of the font handle to see if it is set,
0720 7DA7              ; if it is, we will call the fast text routines!
0721 7DA7 08                    php   
0722 7DA8 24 F6                 bit   <fontFlags
0723 7DAA 70 03                 bvs   @stillfast
0724 7DAC 28                    plp   
0725 7DAD 80 0D                 bra   iDCharOldWay
0726 7DAF 28           @StillFast plp   
0727 7DB0              ;	ldy	#O_Font+2
0728 7DB0              ;	lda	[<PortRef],y	; get the high word of the font handle...
0729 7DB0              ;	bpl	iDCharOldWay	; if clear, forget this next stuff
0730 7DB0 50 03                 bvc   BadFastChar              ; if overflow clear the regions aren't rects...
0731 7DB2 82 38 00              brl   tryFastChar              ; try drawing the character the fast way...
0732 7DB5              ;
0733 7DB5              ; This is the alternate entry to draw a character the old way!
0734 7DB5              BadFastChar  
0735 7DB5 A9 00 00              lda   #0
0736 7DB8 22 64 1F E0           jsl   SetUpFontInfo            ; set up the original fonts info...
0737 7DBC              ; and drop right thru to the good draw routine...
0738 7DBC                       Export iDCharOldWay 
0739 7DBC              iDCharOldWay  
0740 7DBC              ;
0741 7DBC              ****  ADDED 3/10/87	TO USE USE CALCSLOP
0742 7DBC              ;
0743 7DBC 22 F4 1F E0           jsl   CalcSlop
0744 7DC0              ;
0745 7DC0              ;now SetUpBufInfo can use the slop value
0746 7DC0              ;
0747 7DC0              ***  END OF CHANGE - BHM  x6245
0748 7DC0              ;
0749 7DC0 22 68 1F E0           jsl   SetUpBufInfo
0750 7DC4 22 74 1F E0           jsl   PutChar
0751 7DC8 A5 90                 lda   bufPen                   ;final pen position, buffer coords
0752 7DCA 18                    clc   
0753 7DCB 65 A0                 adc   hBufToLoc                ;switch to local
0754 7DCD A0 42 00              ldy   #(O_pnLoc+O_H)
0755 7DD0 97 24                 sta   [portRef],y
0756 7DD2              ;
0757 7DD2 22 B0 1F E0           jsl   StyleText                ;perform style mods, if needed
0758 7DD6              ;get intersection of active text buffer and minRect:
0759 7DD6 22 5C 1F E0           jsl   TextAndMinRect
0760 7DDA B0 08                 bcs   NullInt                  ;intersection was null
0761 7DDC              ;no, it wasn't:
0762 7DDC 22 60 1F E0           jsl   CalcTextBounds           ;get parameters for transfer
0763 7DE0 22 F4 1E E0           jsl   BlowItUp                 ;transfer into destination pixelmap
0764 7DE4              ;
0765 7DE4              NullInt                                 ; 
0766 7DE4 22 7C 1F E0           jsl   CleanUpBuffer
0767 7DE8              ;
0768 7DE8              BadDrawStatus                           ; 
0769 7DE8              ;
0770 7DE8 22 A8 1E E0           jsl   FreePortRegions
0771 7DEC 6B                    rtl   
0772 7DED              ;
0773 7DED              ;
0774 7DED              ; NEW: this is the faster drawchar routine, this routine will test to see that the
0775 7DED              ; char we want to draw can be drawn into the current minrect, if not, we bag it
0776 7DED              ; and do it the old way!
0777 7DED              tryFastChar  
0778 7DED              ; Create a character rectangle in local coordinants now...
0779 7DED
0780 7DED A0 40 00              ldy   #o_PnLoc+o_V             ; offset to pen loc.v
0781 7DF0 B7 24                 lda   [<portRef],y
0782 7DF2 18                    clc                            ; set to add an extra 1
0783 7DF3 65 E2                 adc   <descent                 ; add the fonts descent to this value
0784 7DF5 C5 04                 cmp   <MinRect+o_V2            ; see if we are within bounds...
0785 7DF7 F0 02                 beq   @1
0786 7DF9 10 32                 bpl   notWhole                 ; this is the bottom
0787 7DFB              @1        
0788 7DFB 85 04                 sta   <MinRect+o_V2
0789 7DFD              ; NOTE: this next subtract RELY's on the carry being clear from above compare!
0790 7DFD 38                    sec   
0791 7DFE E5 E2                 sbc   <descent                 ; now create the top of our character rectangle
0792 7E00 E5 84                 sbc   <ascent                  ; by subtracting the character ascent and decsent
0793 7E02 85 90                 sta   <charRect+o_V1
0794 7E04 C5 00                 cmp   <MinRect+o_V1            ; see if we are too high
0795 7E06 30 25                 bmi   notWhole
0796 7E08 85 00                 sta   <MinRect+o_V1
0797 7E0A A5 AC                 lda   <CurrPen                 ; offset to penloc.H
0798 7E0C 85 92                 sta   <charRect+o_H1           ; make this the right edge
0799 7E0E C5 02                 cmp   <MinRect+o_H1
0800 7E10 30 1B                 bmi   NotWhole
0801 7E12 85 02                 sta   <MinRect+o_H1
0802 7E14              ; now get the right edge...
0803 7E14 22 50 1F E0           jsl   validChar                ; get the width of the character
0804 7E18 C9 0D 00              cmp   #13                      ; see if its too big...
0805 7E1B 90 03                 blt   @2
0806 7E1D A9 0C 00              lda   #12                      ; max char width = 12...
0807 7E20              @2        
0808 7E20 18                    clc   
0809 7E21 85 DE                 sta   <theWidth                ; save the width of this character
0810 7E23 65 92                 adc   <charRect+o_H1
0811 7E25 C5 06                 cmp   <MinRect+o_H2
0812 7E27 10 04                 bpl   notWhole
0813 7E29 85 06                 sta   <minRect+o_H2
0814 7E2B 80 03                 bra   goFast                   ; if we get this far, we can do the fast drawing
0815 7E2D 82 85 FF     notWhole brl   badFastChar              ; if not whole, just do it the old way...
0816 7E30              ;
0817 7E30              ; If we get this far, then we can go the fast way!
0818 7E30              goFast    
0819 7E30              ; we must now convert our rectangle to 'global' locinfo coordinants
0820 7E30              ; we do this by first creating an 'offset' to add to our rectangle... NOTE: this now only
0821 7E30              ; operates on the top left
0822 7E30
0823 7E30 A5 90                 lda   <charRect+o_V1
0824 7E32 38                    sec   
0825 7E33 E5 14                 sbc   <boundsRect+o_V1
0826 7E35 85 90                 sta   charRect+o_V1
0827 7E37 30 F4                 bmi   notWhole                 ; if this is negative, somethings wrong..
0828 7E39
0829 7E39 A5 92                 lda   <charRect+o_H1
0830 7E3B 38                    sec   
0831 7E3C E5 16                 sbc   <boundsRect+o_H1
0832 7E3E 85 92                 sta   charRect+o_H1
0833 7E40 30 EB                 bmi   notWhole                 ; if this is negative, somethings wrong..
0834 7E42
0835 7E42              ; now that I have the proper offset for the character, I will compute the characters
0836 7E42              ; location in memory based on the locinfo record...
0837 7E42              ;
0838 7E42              ; IMPORTANT for improved drawing we must now call shield cursor!
0839 7E42              ; NOTE MinRect now contains our character rectangle!
0840 7E42 22 98 1E E0           jsl   ShieldCursor             ; and shield the cursor now!
0841 7E46
0842 7E46 64 AA                 stz   <fastLineStat
0843 7E48
0844 7E48 A5 12                 lda   <width
0845 7E4A C9 A0 00              cmp   #$00A0                   ; special case for screen port rects
0846 7E4D D0 1A                 bne   @doMult1
0847 7E4F A5 90                 lda   charRect+o_V1            ; get the character rectangle top
0848 7E51 C9 90 01              cmp   #400                     ; see if we rolled over the top of the mult below
0849 7E54 B0 11                 bge   @DoMult2
0850 7E56 0A                    asl   a                        ; multiply it by 32 first..
0851 7E57 0A                    asl   a
0852 7E58 0A                    asl   a
0853 7E59 0A                    asl   a
0854 7E5A 0A                    asl   a
0855 7E5B 85 A0                 sta   Mult1
0856 7E5D 0A                    asl   a
0857 7E5E 0A                    asl   a
0858 7E5F 18                    clc   
0859 7E60 65 A0                 adc   Mult1
0860 7E62 A2 00 00              ldx   #0
0861 7E65 80 0B                 bra   @DoMult3
0862 7E67 A5 12        @DoMult2 lda   <width
0863 7E69 85 A2        @DoMult1 sta   Mult2                    ; save it for the multiply
0864 7E6B A5 90                 lda   charRect                 ; get the v1 coordinant
0865 7E6D 85 A0                 sta   Mult1
0866 7E6F 20 7B 7F              jsr   DoMultiply               ; multiply these two numbers
0867 7E72              @DoMult3  
0868 7E72              ; once we have it this far, we can create the address of the starting scan line to 
0869 7E72              ; draw upon...
0870 7E72 65 0E                 adc   <imageRef                ; add to the base image reference
0871 7E74 85 94                 sta   destRef                  ; save this for a second...
0872 7E76 8A                    txa   
0873 7E77 65 10                 adc   <imageRef+2              ; and create the high word
0874 7E79 85 96                 sta   destRef+2
0875 7E7B
0876 7E7B A5 92                 lda   <CharRect+o_H1           ; now compute the offset into destref
0877 7E7D 4A                    lsr   a                        ; divide this by 4(pixels per byte)
0878 7E7E 4A                    lsr   a
0879 7E7F 18                    clc                            ; and add it in creating our final offset
0880 7E80 65 94                 adc   destRef
0881 7E82 85 94                 sta   destRef
0882 7E84 90 02                 bcc   @1
0883 7E86 E6 96                 inc   destRef+2
0884 7E88              @1        
0885 7E88              ;
0886 7E88              ; Added notes: the following is called from
0887 7E88                       export DrawOneFromaLine 
0888 7E88              DrawOneFromaLine  
0889 7E88
0890 7E88              ; Now bump the point to reflect the new position
0891 7E88 A5 DE                 lda   <theWidth
0892 7E8A              ; DRAT big bug here, didn't have the carry clear so text was a little longer than it
0893 7E8A              ; should have been when using spExtra! this has been curred! (Now I clear the carry)
0894 7E8A 18                    clc                            ; clear the carry, valid char no longer does this
0895 7E8B 65 AC                 adc   <currPen
0896 7E8D 85 AC                 sta   <currPen
0897 7E8F              ;
0898 7E8F              ; This can be called if lines calc <currpen for us...
0899 7E8F              ;
0900 7E8F              ; and now deref points to the proper scan line and create the proper shifting info
0901 7E8F
0902 7E8F A5 92                 lda   <CharRect+o_H1           ; now compute the initial offset and shift value
0903 7E91 29 03 00              and   #$0003                   ; get the shift over value...
0904 7E94 D0 26                 bne   @MustShift               ; see if we must do any shifting
0905 7E96 64 A4                 stz   <shiftInfo               ; zero out shift info...
0906 7E98              ; Ignore the left mask, unused...
0907 7E98              ; NOTE: we also don't have to do those funky shifts that we had to do below
0908 7E98 65 DE                 adc   <theWidth                ; add the width
0909 7E9A 29 07 00              and   #$0007                   ; only need the last 3 bits
0910 7E9D 0A                    asl   a                        ; to create the right mask...
0911 7E9E AA                    tax   
0912 7E9F BF A2 7F FE           lda   >rMaskTbl,x
0913 7EA3 85 9E                 sta   <FastMaskRight
0914 7EA5              ; now copy the strike pointer...
0915 7EA5 A5 D6                 lda   <charToDraw              ; get the character to draw
0916 7EA7 0A                    asl   a                        ; create the table offset
0917 7EA8 69 00 01              adc   #$0100                   ; add 100 since the table is offset by that much
0918 7EAB A8                    tay                            ; use this as an index
0919 7EAC B7 70                 lda   [<fastHeadPtr],y
0920 7EAE 65 74                 adc   <fontStrike1             ; get the low word
0921 7EB0 85 98                 sta   <srcRef                  ; and save this as our source reference
0922 7EB2 A5 76                 lda   <fontStrike1+2
0923 7EB4 85 9A                 sta   <srcRef+2
0924 7EB6 90 02                 bcc   @12
0925 7EB8 E6 9A                 inc   SrcRef+2
0926 7EBA              @12       
0927 7EBA              ;
0928 7EBA              ;	lda	<fontStrike1	; get the low word
0929 7EBA              ;	sta	<srcRef	; and save this as our source reference
0930 7EBA              ;	lda	<fontStrike1+2
0931 7EBA              ;	sta	<srcRef+2
0932 7EBA 80 33                 bra   @NoShiftReEntry
0933 7EBC              @MustShift  
0934 7EBC              ; If we get here we must have had to do a buncha shifting...
0935 7EBC 85 A4                 sta   <shiftinfo
0936 7EBE 0A                    asl   a                        ; and save it...
0937 7EBF AA                    tax                            ; now use it as a table offset
0938 7EC0 BF 9A 7F FE           lda   >lMaskTbl,x
0939 7EC4 85 9C                 sta   <fastMaskLeft
0940 7EC6 8A                    txa   
0941 7EC7 4A                    lsr   a                        ; get the shift offset back again
0942 7EC8 65 DE                 adc   <theWidth                ; add the characters width...
0943 7ECA 29 07 00              and   #$0007                   ; we are only interested in the last 3 bits...
0944 7ECD 0A                    asl   a                        ; multiply by 2 for a table offset
0945 7ECE AA                    tax                            ; put x into <A>
0946 7ECF BF A2 7F FE           lda   >rMaskTbl,x              ; and get the right mask...
0947 7ED3 85 9E                 sta   <fastMaskRight
0948 7ED5              ;
0949 7ED5 A5 A4                 lda   <shiftInfo               ; but first, multiply our offset by 2 again
0950 7ED7 0A                    asl   a                        ; cuase this is a table of ptrs...
0951 7ED8 0A                    asl   a
0952 7ED9 AA                    tax   
0953 7EDA A5 D6                 lda   <charToDraw              ; get the character to draw
0954 7EDC 0A                    asl   a                        ; create the table offset
0955 7EDD 69 00 01              adc   #$0100                   ; add 100 since the table is offset by that much
0956 7EE0 A8                    tay                            ; use this as an index
0957 7EE1 B7 70                 lda   [<fastHeadPtr],y
0958 7EE3 75 74                 adc   <fontStrike1,x           ; get the low word
0959 7EE5 85 98                 sta   <srcRef                  ; and save this as our source reference
0960 7EE7 B5 76                 lda   <fontStrike1+2,x
0961 7EE9 85 9A                 sta   <srcRef+2
0962 7EEB 90 02                 bcc   @1
0963 7EED E6 9A                 inc   SrcRef+2
0964 7EEF              @1        
0965 7EEF              ;
0966 7EEF              ; Now finish creating our destination pointer...
0967 7EEF              @NoShiftReEntry  
0968 7EEF              ;	lda	<CharRect+o_H1	; now compute the offset into destref
0969 7EEF              ;	lsr	a	; divide this by 4(pixels per byte)
0970 7EEF              ;	lsr	a
0971 7EEF              ;	clc		; and add it in creating our final offset
0972 7EEF              ;	adc	destRef
0973 7EEF              ;	sta	destRef
0974 7EEF              ;	bcc	@1
0975 7EEF              ;	inc	destRef+2
0976 7EEF              ;@1
0977 7EEF              ; At this point deref now points us to the final offset in the grafport to draw our
0978 7EEF              ; character. Now we need to do some character stuff...
0979 7EEF
0980 7EEF              ; and bump our source ref to reflect the character offset...
0981 7EEF              ;
0982 7EEF              ; NOTE: with the new fast font record, we could change this!, it would become...
0983 7EEF              ;
0984 7EEF              ;	lda	<charToDraw	; get the character to draw
0985 7EEF              ;	asl	a	; create the table offset
0986 7EEF              ;	adc	#$0100	; add 100 since the table is offset by that much
0987 7EEF              ;	tay		; use this as an index
0988 7EEF              ;	lda	[<fastHeadPtr],y
0989 7EEF              ;	adc	<srcRef	; add it to the source ref
0990 7EEF              ;	sta	<srcRef
0991 7EEF              ;	bcc	@100
0992 7EEF              ;	inc	<srcRef+2
0993 7EEF              ;@100
0994 7EEF              ; We now have srcref set up to point to the character to draw, destref set up
0995 7EEF              ; to point to the location to start drawing it. maskright and maskleft set to
0996 7EEF              ; the proper masking for the edges, theWidth set to the character width and
0997 7EEF              ; shiftinfo set to the number of pixels *2 to shift, now with all that set we can
0998 7EEF              ; call fastputchar
0999 7EEF 20 B2 7F              jsr   fastputChar
1000 7EF2 A5 AA                 lda   <fastLineStat            ; test to see if we are drawing a fast line
1001 7EF4 D0 0E                 bne   endForLine
1002 7EF6 A5 AC                 lda   <currPen                 ; update currPen properly...
1003 7EF8 A0 42 00              ldy   #o_PnLoc+o_H
1004 7EFB 97 24                 sta   [<portRef],y
1005 7EFD 22 9C 1E E0           jsl   UnShieldCursor           ; turn the cursor back on again
1006 7F01 82 E4 FE              brl   BadDrawStatus
1007 7F04 60           EndForLine rts   
1008 7F05                       Export MakeFastFontInfo 
1009 7F05                       Export MakeFastFontInfo2 
1010 7F05              MakeFastFontInfo  
1011 7F05
1012 7F05 A0 74 00              ldy   #o_Font                  ; first load and deref the font handle
1013 7F08 B7 24                 lda   [<portRef],y             ; get the font handle
1014 7F0A 85 70                 sta   <fontHeadPtr
1015 7F0C C8                    iny   
1016 7F0D C8                    iny   
1017 7F0E B7 24                 lda   [<portRef],y
1018 7F10 85 72                 sta   <fastHeadPtr+2
1019 7F12              MakeFastFontInfo2  
1020 7F12 A0 02 00              ldy   #2
1021 7F15 B7 70                 lda   [<fastHeadPtr],y
1022 7F17 AA                    tax   
1023 7F18 A7 70                 lda   [<fastHeadPtr]
1024 7F1A 85 70                 sta   <fastHeadPtr
1025 7F1C 8A                    txa   
1026 7F1D 09 00 80              ora   #$8000
1027 7F20 85 72                 sta   <fastHeadPtr+2
1028 7F22 AA                    tax   
1029 7F23 A5 70                 lda   <fastHeadPtr             ; A and X now contain the pointer to our data
1030 7F25
1031 7F25              ; create the 4 font strike pointers here
1032 7F25 18                    clc                            ; now offset to the first strike...
1033 7F26 69 12 03              adc   #o_FFEndOfTables
1034 7F29 90 02                 bcc   @1
1035 7F2B E8                    inx   
1036 7F2C 18                    clc   
1037 7F2D              @1        
1038 7F2D 86 76                 stx   <fontStrike1+2
1039 7F2F 85 74                 sta   <fontStrike1
1040 7F31
1041 7F31 A0 0E 00              ldy   #o_StrikeSize            ; and create the other 3 pointers...
1042 7F34 77 70                 adc   [<fastHeadPtr],y
1043 7F36 90 02                 bcc   @2
1044 7F38 E8                    inx   
1045 7F39 18                    clc   
1046 7F3A              @2        
1047 7F3A 86 7A                 stx   <fontStrike2+2
1048 7F3C 85 78                 sta   <fontStrike2
1049 7F3E
1050 7F3E 77 70                 adc   [<fastHeadPtr],y
1051 7F40 90 02                 bcc   @3
1052 7F42 E8                    inx   
1053 7F43 18                    clc   
1054 7F44              @3        
1055 7F44 86 7E                 stx   <fontStrike3+2
1056 7F46 85 7C                 sta   <fontStrike3
1057 7F48
1058 7F48 77 70                 adc   [<fastHeadPtr],y
1059 7F4A 90 02                 bcc   @4
1060 7F4C E8                    inx   
1061 7F4D 18                    clc   
1062 7F4E              @4        
1063 7F4E 86 82                 stx   <fontStrike4+2
1064 7F50 85 80                 sta   <fontStrike4
1065 7F52
1066 7F52              ;
1067 7F52              ; Now set up the rest of the font info here so we can use it!
1068 7F52 A0 00 00              ldy   #o_ffAscent
1069 7F55 B7 70                 lda   [<fastHeadPtr],y
1070 7F57 85 84                 sta   <Ascent
1071 7F59 A0 02 00              ldy   #o_ffDescent
1072 7F5C B7 70                 lda   [<fastHeadPtr],y
1073 7F5E 85 E2                 sta   <descent
1074 7F60 A0 08 00              ldy   #o_FFrowBytes
1075 7F63 B7 70                 lda   [<fastHeadPtr],y
1076 7F65 85 86                 sta   <rowBytes
1077 7F67 A0 04 00              ldy   #o_FFMaxWidth
1078 7F6A B7 70                 lda   [<fastHeadPtr],y
1079 7F6C 85 E0                 sta   <widMax
1080 7F6E
1081 7F6E              ; now set fast head ptr to point to the width table!
1082 7F6E A5 70                 lda   <fastHeadPtr
1083 7F70 18                    clc   
1084 7F71 69 12 00              adc   #o_FFSizeofVars
1085 7F74 85 70                 sta   <fastHeadPtr
1086 7F76 90 02                 bcc   @5
1087 7F78 E6 72                 inc   <fastHeadPtr+2
1088 7F7A              @5        
1089 7F7A              ; use the following once we need it!
1090 7F7A 6B                    rtl   
1091 7F7B              ;
1092 7F7B              ; Fast multiply routine, just in case I need it for something!
1093 7F7B              ;
1094 7F7B                       Export DoMultiply 
1095 7F7B              DoMultiply  
1096 7F7B A2 00 00              ldx   #0                       ; init our carry over area
1097 7F7E A9 00 00              lda   #0
1098 7F81 46 A0        dm0010   lsr   Mult1                    ; shift for first test
1099 7F83 F0 0C                 beq   dmLastOne                ; handle the last multiply
1100 7F85 90 06                 bcc   dm0020
1101 7F87 18                    clc   
1102 7F88 65 A2                 adc   Mult2
1103 7F8A 90 01                 bcc   dm0020                   ; if carry clear we didn't role the bank yet..
1104 7F8C E8                    inx                            ; if carry set, role the bank!
1105 7F8D 06 A2        dm0020   asl   Mult2
1106 7F8F 80 F0                 bra   dm0010
1107 7F91 90 06        dmLastOne bcc   done
1108 7F93 18                    clc   
1109 7F94 65 A2                 adc   Mult2
1110 7F96 90 01                 bcc   done                     ; carry clear no bank role
1111 7F98 E8                    inx   
1112 7F99              done      
1113 7F99              ;	sta	Mult1	; turns out wo don't need to save em..
1114 7F99              ;	stx	Mult2
1115 7F99 60                    rts   
1116 7F9A
1117 7F9A FF FF        lMaskTbl DC W:$FFFF
1118 7F9C 3F FF                 DC W:$FF3F
1119 7F9E 0F FF                 DC W:$FF0F
1120 7FA0 03 FF                 DC W:$FF03
1121 7FA2 FF FF        rMaskTbl DC W:$FFFF                     ; this table is gonna be a bit bigger...
1122 7FA4 C0 00                 DC W:$00C0                     ; 1 pixel
1123 7FA6 F0 00                 DC W:$00F0
1124 7FA8 FC 00                 DC W:$00FC
1125 7FAA FF 00                 DC W:$00FF
1126 7FAC FF C0                 DC W:$C0FF
1127 7FAE FF F0                 DC W:$F0FF
1128 7FB0 FF FC                 DC W:$FCFF
1129 7FB2
1130 7FB2                       ENDP 
1131 7FB2
1132 7FB2                       EJECT 
1133 7FB2              *******************************************************************************
1134 7FB2              *
1135 7FB2              FastPutChar PROC Export 
1136 7FB2              *
1137 7FB2              * Description: This routine draws a character to the current grafport
1138 7FB2              *              as fast as its little legs can make it do it!
1139 7FB2              * Setup
1140 7FB2              * SrcRef - Set to the character to draw's offset into the proper strike
1141 7FB2              * destRef- Set to the grafports destination location
1142 7FB2              * maskleft & maskRight - set for masking the characters properly
1143 7FB2              * theWidth - set to the current characters width
1144 7FB2              * shiftInfo - set to number of pixels to shift *2
1145 7FB2              *
1146 7FB2              *
1147 7FB2              *******************************************************************************
1148 7FB2              ; first test to see if we need any right mask...
1149 7FB2 A5 84                 lda   <ascent                  ; get the proper number of 
1150 7FB4 18                    clc                            ; lines to draw+1
1151 7FB5 65 E2                 adc   <descent
1152 7FB7 85 D6                 sta   <CharToDraw              ; and use it as our counter
1153 7FB9              ; NOTE: we can blow away char to draw now!
1154 7FB9
1155 7FB9 8B                    phb                            ; save the current data bank
1156 7FBA D4 95                 pei   <destRef+1               ; get the source ref bank
1157 7FBC AB                    plb   
1158 7FBD AB                    plb                            ; and get the destination bank number..
1159 7FBE A5 30                 lda   <fastMode                ; get the mode
1160 7FC0 C9 04 00              cmp   #$0004
1161 7FC3 D0 03                 bne   @modeCopy
1162 7FC5 82 96 01              brl   FastModeForeCopy
1163 7FC8              @ModeCopy  
1164 7FC8 A5 A4                 lda   <shiftInfo
1165 7FCA D0 1C                 bne   needBothMasks
1166 7FCC A5 DE                 lda   <theWidth
1167 7FCE 69 07 00              adc   #7
1168 7FD1 4A                    lsr   a                        ; compute the number of words to copy
1169 7FD2 4A                    lsr   a
1170 7FD3 4A                    lsr   a
1171 7FD4 C9 04 00              cmp   #4                       ; if its greater than 3 words, use long way
1172 7FD7 B0 33                 bge   theLongWay               ; gotta use the long way here!
1173 7FD9 0A                    asl   a                        ; use as table offset...
1174 7FDA AA                    tax                            ; use it # bytes as a table lookup
1175 7FDB FC E0 7F              jsr   (rMaskOnly,x)            ; and jump to the proper routine
1176 7FDE AB           rMaskOnly0 plb   
1177 7FDF 60                    rts   
1178 7FE0              ; table of routines that copy the data using only the right mask...
1179 7FE0              rMaskOnly  
1180 7FE0 DE 7F                 DC W:rMaskOnly0                ; can never happen... but
1181 7FE2 50 80                 DC W:rMaskOnly2                ; a whole word...
1182 7FE4 78 80                 DC W:rMaskOnly4                ; 2 words...
1183 7FE6 A7 80                 DC W:rMaskOnly6
1184 7FE8
1185 7FE8              needBothMasks  
1186 7FE8 A5 A4                 lda   <shiftInfo               ; get the shift info back...
1187 7FEA 18                    clc   
1188 7FEB 65 DE                 adc   <theWidth                ; and create the number of pixels to xfer..
1189 7FED 69 07 00              adc   #7
1190 7FF0 4A                    lsr   a                        ; compute the number of words to copy
1191 7FF1 4A                    lsr   a
1192 7FF2 4A                    lsr   a
1193 7FF3 C9 04 00              cmp   #4                       ; if its greater than 3, use long way
1194 7FF6 B0 14                 bge   theLongWay               ; may as well use bofth masks!
1195 7FF8 0A                    asl   a                        ; use as table offset...
1196 7FF9 AA                    tax                            ; use it # bytes as a table lookup
1197 7FFA D4 9C                 pei   <fastMaskLeft            ; save this
1198 7FFC FC 04 80              jsr   (bothMaskTbl,x)          ; and jump to the proper routine
1199 7FFF 68           bMask0   pla   
1200 8000 85 9C                 sta   <fastMaskLeft
1201 8002 AB                    plb   
1202 8003 60                    rts   
1203 8004
1204 8004              bothMaskTbl  
1205 8004 FF 7F                 DC W:bMask0                    ; can never happen... but
1206 8006 DD 80                 DC W:bMask2
1207 8008 E6 80                 DC W:bMask4
1208 800A 1B 81                 DC W:bMask6
1209 800C              ;
1210 800C              ; The next routine is the routine that will copy the character to the screen 
1211 800C              ; the long way... its kinda slow, but hey, why are you using such wide characters?
1212 800C              theLongWay  
1213 800C 0A                    asl   a                        ; multiply by 2...
1214 800D E9 01 00              sbc   #1                       ; carry is set, subtract 2 from this...
1215 8010 85 DE                 sta   <theWidth                ; save width in bytes of the character...
1216 8012
1217 8012 A7 98                 lda   [<srcRef]                ; get the first word to slam...
1218 8014 52 94                 eor   (<destRef)
1219 8016 25 9C                 and   <fastMaskLeft            ; do the first word...
1220 8018 52 94                 eor   (<destRef)
1221 801A 92 94                 sta   (<destRef)
1222 801C
1223 801C A0 02 00              ldy   #2
1224 801F              @Loop     
1225 801F B7 98                 lda   [<srcRef],y              ; get the first word to slam...
1226 8021 91 94                 sta   (<destRef),y
1227 8023 C8                    iny   
1228 8024 C8                    iny   
1229 8025 C4 DE                 cpy   <theWidth                ; are we there yet???
1230 8027 90 F6                 blt   @loop                    ; if not, do another 2...
1231 8029
1232 8029 B7 98                 lda   [<srcRef],y              ; get the first word to slam...
1233 802B 51 94                 eor   (<destRef),y
1234 802D 25 9E                 and   <fastMaskright           ; do the last word...
1235 802F 51 94                 eor   (<destRef),y
1236 8031 91 94                 sta   (<destRef),y
1237 8033
1238 8033
1239 8033 C6 D6                 dec   <charToDraw              ; decrement our counter...
1240 8035 F0 17                 beq   @Done
1241 8037              ;
1242 8037              ; bump our counters...
1243 8037
1244 8037 A5 12                 lda   <width
1245 8039 18                    clc   
1246 803A 65 94                 adc   <destRef
1247 803C 85 94                 sta   <destRef
1248 803E 90 03                 bcc   @1
1249 8040 20 57 81              jsr   BumpBank                 ; bump the data bank and clear the carry
1250 8043 A5 86        @1       lda   <RowBytes
1251 8045 65 98                 adc   <srcRef
1252 8047 85 98                 sta   <srcRef
1253 8049 A0 00 00              ldy   #0
1254 804C 80 D1                 bra   @Loop
1255 804E
1256 804E AB           @Done    plb   
1257 804F 60                    rts                            ; and exit
1258 8050
1259 8050              ;
1260 8050              ; This is the start of all our special case routines...
1261 8050              ; strap in, they are pretty long and fast...
1262 8050              rMaskOnly2  
1263 8050 A6 D6                 ldx   <CharToDraw
1264 8052              @loop     
1265 8052 A7 98                 lda   [<srcRef]
1266 8054 52 94                 eor   (<destRef)
1267 8056 25 9E                 and   <fastMaskRight
1268 8058 52 94                 eor   (<destRef)
1269 805A 92 94                 sta   (<destRef)
1270 805C CA                    dex   
1271 805D F0 18                 beq   @Done
1272 805F A5 12                 lda   <width
1273 8061 65 94                 adc   <destRef
1274 8063 85 94                 sta   <destRef
1275 8065 90 03                 bcc   @1
1276 8067 20 57 81              jsr   BumpBank                 ; bump the data bank and clear the carry
1277 806A A5 86        @1       lda   <RowBytes
1278 806C 65 98                 adc   <srcRef
1279 806E 85 98                 sta   <srcRef
1280 8070 90 03                 bcc   @2
1281 8072 E6 9A                 inc   srcRef+2
1282 8074 18                    clc   
1283 8075              @2        
1284 8075 80 DB                 bra   @loop
1285 8077 60           @Done    rts   
1286 8078
1287 8078              ;
1288 8078              ; This routine slams 4 bytes applying the left mask to the final word
1289 8078              ; 
1290 8078              rMaskOnly4  
1291 8078 A6 D6                 ldx   <CharToDraw
1292 807A A0 02 00              ldy   #2
1293 807D              @Loop     
1294 807D A7 98                 lda   [<srcRef]                ; get the first word to slam...
1295 807F 92 94                 sta   (<destRef)               ; and slam it out...
1296 8081
1297 8081 B7 98                 lda   [<srcRef],y
1298 8083 51 94                 eor   (<destRef),y
1299 8085 25 9E                 and   <fastMaskRight
1300 8087 51 94                 eor   (<destRef),y
1301 8089 91 94                 sta   (<destRef),y
1302 808B
1303 808B CA                    dex   
1304 808C F0 18                 beq   @Done
1305 808E A5 12                 lda   <width
1306 8090 65 94                 adc   <destRef
1307 8092 85 94                 sta   <destRef
1308 8094 90 03                 bcc   @1
1309 8096 20 57 81              jsr   BumpBank                 ; bump the data bank and clear the carry
1310 8099 A5 86        @1       lda   <RowBytes
1311 809B 65 98                 adc   <srcRef
1312 809D 85 98                 sta   <srcRef
1313 809F 90 03                 bcc   @2
1314 80A1 E6 9A                 inc   srcRef+2
1315 80A3 18                    clc   
1316 80A4              @2        
1317 80A4 80 D7                 bra   @Loop
1318 80A6
1319 80A6 60           @Done    rts                            ; and exit
1320 80A7
1321 80A7              ;
1322 80A7              ; This routine slams 6 bytes applying the left mask to the final word
1323 80A7              ; 
1324 80A7              rMaskOnly6  
1325 80A7 A6 D6                 ldx   <CharToDraw
1326 80A9
1327 80A9 A0 02 00     @Loop    ldy   #2
1328 80AC A7 98                 lda   [<srcRef]                ; get the first word to slam...
1329 80AE 92 94                 sta   (<destRef)               ; and slam it out...
1330 80B0 B7 98                 lda   [<srcRef],y
1331 80B2 91 94                 sta   (<destRef),y
1332 80B4 A0 04 00              ldy   #4
1333 80B7 B7 98                 lda   [<srcRef],y
1334 80B9 51 94                 eor   (<destRef),y
1335 80BB 25 9E                 and   <fastMaskRight
1336 80BD 51 94                 eor   (<destRef),y
1337 80BF 91 94                 sta   (<destRef),y
1338 80C1 CA                    dex   
1339 80C2 F0 18                 beq   @Done
1340 80C4 A5 12                 lda   <width
1341 80C6 65 94                 adc   <destRef
1342 80C8 85 94                 sta   <destRef
1343 80CA 90 03                 bcc   @1
1344 80CC 20 57 81              jsr   BumpBank                 ; bump the data bank and clear the carry
1345 80CF A5 86        @1       lda   <RowBytes
1346 80D1 65 98                 adc   <srcRef
1347 80D3 85 98                 sta   <srcRef
1348 80D5 90 03                 bcc   @2
1349 80D7 E6 9A                 inc   srcRef+2
1350 80D9 18                    clc   
1351 80DA              @2        
1352 80DA 80 CD                 bra   @Loop
1353 80DC
1354 80DC 60           @Done    rts                            ; and exit
1355 80DD
1356 80DD              bMask2    
1357 80DD A5 9E                 lda   <fastMaskRight
1358 80DF 25 9C                 and   <fastMaskLeft
1359 80E1 85 9E                 sta   <FastMaskRight
1360 80E3 82 6A FF              brl   rMaskOnly2               ; and reuse some code...
1361 80E6              ;
1362 80E6              ; This routine slams 4 bytes applying the left mask and right mask to the final word
1363 80E6              ; 
1364 80E6              bMask4    
1365 80E6 A6 D6                 ldx   <CharToDraw
1366 80E8 A0 02 00              ldy   #2
1367 80EB              @Loop     
1368 80EB A7 98                 lda   [<srcRef]                ; get the first word to slam...
1369 80ED 52 94                 eor   (<destRef)
1370 80EF 25 9C                 and   <fastMaskLeft
1371 80F1 52 94                 eor   (<destRef)
1372 80F3 92 94                 sta   (<destRef)
1373 80F5
1374 80F5 B7 98                 lda   [<srcRef],y
1375 80F7 51 94                 eor   (<destRef),y
1376 80F9 25 9E                 and   <fastMaskRight
1377 80FB 51 94                 eor   (<destRef),y
1378 80FD 91 94                 sta   (<destRef),y
1379 80FF CA                    dex   
1380 8100 F0 18                 beq   @Done
1381 8102 A5 12                 lda   <width
1382 8104 65 94                 adc   <destRef
1383 8106 85 94                 sta   <destRef
1384 8108 90 03                 bcc   @1
1385 810A 20 57 81              jsr   BumpBank                 ; bump the data bank and clear the carry
1386 810D A5 86        @1       lda   <RowBytes
1387 810F 65 98                 adc   <srcRef
1388 8111 85 98                 sta   <srcRef
1389 8113 90 03                 bcc   @2
1390 8115 E6 9A                 inc   srcRef+2
1391 8117 18                    clc   
1392 8118              @2        
1393 8118 80 D1                 bra   @Loop
1394 811A
1395 811A 60           @Done    rts                            ; and exit
1396 811B
1397 811B              ;
1398 811B              ; This routine slams 6 bytes applying the both masks to the final word
1399 811B              ; 
1400 811B              bMask6    
1401 811B A6 D6                 ldx   <CharToDraw
1402 811D
1403 811D A0 02 00     @Loop    ldy   #2
1404 8120 A7 98                 lda   [<srcRef]                ; get the first word to slam...
1405 8122 52 94                 eor   (<destRef)
1406 8124 25 9C                 and   <fastMaskLeft
1407 8126 52 94                 eor   (<destRef)
1408 8128 92 94                 sta   (<destRef)
1409 812A
1410 812A B7 98                 lda   [<srcRef],y
1411 812C 91 94                 sta   (<destRef),y
1412 812E A0 04 00              ldy   #4
1413 8131 B7 98                 lda   [<srcRef],y
1414 8133 51 94                 eor   (<destRef),y
1415 8135 25 9E                 and   <fastMaskRight
1416 8137 51 94                 eor   (<destRef),y
1417 8139 91 94                 sta   (<destRef),y
1418 813B CA                    dex   
1419 813C F0 18                 beq   @Done
1420 813E A5 12                 lda   <width
1421 8140 65 94                 adc   <destRef
1422 8142 85 94                 sta   <destRef
1423 8144 90 03                 bcc   @1
1424 8146 20 57 81              jsr   BumpBank                 ; bump the data bank and clear the carry
1425 8149 A5 86        @1       lda   <RowBytes
1426 814B 65 98                 adc   <srcRef
1427 814D 85 98                 sta   <srcRef
1428 814F 90 03                 bcc   @2
1429 8151 E6 9A                 inc   srcRef+2
1430 8153 18                    clc   
1431 8154              @2        
1432 8154 80 C7                 bra   @Loop
1433 8156
1434 8156 60           @Done    rts                            ; and exit
1435 8157              ;
1436 8157              ; This routine bumps the bank of the destination we are using 
1437 8157              bumpBank  
1438 8157 8B                    phb                            ; push the current bank
1439 8158 68                    pla   
1440 8159 1A                    inc   a
1441 815A 48                    pha   
1442 815B AB                    plb   
1443 815C 18                    clc   
1444 815D 60                    rts   
1445 815E
1446 815E              FastModeForeCopy  
1447 815E              ; The next routine is the routine that will do a pseudo fast modeForecopy of
1448 815E              ; all the words in our character
1449 815E              ; its kinda slow, but hey, why are you using modeForeCopy?
1450 815E A5 A4                 lda   <shiftInfo               ; get the shift info back...
1451 8160 D0 04                 bne   @maskOK
1452 8162 3A                    dec   a
1453 8163 85 9C                 sta   <fastMaskLeft
1454 8165 1A                    inc   a
1455 8166              @MaskOK   
1456 8166 18                    clc   
1457 8167 65 DE                 adc   <theWidth                ; and create the number of pixels to xfer..
1458 8169 69 07 00              adc   #7
1459 816C 4A                    lsr   a                        ; compute the number of words to copy
1460 816D 4A                    lsr   a
1461 816E 4A                    lsr   a
1462 816F 0A                    asl   a                        ; multiply by 2...
1463 8170 E9 01 00              sbc   #1                       ; carry is set, subtract 2 from this...
1464 8173 85 DE                 sta   <theWidth                ; save width in bytes of the character...
1465 8175 A5 9C                 lda   <fastMaskLeft            ; convert the left mask
1466 8177 49 FF FF              eor   #$FFFF                   ; by inverting it...
1467 817A 85 9C                 sta   <fastMaskLeft
1468 817C
1469 817C A5 9E                 lda   <fastMaskRight           ; convert the left mask
1470 817E 49 FF FF              eor   #$FFFF                   ; by inverting it...
1471 8181 85 9E                 sta   <fastMaskRight
1472 8183
1473 8183              ; Start the loop here!
1474 8183              @outerLoop  
1475 8183 A0 02 00              ldy   #2
1476 8186 A5 DE                 lda   <theWidth
1477 8188 C9 02 00              cmp   #2                       ; are we doing 2 words or less
1478 818B B0 0C                 bge   @cont
1479 818D              ; modeforecopy 1 word...
1480 818D A7 98                 lda   [<srcRef]                ; get the first word to slam...
1481 818F 05 9C                 ora   <fastMaskLeft
1482 8191 05 9E                 ora   <fastMaskRight
1483 8193 32 94                 and   (<destRef)
1484 8195 92 94                 sta   (<destRef)
1485 8197 80 28                 bra   @drawCont
1486 8199
1487 8199 D0 0A        @cont    bne   @cont2
1488 819B
1489 819B A7 98                 lda   [<srcRef]                ; get the first word to slam...
1490 819D 05 9C                 ora   <fastMaskLeft
1491 819F 32 94                 and   (<destRef)
1492 81A1 92 94                 sta   (<destRef)
1493 81A3
1494 81A3 80 14                 bra   @DoLastWord
1495 81A5              @Cont2    
1496 81A5 A7 98                 lda   [<srcRef]                ; get the first word to slam...
1497 81A7 05 9C                 ora   <fastMaskLeft
1498 81A9 32 94                 and   (<destRef)
1499 81AB 92 94                 sta   (<destRef)
1500 81AD              @Loop     
1501 81AD B7 98                 lda   [<srcRef],y              ; get the first word to slam...
1502 81AF 31 94                 and   (<destRef),y             ; do the modeforecopy and
1503 81B1 91 94                 sta   (<destRef),y
1504 81B3 C8                    iny   
1505 81B4 C8                    iny   
1506 81B5 C4 DE                 cpy   <theWidth                ; are we there yet???
1507 81B7 90 F4                 blt   @loop                    ; if not, do another 2...
1508 81B9              @DoLastWord  
1509 81B9 B7 98                 lda   [<srcRef],y              ; get the first word to slam...
1510 81BB 05 9E                 ora   <fastMaskright           ; do the last word...
1511 81BD 31 94                 and   (<destRef),y
1512 81BF 91 94                 sta   (<destRef),y
1513 81C1              @DrawCont  
1514 81C1
1515 81C1 C6 D6                 dec   <charToDraw              ; decrement our counter...
1516 81C3 F0 1A                 beq   @Done
1517 81C5              ;
1518 81C5              ; bump our counters...
1519 81C5
1520 81C5 A5 12                 lda   <width
1521 81C7 18                    clc   
1522 81C8 65 94                 adc   <destRef
1523 81CA 85 94                 sta   <destRef
1524 81CC 90 03                 bcc   @1
1525 81CE 20 57 81              jsr   BumpBank                 ; bump the data bank and clear the carry
1526 81D1 A5 86        @1       lda   <RowBytes
1527 81D3 65 98                 adc   <srcRef
1528 81D5 85 98                 sta   <srcRef
1529 81D7 90 03                 bcc   @2
1530 81D9 E6 9A                 inc   <srcRef+2
1531 81DB 18                    clc   
1532 81DC              @2        
1533 81DC 82 A4 FF              brl   @outerLoop
1534 81DF
1535 81DF AB           @Done    plb   
1536 81E0 60                    rts                            ; and exit
1537 81E1
1538 81E1
1539 81E1                       EndP 
1540 81E1              *****************************************
1541 81E1              *                                       *
1542 81E1              *  end of DChar                         *
1543 81E1              *                                       *
1544 81E1              *****************************************
1545 81E1              ;
1546 81E1              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
1547 81E1              ;
1548 81E1              *****************************************
1549 81E1              *                                       *
1550 81E1              *  current date and time:               *
1551 81E1              *    5:00 PM, 4/15/86                   *
1552 81E1              *                                       *
1553 81E1              *****************************************
1554 81E1              ;
1555 81E1              *******************************************************************************
1556 81E1              *                                                                             *
1557 81E1              *              subroutine DText (alias DCstring)                              *
1558 81E1              *                                                                             *
1559 81E1              *                                       started 4/2/86 or before              *
1560 81E1              *                                       Bennet Marks x6245                    *
1561 81E1              *                                                                             *
1562 81E1              *  ABSTRACT:  this is the framing routine used by DrawString, DrawText, and   *
1563 81E1              *  DrawCstring to draw a sequence of characters into the current grafport's   *
1564 81E1              *  pixelmap.  It does everything those routines want - see external documen-  *
1565 81E1              *  tion.                                                                      *
1566 81E1              *                                                                             *
1567 81E1              *  ASSUMPTIONS:  Very few.  QD II must be active.  DrawVerb must be set.      *
1568 81E1              *  TextPtr and (for strings and text blocks) TextLength must also be set.     *
1569 81E1              *                                                                             *
1570 81E1              *  RETURNS:  pnLoc.H in the current grafport is increased by the entire       *
1571 81E1              *  string width, regardless of whether all, some, or none of the characters   *
1572 81E1              *  actually got drawn into the destination.                                   *
1573 81E1              *                                                                             *
1574 81E1              *  ALTERS:  most if not all of the QD II globals may be changed by this rou-  *
1575 81E1              *  tine.                                                                      *
1576 81E1              *                                                                             *
1577 81E1              *  NOTES:  a lot of DText's code is dedicated to determining which characters *
1578 81E1              *  in a string (or whatever) can actually impinge on the destination pixel-   *
1579 81E1              *  map; the ones that can't it doesn't even draw into the text buffer.  This  *
1580 81E1              *  lets us avoid having a text buffer as big as all outdoors.                 *
1581 81E1              *                                                                             *
1582 81E1              *  The distinction between strings (and text blocks) and Cstrings is only     *
1583 81E1              *  of interest to one subroutine - GetNextChar, which distinguishes them on   *
1584 81E1              *  the basis of DrawVerb.  This allows us to use identical code for the diff- *
1585 81E1              *  erent text data structures, once DrawVerb is set.  (the difference between *
1586 81E1              *  strings and text blocks is taken care of even earlier, in DrawString and   *
1587 81E1              *  DrawText; they even have the same DrawVerb value)                          *
1588 81E1              *                                                                             *
1589 81E1              *  The DBR is preserved.                                                      *
1590 81E1              *                                                                             *
1591 81E1              *  DText returns with an RTL.                                                 *
1592 81E1              *                                                                             *
1593 81E1              *******************************************************************************
1594 81E1              ;
1595 81E1              *****************************************
1596 81E1              *                                       *
1597 81E1              *  V.0.1.0 - 4/2/86                     *
1598 81E1              *    Dan's bug (letters to the left of  *
1599 81E1              *    port screw things up) fixed by     *
1600 81E1              *    changing an errant ADC #lowByte    *
1601 81E1              *    to AND #lowByte - 4/15/86, BHM     *
1602 81E1              *                                       *
1603 81E1              *    changed to handle spExtra; doc.    *
1604 81E1              *    not up to date - BHM, 4/22/86      *
1605 81E1              *                                       *
1606 81E1              *    spExtra taken out for a while;     *
1607 81E1              *    style mods put in - 5/2/86, BHM    *
1608 81E1              *                                       *
1609 81E1              *
1610 81E1              * 2/12/89	Mensch
1611 81E1              *
1612 81E1              * Added some more of the fast text stuff. Added a new loop in this routine for
1613 81E1              * drawing fast chars, this should speed up drawing the chars...
1614 81E1              *                 
1615 81E1              *****************************************
1616 81E1              ;
1617 81E1                       EXPORT iDText 
1618 81E1              iDText   PROC 
1619 81E1                       EXPORT iDCstring 
1620 81E1              iDCstring                               ; 
1621 81E1              *              USING E0Vectors
1622 81E1              *              USING CoreData
1623 81E1              ;
1624 81E1 22 54 1F E0           jsl   GetNextChar
1625 81E5 90 01                 bcc   NotNullString
1626 81E7 6B                    rtl                            ;null string.  Not much to do.
1627 81E8              ;
1628 81E8              NotNullString                           ; 
1629 81E8              ;
1630 81E8 22 3C 1E E0           jsl   PortLoc2ZP
1631 81EC 22 A0 1E E0           jsl   SetUpPortRegions
1632 81F0              ;
1633 81F0 A9 FF FF              lda   #-1                      ; get the fast font info if available
1634 81F3 22 64 1F E0           jsl   SetUpFontInfo
1635 81F7              ;
1636 81F7 A0 42 00              ldy   #(O_pnLoc+O_H)
1637 81FA B7 24                 lda   [portRef],y              ;get current pnLoc.H
1638 81FC 85 AC                 sta   currPen
1639 81FE              ;
1640 81FE 22 58 1F E0           jsl   CalcDrawStatus           ;check for invis. pen or null minRect
1641 8202 90 07                 bcc   GoodDrawStatus
1642 8204              ;bad draw status:
1643 8204 22 78 1F E0           jsl   BumpPen                  ;bump currPen by string width
1644 8208 82 9C 00              brl   BadDrawStatus
1645 820B              ;
1646 820B              GoodDrawStatus                          ; 
1647 820B              ;
1648 820B              ; test to see if we are using the pre-cached font stuff...
1649 820B 08                    php   
1650 820C 24 F6                 bit   <fontFlags
1651 820E 70 03                 bvs   @stillfast
1652 8210 28                    plp   
1653 8211 80 10                 bra   doOldLine
1654 8213 28           @StillFast plp   
1655 8214
1656 8214 A0 76 00              ldy   #o_font+2
1657 8217              ;	lda	[<portRef],y
1658 8217              ;	bpl	doOldLine
1659 8217
1660 8217 50 03                 bvc   BadFastLine              ; if the regions are non-rectangular no fast stuff
1661 8219 82 97 00              brl   tryFastLine              ; if set try drawing a fast line!
1662 821C
1663 821C              ;
1664 821C              BadFastLine  
1665 821C A9 00 00              lda   #0                       ; get the original font info...
1666 821F 22 64 1F E0           jsl   SetUpFontInfo            ; and call the font info setup stuff
1667 8223              doOldLine  
1668 8223              ;
1669 8223              ****  TURNED IN-LINE CODE INTO SUBROUTINE
1670 8223              ;
1671 8223 22 F4 1F E0           jsl   CalcSlop                 ;this subroutine, in particular
1672 8227              ;
1673 8227              ****  END OF CHANGE	- 2/9/87  BHM  x6245
1674 8227              ;
1675 8227              **** ADDED 3/10/87 DUE TO CHANGES IN CALCSLOP
1676 8227              ;
1677 8227 A2 00 02              ldx   #512
1678 822A B5 00                 lda   fontSlop,x
1679 822C              ;
1680 822C              ****  END OF CHANGE	- BHM  x6245
1681 822C              ;
1682 822C 85 2A                 sta   temp
1683 822E              ;
1684 822E A5 06                 lda   minRect+O_H2
1685 8230 18                    clc   
1686 8231 65 2A                 adc   temp
1687 8233              ;any character from this font starting from a pnLoc.H > that sum
1688 8233              ;won't show up in the destination pixelmap
1689 8233 C5 AC                 cmp   currPen
1690 8235 10 07                 bpl   NtAllPstRight            ;"not all past right" limit
1691 8237              ;not so -  all the characters are beyond the right boundary of the minRect:
1692 8237 22 78 1F E0           jsl   BumpPen                  ;bump currPen by string width
1693 823B 82 69 00              brl   AllPastRight
1694 823E              ;
1695 823E              NtAllPstRight                           ; 
1696 823E 85 AA                 sta   rightLimit
1697 8240              ;
1698 8240 A5 02                 lda   minRect+O_H1
1699 8242 38                    sec   
1700 8243 E5 2A                 sbc   temp
1701 8245 85 A8                 sta   leftLimit
1702 8247              ;any character with pnLoc.H < leftLimit won't show up in destination
1703 8247              ;
1704 8247              NextChar1                               ; 
1705 8247 A5 AC                 lda   currPen
1706 8249 C5 A8                 cmp   leftLimit
1707 824B 10 15                 bpl   InMinBounds              ;character MAY show up in destination
1708 824D              ;no way:
1709 824D 22 50 1F E0           jsl   ValidChar
1710 8251 29 FF 00              and   #lowByte                 ;get width of character
1711 8254 18                    clc   
1712 8255 65 AC                 adc   currPen                  ;boost current pen
1713 8257 85 AC                 sta   currPen
1714 8259              ;
1715 8259 22 54 1F E0           jsl   GetNextChar
1716 825D 90 E8                 bcc   NextChar1                ;and go to next character
1717 825F              ;there wasn't any - all were too far left:
1718 825F 82 45 00              brl   AllTooFarLeft
1719 8262              ;
1720 8262              InMinBounds                             ; 
1721 8262              ;characters which have a chance of impinging
1722 8262              ;on the current grafport's minRect come here
1723 8262              ;
1724 8262 22 68 1F E0           jsl   SetUpBufInfo
1725 8266              ;
1726 8266 A5 AA                 lda   rightLimit               ;in local coordinates
1727 8268 38                    sec   
1728 8269 E5 A0                 sbc   hBufToLoc
1729 826B 85 96                 sta   bufRightLimit            ;same, but in buffer coordinates
1730 826D              ;
1731 826D              NextChar2                               ; 
1732 826D              ;transfer character image from font strike to text buffer:
1733 826D              ;
1734 826D 22 74 1F E0           jsl   PutChar
1735 8271              ;
1736 8271 22 54 1F E0           jsl   GetNextChar
1737 8275 90 09                 bcc   MoreChars
1738 8277              ;no more:
1739 8277 A5 90                 lda   bufPen                   ;new pen position, buffer coordinates
1740 8279 18                    clc   
1741 827A 65 A0                 adc   hBufToLoc                ;now local coordinates
1742 827C 85 AC                 sta   currPen
1743 827E 80 11                 bra   DrewLastChar
1744 8280              ;
1745 8280              MoreChars                               ; 
1746 8280              ;but will they fit?
1747 8280 A5 96                 lda   bufRightLimit
1748 8282 C5 90                 cmp   bufPen
1749 8284 10 E7                 bpl   NextChar2                ;yes
1750 8286              ;no:
1751 8286 A5 90                 lda   bufPen
1752 8288 18                    clc   
1753 8289 65 A0                 adc   hBufToLoc
1754 828B 85 AC                 sta   currPen
1755 828D 22 78 1F E0           jsl   BumpPen                  ;boost currPen by any remaining chars
1756 8291              ;
1757 8291              ;and fall into . . .
1758 8291              ;
1759 8291              DrewLastChar                            ; 
1760 8291              ;at least some characters were drawn into text buffer -
1761 8291              ;perform style mods:
1762 8291 22 B0 1F E0           jsl   StyleText
1763 8295              ;and see if any of the image  actually makes it into destination
1764 8295 22 5C 1F E0           jsl   TextAndMinRect
1765 8299 B0 08                 bcs   NullInt                  ;no - null intersection
1766 829B              ;yes - get parameters for buffer-to-pixelmap transfer:
1767 829B 22 60 1F E0           jsl   CalcTextBounds
1768 829F 22 F4 1E E0           jsl   BlowItUp                 ;and DO IT!
1769 82A3              ;
1770 82A3              NullInt                                 ; 
1771 82A3 22 7C 1F E0           jsl   CleanUpBuffer
1772 82A7              ;
1773 82A7              BadDrawStatus                           ; 
1774 82A7              AllPastRight                            ; 
1775 82A7              AllTooFarLeft                           ; 
1776 82A7              ;
1777 82A7 A5 AC                 lda   currPen
1778 82A9 A0 42 00              ldy   #(O_pnLoc+O_H)
1779 82AC 97 24                 sta   [portRef],y              ;put updated pen into grafport
1780 82AE              ;
1781 82AE              ;
1782 82AE 22 A8 1E E0           jsl   FreePortRegions
1783 82B2              ;
1784 82B2 6B                    rtl                            ;there's no place like home
1785 82B3              ;
1786 82B3              ; Added 2/12/89     Mensch
1787 82B3              tryFastLine  
1788 82B3              ; This routine should be called when the font handle indicates that a fastfont is
1789 82B3              ; being used, if fastfonts are being used, this loop will attempt to draw them
1790 82B3              ; in the proper place on the screen. NOTE: this routine calls some routines that are
1791 82B3              ; in iDChar as well... Note that on entry to this routine, charTodraw is preset 
1792 82B3              ; for us already!
1793 82B3              ;
1794 82B3 A9 FF FF              lda   #-1
1795 82B6 85 AA                 sta   <fastLineStat
1796 82B8 A0 40 00              ldy   #o_PnLoc+o_V             ; offset to pen loc.v
1797 82BB B7 24                 lda   [<portRef],y
1798 82BD 18                    clc                            ; set to add an extra 1
1799 82BE 65 E2                 adc   <descent                 ; add the fonts descent to this value
1800 82C0 C5 04                 cmp   <MinRect+o_V2            ; see if we are within bounds...
1801 82C2 F0 02                 beq   @1
1802 82C4 10 30                 bpl   notWhole                 ; this is the bottom
1803 82C6              @1        
1804 82C6 85 04                 sta   <minRect+o_V2
1805 82C8              ; NOTE: this next subtract RELY's on the carry being clear from above compare!
1806 82C8 38                    sec   
1807 82C9 E5 E2                 sbc   <descent                 ; now create the top of our character rectangle
1808 82CB E5 84                 sbc   <ascent                  ; by subtracting the character ascent and decsent
1809 82CD 85 90                 sta   <charRect+o_V1
1810 82CF C5 00                 cmp   <MinRect+o_V1            ; see if we are too high
1811 82D1 30 23                 bmi   notWhole
1812 82D3 85 00                 sta   <MinRect+o_V1
1813 82D5 A5 AC                 lda   <CurrPen                 ; offset to penloc.H
1814 82D7 85 92                 sta   <charRect+o_H1           ; make this the right edge
1815 82D9 C5 02                 cmp   <MinRect+o_H1
1816 82DB 30 19                 bmi   NotWhole
1817 82DD 85 02                 sta   <MinRect+o_H1
1818 82DF              ; now get the right edge...
1819 82DF 22 50 1F E0           jsl   validChar                ; get the width of the character
1820 82E3 C9 0D 00              cmp   #13                      ; see if its too big...
1821 82E6 90 03                 blt   @2
1822 82E8 A9 0C 00              lda   #12                      ; max char width = 12...
1823 82EB              @2        
1824 82EB 18                    clc   
1825 82EC 85 DE                 sta   <theWidth                ; save the width of this character
1826 82EE 65 92                 adc   <charRect+o_H1
1827 82F0 C5 06                 cmp   <minRect+o_H2
1828 82F2 10 02                 bpl   notWhole
1829 82F4 80 0A                 bra   goFast                   ; if we get this far, we can do the fast drawing
1830 82F6
1831 82F6 82 23 FF     notWhole brl   badFastLine              ; if not whole, just do it the old way...
1832 82F9              notWhole2  
1833 82F9 22 9C 1E E0           jsl   UnShieldCursor           ; the cursor was shielded, unshield it...
1834 82FD 82 1C FF              brl   badFastLine              ; and now continue to draw the old way...
1835 8300              ;
1836 8300              ; If we get this far, then we can go the fast way!
1837 8300              goFast    
1838 8300              ; we must now convert our rectangle to 'global' locinfo coordinants
1839 8300              ; we do this by first creating an 'offset' to add to our rectangle... NOTE: this now only
1840 8300              ; operates on the top left
1841 8300 A5 90                 lda   <charRect+o_V1
1842 8302 38                    sec   
1843 8303 E5 14                 sbc   <boundsRect+o_V1
1844 8305 30 EF                 bmi   notWhole                 ; if this is negative, somethings wrong..
1845 8307 85 90                 sta   charRect+o_V1
1846 8309
1847 8309 A5 92                 lda   <charRect+o_H1
1848 830B 38                    sec   
1849 830C E5 16                 sbc   <boundsRect+o_H1
1850 830E 30 E6                 bmi   notWhole                 ; if this is negative, somethings wrong..
1851 8310 85 92                 sta   charRect+o_H1
1852 8312
1853 8312 22 98 1E E0           jsl   ShieldCursor             ; shield the cursor for the whole line
1854 8316 A5 12                 lda   <width
1855 8318 C9 A0 00              cmp   #$00A0                   ; special case for screen port rects
1856 831B D0 1A                 bne   @doMult1
1857 831D A5 90                 lda   charRect+o_V1            ; get the character rectangle top
1858 831F C9 90 01              cmp   #400                     ; see if we rolled over the top of the mult below
1859 8322 B0 11                 bge   @DoMult2
1860 8324 0A                    asl   a                        ; multiply it by 32 first..
1861 8325 0A                    asl   a
1862 8326 0A                    asl   a
1863 8327 0A                    asl   a
1864 8328 0A                    asl   a
1865 8329 85 A0                 sta   Mult1
1866 832B 0A                    asl   a
1867 832C 0A                    asl   a
1868 832D 18                    clc   
1869 832E 65 A0                 adc   Mult1
1870 8330 A2 00 00              ldx   #0
1871 8333 80 0B                 bra   @DoMult3
1872 8335 A5 12        @DoMult2 lda   <width
1873 8337 85 A2        @DoMult1 sta   Mult2                    ; save it for the multiply
1874 8339 A5 90                 lda   charRect                 ; get the v1 coordinant
1875 833B 85 A0                 sta   Mult1
1876 833D 20 7B 7F              jsr   DoMultiply               ; multiply these two numbers
1877 8340              @DoMult3  
1878 8340              ; once we have it this far, we can create the address of the starting scan line to 
1879 8340              ; draw upon...
1880 8340 65 0E                 adc   <imageRef                ; add to the base image reference
1881 8342 85 A0                 sta   Mult1                    ; save this for a second...
1882 8344 8A                    txa   
1883 8345 65 10                 adc   <imageRef+2              ; and create the high word
1884 8347 85 A2                 sta   Mult2
1885 8349 80 21                 bra   LoopCont                 ; branch around each char stuff
1886 834B              ;
1887 834B              ; InnerLoop now bypasses many of the above tests that no longer need to be performed
1888 834B              ;
1889 834B              InnerLoop  
1890 834B A5 AC                 lda   <CurrPen                 ; offset to penloc.H
1891 834D 85 92                 sta   <charRect+o_H1           ; make this the left edge
1892 834F              ; now get the right edge...
1893 834F 22 50 1F E0           jsl   validChar                ; get the width of the character
1894 8353 C9 0D 00              cmp   #13                      ; see if its too big...
1895 8356 90 03                 blt   @2
1896 8358 A9 0C 00              lda   #12                      ; max char width = 12...
1897 835B              @2        
1898 835B 85 DE                 sta   <theWidth                ; save the width of this character
1899 835D 65 92                 adc   <charRect+o_H1
1900 835F C5 06                 cmp   <minRect+o_H2
1901 8361 10 96                 bpl   notWhole2                ; call thisway cause cursor shielded...
1902 8363
1903 8363              ; and convert the new position to global coordinants.
1904 8363
1905 8363 A5 92                 lda   <charRect+o_H1
1906 8365 38                    sec   
1907 8366 E5 16                 sbc   <boundsRect+o_H1
1908 8368 30 8F                 bmi   notWhole2                ; if this is negative, somethings wrong..
1909 836A 85 92                 sta   charRect+o_H1            ; call thisway cause cursor shielded...
1910 836C              ;
1911 836C              ; Now that the char is converted to 'local coordinants lets just call the drawing
1912 836C              ; routine!
1913 836C              LoopCont  
1914 836C              ; We must enter DrawOneFromALine with DestRef calculated...
1915 836C A5 A2                 lda   Mult2
1916 836E 85 96                 sta   DestRef+2
1917 8370 A5 92                 lda   <CharRect+o_H1           ; now compute the offset into destref
1918 8372 4A                    lsr   a                        ; divide this by 4(pixels per byte)
1919 8373 4A                    lsr   a
1920 8374 18                    clc                            ; and add it in creating our final offset
1921 8375 65 A0                 adc   Mult1
1922 8377 85 94                 sta   destRef
1923 8379 90 02                 bcc   @1
1924 837B E6 96                 inc   DestRef+2
1925 837D              @1        
1926 837D
1927 837D 20 88 7E              jsr   DrawOneFromaLine
1928 8380              LoopCont1  
1929 8380 22 54 1F E0           jsl   GetNextChar              ; get the next character...
1930 8384 90 07                 bcc   gotNextOne
1931 8386 22 9C 1E E0           jsl   UnShieldCursor
1932 838A 82 1A FF              brl   AllTooFarLeft            ; we got the last char, we can end now!
1933 838D 82 BB FF     gotNextOne brl   InnerLoop
1934 8390                       ENDP 
1935 8390              ;
1936 8390              ;
1937 8390              ****  NEW SUBROUTINE - ADDED 2/9/87
1938 8390              ****  (USED TO BE PART OF DTEXT)
1939 8390              ;
1940 8390                       EXPORT iCalcSlop 
1941 8390              iCalcSlop PROC 
1942 8390              ;
1943 8390 A2 00 01              ldx   #256
1944 8393 B5 04                 lda   fontWidth,x
1945 8395 D0 1B                 bne   ForcedWidth
1946 8397              ;"default" width calculation:
1947 8397 A5 9E                 lda   fRectMax
1948 8399 C5 E0                 cmp   widMax
1949 839B 10 02                 bpl   GotMax
1950 839D A5 E0                 lda   widMax
1951 839F              GotMax                                  ; 
1952 839F 18                    clc   
1953 83A0 65 F4                 adc   extra
1954 83A2              ;
1955 83A2 18                    clc   
1956 83A3 65 F2                 adc   chExtra+2                ;add in high word of fixed point
1957 83A5 A6 F0                 ldx   chExtra
1958 83A7 F0 01                 beq   chDoNotRound             ;low byte 0 - don't round
1959 83A9 1A                    inc   a                        ;round
1960 83AA              chDoNotRound                            ; 
1961 83AA 18                    clc   
1962 83AB 65 EE                 adc   spExtra+2                ;same for spExtra
1963 83AD A6 EC                 ldx   spExtra
1964 83AF F0 01                 beq   spDoNotRound
1965 83B1 1A                    inc   a
1966 83B2              spDoNotRound                            ; 
1967 83B2              ForcedWidth                             ; 
1968 83B2              ;
1969 83B2              ;
1970 83B2 1A                    inc   a
1971 83B3              ;
1972 83B3              ****  ADDED 3/10/87	TO IMPROVE USABILITY OF THIS SUBROUTINE
1973 83B3              ;
1974 83B3 A2 00 02              ldx   #512
1975 83B6 95 00                 sta   fontSlop,x               ;everyone will know to find it here
1976 83B8              ;
1977 83B8              ****  END OF CHANGE	- BHM  x6245
1978 83B8              ;
1979 83B8 6B                    rtl   
1980 83B9              ;
1981 83B9                       ENDP 
1982 83B9              ;
1983 83B9              ****  END OF NEW SUBROUTINE - BHM  x6245
1984 83B9              ;
1985 83B9              *****************************************
1986 83B9              *                                       *
1987 83B9              *  end of DText (alis DCstring)         *
1988 83B9              *                                       *
1989 83B9              *****************************************
1990 83B9              ;
1991 83B9              ;                copy text/TxBoundsCalls
1992 83B9              ****************************************************************
1993 83B9              *
1994 83B9              * CharBounds
1995 83B9              *              theChar     word (input)
1996 83B9              *              theRectPtr  long (input)
1997 83B9              *
1998 83B9              *
1999 83B9              ****************************************************************
2000 83B9                       EXPORT CharBounds 
2001 83B9              CharBounds PROC 
2002 83B9              *              USING PicInfo
2003 83B9              OrigDirect equ   1
2004 83B9              RTL1     equ   OrigDirect+2
2005 83B9              RTL2     equ   RTL1+3
2006 83B9              theRectPtr equ   RTL2+3
2007 83B9              theChar  equ   theRectPtr+4
2008 83B9              ;
2009 83B9              rectPtr  equ   fontTemp
2010 83B9
2011 83B9 20 AA 0F              jsr   QDStart
2012 83BC
2013 83BC A3 0D                 lda   TheChar,s
2014 83BE 85 D6                 sta   charToDraw
2015 83C0 A3 09                 lda   theRectPtr,s
2016 83C2 85 D2                 sta   rectPtr
2017 83C4 A3 0B                 lda   theRectPtr+2,s
2018 83C6 85 D4                 sta   rectPtr+2
2019 83C8
2020 83C8 A9 00 00              lda   #DrawCharVerb
2021 83CB 22 3A 84 FE           jsl   CallTxBounds
2022 83CF
2023 83CF 4C 2F FC              jmp   BusyEC6
2024 83D2
2025 83D2                       ENDP 
2026 83D2              ****************************************************************
2027 83D2              *
2028 83D2              * StringBounds
2029 83D2              *              StringPtr     long (input)
2030 83D2              *              RectPtr       long (input)
2031 83D2              *
2032 83D2              ****************************************************************
2033 83D2                       EXPORT StringBounds 
2034 83D2              StringBounds PROC 
2035 83D2              *              USING PicInfo
2036 83D2              OrigDirect equ   1
2037 83D2              RTL1     equ   OrigDirect+2
2038 83D2              RTL2     equ   RTL1+3
2039 83D2              theRectPtr equ   RTL2+3
2040 83D2              StrPtr   equ   theRectPtr+4
2041 83D2              ;
2042 83D2              rectPtr  equ   fontTemp
2043 83D2
2044 83D2 20 AA 0F              jsr   QDStart
2045 83D5
2046 83D5 A3 0D                 lda   StrPtr,s
2047 83D7 85 DA                 sta   TextPtr
2048 83D9 A3 0F                 lda   StrPtr+2,s
2049 83DB 85 DC                 sta   TextPtr+2
2050 83DD A7 DA                 lda   [TextPtr]
2051 83DF 29 FF 00              and   #lowByte
2052 83E2 85 D8                 sta   TextLength
2053 83E4 E6 DA D0 02           IncLong TextPtr 
2054 83EA A3 09                 lda   theRectPtr,s
2055 83EC 85 D2                 sta   rectPtr
2056 83EE A3 0B                 lda   theRectPtr+2,s
2057 83F0 85 D4                 sta   rectPtr+2
2058 83F2
2059 83F2 A9 01 00              lda   #DrawTextVerb
2060 83F5 22 3A 84 FE           jsl   CallTxBounds
2061 83F9 4C 45 FC              jmp   BusyEC8
2062 83FC
2063 83FC                       ENDP 
2064 83FC
2065 83FC
2066 83FC              ****************************************************************
2067 83FC              *
2068 83FC              * TextBounds
2069 83FC              *              PtrToText    long (input)
2070 83FC              *              TextLength   word (input)
2071 83FC              *              RectPtr      long (input)
2072 83FC              *
2073 83FC              *
2074 83FC              * ChangeHistory
2075 83FC              *
2076 83FC              * 21 Aug 86    SEG for BM    The equates were off by 1.
2077 83FC              *
2078 83FC              ****************************************************************
2079 83FC                       EXPORT TextBounds 
2080 83FC              TextBounds PROC 
2081 83FC              *              USING PicInfo
2082 83FC              OrigDirect equ   1
2083 83FC              RTL1     equ   OrigDirect+2
2084 83FC              RTL2     equ   RTL1+3
2085 83FC              theRectPtr equ   RTL2+3
2086 83FC              TheTextLength equ   theRectPtr+4
2087 83FC              TheTextPtr equ   TheTextLength+2
2088 83FC              ;
2089 83FC              rectPtr  equ   fontTemp
2090 83FC
2091 83FC 20 AA 0F              jsr   QDStart
2092 83FF
2093 83FF A3 0F                 lda   TheTextPtr,s
2094 8401 85 DA                 sta   TextPtr
2095 8403 A3 11                 lda   TheTextPtr+2,s
2096 8405 85 DC                 sta   TextPtr+2
2097 8407 A3 0D                 lda   TheTextLength,s
2098 8409 85 D8                 sta   TextLength
2099 840B A3 09                 lda   theRectPtr,s
2100 840D 85 D2                 sta   rectPtr
2101 840F A3 0B                 lda   theRectPtr+2,s
2102 8411 85 D4                 sta   rectPtr+2
2103 8413
2104 8413 A9 01 00              lda   #DrawTextVerb
2105 8416 22 3A 84 FE           jsl   CallTxBounds
2106 841A 4C 5B FC              jmp   BusyEC10
2107 841D
2108 841D                       ENDP 
2109 841D
2110 841D
2111 841D
2112 841D              ****************************************************************
2113 841D              *
2114 841D              * CStringBounds
2115 841D              *
2116 841D              *              CStrPtr   long (input)
2117 841D              *              RectPtr   long (input)
2118 841D              * TopOfStack   ======================
2119 841D              *
2120 841D              * Modification History
2121 841D              *
2122 841D              * 19 May 86    This routine was reading the parameters off the
2123 841D              *              stack backwards.  The equates are changed to
2124 841D              *              do this right.
2125 841D              *
2126 841D              ****************************************************************
2127 841D                       EXPORT CStringBounds 
2128 841D              CStringBounds PROC 
2129 841D              OrigDirect equ   1
2130 841D              RTL1     equ   OrigDirect+2
2131 841D              RTL2     equ   RTL1+3
2132 841D              theRectPtr equ   RTL2+3
2133 841D              CStrPtr  equ   theRectPtr+4
2134 841D              ;
2135 841D              rectPtr  equ   fontTemp
2136 841D
2137 841D 20 AA 0F              jsr   QDStart
2138 8420
2139 8420 A3 0D                 lda   CStrPtr,s
2140 8422 85 DA                 sta   TextPtr
2141 8424 A3 0F                 lda   CStrPtr+2,s
2142 8426 85 DC                 sta   TextPtr+2
2143 8428 A3 09                 lda   theRectPtr,s
2144 842A 85 D2                 sta   rectPtr
2145 842C A3 0B                 lda   theRectPtr+2,s
2146 842E 85 D4                 sta   rectPtr+2
2147 8430
2148 8430
2149 8430 A9 02 00              lda   #DrawCStrVerb
2150 8433 22 3A 84 FE           jsl   CallTxBounds
2151 8437 4C 45 FC              jmp   BusyEC8
2152 843A
2153 843A                       ENDP 
2154 843A
2155 843A
2156 843A
2157 843A
2158 843A              ****************************************************************
2159 843A              *
2160 843A              * CallTxBounds
2161 843A              *
2162 843A              * This routine called by the entry points standard
2163 843A              * text inputs are on zero page.
2164 843A              *
2165 843A              * Zero page is already switched in by the time it gets here.
2166 843A              *
2167 843A              ****************************************************************
2168 843A                       EXPORT CallTxBounds 
2169 843A              CallTxBounds PROC 
2170 843A              *              using CoreDATA
2171 843A              *              using PicInfo
2172 843A              *              using QDProcs
2173 843A              *              using E0Vectors
2174 843A
2175 843A 85 38                 sta   DrawVerb
2176 843C
2177 843C 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
2178 843F B0 04                 bcs   UseLocal
2179 8441
2180 8441 5C 30 1E E0           jml   StdTxBnds
2181 8445
2182 8445
2183 8445 8B           UseLocal phb                            ; put extra byte on stack
2184 8446 A0 2C 00              ldy   #o_stdTxBnds             ; get adr of new text width routine
2185 8449 B7 2A                 lda   [temp],y                 ; put on stack
2186 844B 48                    pha   
2187 844C C8                    iny                            ; get bytes 2 and 3
2188 844D B7 2A                 lda   [temp],y
2189 844F 83 02                 sta   2,s                      ; store middle byte twice
2190 8451 6B                    rtl                            ; call it
2191 8452
2192 8452                       ENDP 
2193 8452
2194 8452
2195 8452              ****************************************************************
2196 8452              *
2197 8452              * StdTxBnds
2198 8452              *
2199 8452              * Common text measuring routine that is central point for
2200 8452              * all text framing routines.
2201 8452              *
2202 8452              * When control gets here, all inputs are on zero page.
2203 8452              *
2204 8452              * There are lots of possiblities as to what they are.  And the
2205 8452              * Draw verb is what tells us what to do.
2206 8452              *
2207 8452              *       For CharWidth
2208 8452              *               char is on zp at charToDraw
2209 8452              *
2210 8452              *       For TextWidth
2211 8452              *               pointer is on zp
2212 8452              *               length is on zp
2213 8452              *
2214 8452              *       For CStringWidth
2215 8452              *               pointer is on zp
2216 8452              *
2217 8452              ****************************************************************
2218 8452                       EXPORT iStdTxBnds 
2219 8452              iStdTxBnds PROC 
2220 8452              *              using CoreDATA
2221 8452              *              using PicInfo
2222 8452              *              using QDProcs
2223 8452              *              using E0Vectors
2224 8452
2225 8452 A5 38                 lda   DrawVerb                 ; put verb in a
2226 8454 0A                    asl   a
2227 8455 AA                    tax   
2228 8456 7C 59 84              jmp   (DoBoundsTable,x)
2229 8459
2230 8459              DoBoundsTable                           ; 
2231 8459 5F 84                 DC W:iBChar
2232 845B D8 84                 DC W:iBText
2233 845D D8 84                 DC W:iBCString
2234 845F
2235 845F                       ENDP 
2236 845F
2237 845F
2238 845F
2239 845F
2240 845F
2241 845F              ****************************************************************
2242 845F              *
2243 845F              * BChar
2244 845F              *
2245 845F              ****************************************************************
2246 845F                       EXPORT iBChar 
2247 845F              iBChar   PROC 
2248 845F              *              USING E0Vectors
2249 845F              *              USING CoreData
2250 845F              ;
2251 845F              rectPtr  equ   fontTemp
2252 845F              theWidthOfChar equ   temp
2253 845F              theLocTEnt equ   temp+2
2254 845F              theImageWidth equ   temp2
2255 845F
2256 845F              ;
2257 845F A9 00 00              lda   #0
2258 8462 22 64 1F E0           jsl   SetUpFontInfo
2259 8466              ;
2260 8466 A0 42 00              ldy   #(O_pnLoc+O_H)
2261 8469 B7 24                 lda   [portRef],y              ;current pen position (hor.)
2262 846B 85 92                 sta   startBufPen
2263 846D              ;
2264 846D 22 50 1F E0           jsl   ValidChar
2265 8471 AA                    tax                            ;temp. storage
2266 8472 29 FF 00              and   #lowByte                 ;character width
2267 8475 18                    clc   
2268 8476 65 92                 adc   startBufPen              ;bump pen
2269 8478 85 90                 sta   bufPen
2270 847A              ;
2271 847A B7 7C                 lda   [locTPtr],y
2272 847C                       MacSwitch 
2273 847C 85 2C                 sta   theLocTEnt
2274 847E C8                    iny   
2275 847F C8                    iny   
2276 8480 B7 7C                 lda   [locTPtr],y
2277 8482                       MacSwitch 
2278 8482 38                    sec   
2279 8483 E5 2C                 sbc   theLocTEnt               ;get image width
2280 8485 D0 03                 bne   Not0Width
2281 8487 82 28 00              brl   ZeroWidth                ;null image
2282 848A              ;
2283 848A              Not0Width                               ; 
2284 848A 85 2E                 sta   theImageWidth
2285 848C 8A                    txa                            ;get back offset/width value
2286 848D EB                    xba   
2287 848E 29 FF 00              and   #lowByte                 ;character offset
2288 8491 18                    clc   
2289 8492 65 8C                 adc   kernMax
2290 8494 18                    clc   
2291 8495 65 92                 adc   startBufPen
2292 8497 85 CE                 sta   leftExtent
2293 8499              ;
2294 8499 18                    clc   
2295 849A 65 2E                 adc   theImageWidth
2296 849C 85 D0                 sta   rightExtent
2297 849E              ;modify extents to reflect any style mods:
2298 849E 22 B4 1F E0           jsl   StyleExtents
2299 84A2              ;
2300 84A2 A5 CE                 lda   leftExtent
2301 84A4 C5 92                 cmp   startBufPen
2302 84A6 10 02                 bpl   SBPOK                    ;startBufPen is leftmost
2303 84A8              ;or it's not:
2304 84A8 85 92                 sta   startBufPen
2305 84AA              SBPOK                                   ; 
2306 84AA              ;
2307 84AA A5 D0                 lda   rightExtent
2308 84AC C5 90                 cmp   bufPen
2309 84AE 30 02                 bmi   BPOK                     ;bufPen is rightmost
2310 84B0 85 90                 sta   bufPen                   ;or at least it is now
2311 84B2              BPOK                                    ; 
2312 84B2              ;
2313 84B2              ;leftmost and rightmost extents now in startBufPen and bufPen -
2314 84B2              ;put them in the target rectangle:
2315 84B2              ;
2316 84B2              ZeroWidth                               ; 
2317 84B2 A5 92                 lda   startBufPen
2318 84B4 A0 02 00              ldy   #O_H1
2319 84B7 97 D2                 sta   [rectPtr],y
2320 84B9              ;
2321 84B9 A5 90                 lda   bufPen
2322 84BB A0 06 00              ldy   #O_H2
2323 84BE 97 D2                 sta   [rectPtr],y
2324 84C0              ;now take care of verticals:
2325 84C0 A0 40 00              ldy   #(O_pnLoc+O_V)
2326 84C3 B7 24                 lda   [portRef],y              ;current pen position (vert.)
2327 84C5 AA                    tax                            ;temp. storage
2328 84C6 38                    sec   
2329 84C7 E5 84                 sbc   ascent
2330 84C9 A0 00 00              ldy   #O_V1
2331 84CC 97 D2                 sta   [rectPtr],y
2332 84CE              ;
2333 84CE 8A                    txa   
2334 84CF 18                    clc   
2335 84D0 65 E2                 adc   descent
2336 84D2 A0 04 00              ldy   #O_V2
2337 84D5 97 D2                 sta   [rectPtr],y
2338 84D7              ;
2339 84D7              ;
2340 84D7 6B                    rtl   
2341 84D8                       ENDP 
2342 84D8              *****************************************
2343 84D8              *                                       *
2344 84D8              *  end of BChar                         *
2345 84D8              *                                       *
2346 84D8              *****************************************
2347 84D8
2348 84D8
2349 84D8
2350 84D8              ****************************************************************
2351 84D8              *
2352 84D8              * BText (alias BCstring)
2353 84D8              *
2354 84D8              *
2355 84D8              ****************************************************************
2356 84D8                       EXPORT iBText 
2357 84D8              iBText   PROC 
2358 84D8                       EXPORT iBCString 
2359 84D8              iBCString                               ; 
2360 84D8              *              USING E0Vectors
2361 84D8              *              USING CoreData
2362 84D8              ;
2363 84D8              rectPtr  equ   fontTemp
2364 84D8              theWidthOfChar equ   temp
2365 84D8              theLocTEnt equ   temp+2
2366 84D8              theImageWidth equ   temp2
2367 84D8              ;
2368 84D8 A0 42 00              ldy   #(O_pnLoc+O_H1)
2369 84DB B7 24                 lda   [portRef],y
2370 84DD 85 92                 sta   startBufPen
2371 84DF 85 90                 sta   bufPen
2372 84E1              ;
2373 84E1 A9 FF 3F              lda   #maxInt
2374 84E4 85 CE                 sta   leftExtent
2375 84E6 A9 01 C0              lda   #(-maxInt)
2376 84E9 85 D0                 sta   rightExtent
2377 84EB              ;
2378 84EB 22 54 1F E0           jsl   GetNextChar
2379 84EF 90 03                 bcc   NotNullString
2380 84F1 82 51 00              brl   NullString
2381 84F4              ;
2382 84F4              NotNullString                           ; 
2383 84F4              ;
2384 84F4 A9 00 00              lda   #0
2385 84F7 22 64 1F E0           jsl   SetUpFontInfo
2386 84FB              ;
2387 84FB              NextChar                                ; 
2388 84FB 22 50 1F E0           jsl   ValidChar
2389 84FF AA                    tax                            ;temporary storage
2390 8500 29 FF 00              and   #lowByte
2391 8503 85 2A                 sta   theWidthOfChar
2392 8505              ;
2393 8505 A5 90                 lda   bufPen
2394 8507 85 98                 sta   imagePen
2395 8509 18                    clc   
2396 850A 65 2A                 adc   theWidthOfChar
2397 850C 85 90                 sta   bufPen                   ;bump position by char width
2398 850E              ;
2399 850E B7 7C                 lda   [locTPtr],y
2400 8510                       MacSwitch 
2401 8510 85 2C                 sta   theLocTEnt
2402 8512 C8                    iny   
2403 8513 C8                    iny   
2404 8514 B7 7C                 lda   [locTPtr],y
2405 8516                       MacSwitch 
2406 8516 38                    sec   
2407 8517 E5 2C                 sbc   theLocTEnt
2408 8519 D0 03                 bne   Not0Width
2409 851B 82 1D 00              brl   ZeroWidth                ;don't touch extents
2410 851E              Not0Width                               ; 
2411 851E              ;
2412 851E 85 2E                 sta   theImageWidth
2413 8520              ;
2414 8520 8A                    txa                            ;get back offset/width value
2415 8521 EB                    xba   
2416 8522 29 FF 00              and   #lowByte                 ;offset
2417 8525 18                    clc   
2418 8526 65 8C                 adc   kernMax
2419 8528 18                    clc   
2420 8529 65 98                 adc   imagePen
2421 852B AA                    tax                            ;temp. storage
2422 852C C5 CE                 cmp   leftExtent
2423 852E 10 02                 bpl   leftOK                   ;leftExtent is leftmost pixel
2424 8530 85 CE                 sta   leftExtent               ;or, it is now
2425 8532              leftOK                                  ; 
2426 8532              ;
2427 8532              ;new "imagePen" value still in acc.
2428 8532 18                    clc   
2429 8533 65 2E                 adc   theImageWidth
2430 8535 C5 D0                 cmp   rightExtent
2431 8537 30 02                 bmi   RightOK                  ;rightExtent is rightmost pixel
2432 8539 85 D0                 sta   rightExtent              ;sooner or later
2433 853B              RightOK                                 ; 
2434 853B              ZeroWidth                               ; 
2435 853B              ;
2436 853B 22 54 1F E0           jsl   GetNextChar
2437 853F 90 BA                 bcc   NextChar                 ;if there is one
2438 8541              ;
2439 8541              ;there wasn't:
2440 8541              ;adjust extents to reflect any style mods:
2441 8541 22 B4 1F E0           jsl   StyleExtents
2442 8545              ;
2443 8545              ;and fall into . . .
2444 8545              ;
2445 8545              NullString                              ; 
2446 8545 A5 CE                 lda   leftExtent
2447 8547 C5 92                 cmp   startBufPen
2448 8549 30 02                 bmi   leftStillOK
2449 854B A5 92                 lda   startBufPen              ;winner and new champion
2450 854D              leftStillOK                             ; 
2451 854D A0 02 00              ldy   #O_H1
2452 8550 97 D2                 sta   [rectPtr],y
2453 8552              ;
2454 8552 A5 D0                 lda   rightExtent
2455 8554 C5 90                 cmp   bufPen
2456 8556 10 02                 bpl   rightStillOK
2457 8558 A5 90                 lda   bufPen
2458 855A              rightStillOK                            ; 
2459 855A A0 06 00              ldy   #O_H2
2460 855D 97 D2                 sta   [rectPtr],y
2461 855F              ;
2462 855F              ;now take care of verticals:
2463 855F A0 40 00              ldy   #(O_pnLoc+O_V)
2464 8562 B7 24                 lda   [portRef],y              ;current pen position (vert.)
2465 8564 AA                    tax                            ;temp. storage
2466 8565 38                    sec   
2467 8566 E5 84                 sbc   ascent
2468 8568              ;
2469 8568 A0 00 00              ldy   #O_V1
2470 856B 97 D2                 sta   [rectPtr],y
2471 856D              ;
2472 856D 8A                    txa   
2473 856E 18                    clc   
2474 856F 65 E2                 adc   descent
2475 8571 A0 04 00              ldy   #O_V2
2476 8574 97 D2                 sta   [rectPtr],y
2477 8576              ;
2478 8576              ;
2479 8576 6B                    rtl   
2480 8577                       ENDP 
2481 8577
2482 8577
2483 8577
2484 8577
2485 8577
2486 8577
2487 8577
2488 8577
2489 8577
2490 8577              *****************************************
2491 8577              *                                       *
2492 8577              *  end of BText (alias BCstring)        *
2493 8577              *                                       *
2494 8577              *****************************************
2495 8577              ;                copy text/OtherTextCalls
2496 8577              ;
2497 8577              ;This version of GetFontInfo has been broken up to make it easier
2498 8577              ;to change and/or patch out later.  It should replace the old
2499 8577              ;GetFontInfo in the new ROM.
2500 8577              ;
2501 8577              ***************************************
2502 8577              *                                     *
2503 8577              *  Feb. 9, 1987  1:00 pm              *
2504 8577              *                                     *
2505 8577              *  Bennet Marks  x6245                *
2506 8577              *                                     *
2507 8577              ***************************************
2508 8577              ;
2509 8577              ****************************************************************
2510 8577              *
2511 8577              * GetFontInfo
2512 8577              *
2513 8577              * Returns some information about the font.
2514 8577              *
2515 8577              ****************************************************************
2516 8577              GetFontInfo PROC EXPORT 
2517 8577
2518 8577              OrigDirect equ   1
2519 8577              RTL1     equ   OrigDirect+2
2520 8577              RTL2     equ   RTL1+3
2521 8577              FIPtr    equ   RTL2+3
2522 8577
2523 8577 20 AA 0F              jsr   QDStart
2524 857A              ;
2525 857A A3 09                 lda   FIPtr,s
2526 857C 85 2E                 sta   temp2
2527 857E A3 0B                 lda   FiPtr+2,s
2528 8580 85 30                 sta   temp2+2
2529 8582              ;
2530 8582 22 F8 1F E0           jsl   GetFntInf
2531 8586              ;
2532 8586 4C 19 FC              jmp   BusyEC4
2533 8589              ;
2534 8589                       ENDP 
2535 8589              ;
2536 8589
2537 8589
2538 8589              ****************************************************************
2539 8589              *
2540 8589              iGetFntInf PROC EXPORT 
2541 8589              *
2542 8589              * A vectored routine to do the work for GetFontInfo.
2543 8589              * Calling routine sets up temp2 to point to the destintation
2544 8589              * record.
2545 8589              *
2546 8589              *
2547 8589              * Inputs:
2548 8589              *	temp2
2549 8589              *	Current Port
2550 8589              *
2551 8589              * Outputs:
2552 8589              *	Font INfo Record
2553 8589              *
2554 8589              * External Refs:
2555 8589              *	none
2556 8589              *
2557 8589              * Entry Points:
2558 8589              *	none
2559 8589              *
2560 8589                       longa on                       ; mode
2561 8589                       longi on 
2562 8589              *
2563 8589              ****************************************************************
2564 8589
2565 8589              ;
2566 8589 A9 00 00              lda   #0
2567 858C 22 64 1F E0           jsl   SetUpFontInfo
2568 8590              ;(that gives us far more than we need, but it's ok)
2569 8590              ;
2570 8590 A5 84                 lda   ascent
2571 8592 87 2E                 sta   [temp2]
2572 8594              ;
2573 8594 A5 E2                 lda   descent
2574 8596 A0 02 00              ldy   #o_FoInDescent
2575 8599 97 2E                 sta   [temp2],y
2576 859B              ;
2577 859B A5 E0                 lda   widMax
2578 859D 18                    clc   
2579 859E 65 F4                 adc   extra
2580 85A0 A0 04 00              ldy   #o_FoInWidmax
2581 85A3 97 2E                 sta   [temp2],y
2582 85A5              ;
2583 85A5 A5 E4                 lda   leading
2584 85A7 A0 06 00              ldy   #o_FoInLeading
2585 85AA 97 2E                 sta   [temp2],y
2586 85AC              ;
2587 85AC 6B                    rtl   
2588 85AD
2589 85AD                       ENDP 
2590 85AD              ;
2591 85AD
2592 85AD              ;
2593 85AD              ****************************************************************
2594 85AD              *
2595 85AD              GetFGSize PROC EXPORT 
2596 85AD              *
2597 85AD              * Returns the current size of the Font Globals record.  This
2598 85AD              * call is provided so that we may add information in the
2599 85AD              * header area of the font.
2600 85AD              *
2601 85AD              *
2602 85AD              * Inputs:
2603 85AD              *	none
2604 85AD              *
2605 85AD              * Outputs:
2606 85AD              *	word : Size of globals in bytes
2607 85AD              *
2608 85AD              * External Refs:
2609 85AD              *	none
2610 85AD              *
2611 85AD              * Entry Points:
2612 85AD              *	none
2613 85AD              *
2614 85AD                       longa on                       ; mode
2615 85AD                       longi on 
2616 85AD              *
2617 85AD              ****************************************************************
2618 85AD
2619 85AD
2620 85AD              OrigDirect equ   1
2621 85AD              RTL1     equ   OrigDirect+2
2622 85AD              RTL2     equ   RTL1+3
2623 85AD              theFGSize equ   RTL2+3
2624 85AD              ;
2625 85AD 20 AA 0F              jsr   QDStart
2626 85B0              ;
2627 85B0 22 B8 1E E0           jsl   GetFGS
2628 85B4 83 09                 sta   theFGSize,s
2629 85B6              ;
2630 85B6 4C EA FB              jmp   BusyEC0
2631 85B9              ;
2632 85B9                       ENDP 
2633 85B9
2634 85B9              ****************************************************************
2635 85B9              *
2636 85B9              iGetFGS  PROC EXPORT 
2637 85B9              *
2638 85B9              * Vectored routine that loads the a-reg with current size of
2639 85B9              * font globals.
2640 85B9              *
2641 85B9              *
2642 85B9              * Inputs:
2643 85B9              *	none
2644 85B9              *
2645 85B9              * Outputs:
2646 85B9              *	a-reg
2647 85B9              *
2648 85B9              * External Refs:
2649 85B9              *	none
2650 85B9              *
2651 85B9              * Entry Points:
2652 85B9              *	none
2653 85B9              *
2654 85B9                       longa on                       ; mode
2655 85B9                       longi on 
2656 85B9              *
2657 85B9              ****************************************************************
2658 85B9
2659 85B9 A9 0E 00              lda   #FGSize
2660 85BC 6B                    rtl   
2661 85BD
2662 85BD
2663 85BD                       ENDP 
2664 85BD
2665 85BD              ****************************************************************
2666 85BD              *
2667 85BD              TextDeref PROC EXPORT 
2668 85BD              *
2669 85BD              * Short routine to deref the handle in a & x and return the pointer
2670 85BD              * in a & x.
2671 85BD              *
2672 85BD              * Temp is destroyed.
2673 85BD              *
2674 85BD              *
2675 85BD              * Inputs:
2676 85BD              *	handle in a & x reg
2677 85BD              *
2678 85BD              * Outputs:
2679 85BD              *	pointer in a & x reg
2680 85BD              *	temp is destroyed.
2681 85BD              *
2682 85BD              * External Refs:
2683 85BD              *	none
2684 85BD              *
2685 85BD              * Entry Points:
2686 85BD              *	none
2687 85BD              *
2688 85BD                       longa on                       ; mode
2689 85BD                       longi on 
2690 85BD              *
2691 85BD              ****************************************************************
2692 85BD
2693 85BD
2694 85BD 85 2A                 sta   TEMP
2695 85BF 86 2C                 stx   TEMP+2
2696 85C1 A0 02 00              ldy   #2
2697 85C4 B7 2A                 lda   [TEMP],y
2698 85C6 AA                    tax   
2699 85C7 A7 2A                 lda   [TEMP]
2700 85C9 60                    rts   
2701 85CA
2702 85CA                       ENDP 
2703 85CA
2704 85CA
2705 85CA
2706 85CA
2707 85CA
2708 85CA
2709 85CA
2710 85CA              ;Tuesday, Nov. 11, 1986  2:15 pm
2711 85CA              ;BHM  x6245
2712 85CA              ;
2713 85CA              ;  GetRomFont
2714 85CA              ;
2715 85CA              ;This QDII call returns information on the ROM font.  It accepts a
2716 85CA              ;pointer, and returns an RFRec in the buffer pointed to.  The
2717 85CA              ;RFRec has the form
2718 85CA              ;
2719 85CA              ;  famNum
2720 85CA              ;  style
2721 85CA              ;  size
2722 85CA              ;  handle  {handle to ROM font}
2723 85CA              ;  namePtr {pointer to ROM font name}
2724 85CA              ;  fbrExtent
2725 85CA              ;
2726 85CA              ;for a total of 16 bytes.  The main point of this call is to shield the
2727 85CA              ;application from the fact that the V.1.0 ROM font doesn't have legal
2728 85CA              ;values for some of those fields.
2729 85CA              ;
2730 85CA              ;This code is only good for the V.1.0 ROM.  Future versions of this call
2731 85CA              ;will be built into ROM, and reflect any changes in the ROM font.
2732 85CA              ;
2733 85CA                       EXPORT GetRomFont 
2734 85CA              GetRomFont PROC 
2735 85CA              ;
2736 85CA              OrigDirect equ   1
2737 85CA              RTL1     equ   OrigDirect+2
2738 85CA              RTL2     equ   RTL1+3
2739 85CA              RFRecPtr equ   RTL2+3
2740 85CA              ;
2741 85CA 20 AA 0F              jsr   QDStart
2742 85CD              ;
2743 85CD A3 09                 lda   RFRecPtr,s
2744 85CF 85 D2                 sta   fontTemp
2745 85D1 A3 0B                 lda   RFRecPtr+2,s
2746 85D3 85 D4                 sta   fontTemp+2
2747 85D5              ;
2748 85D5 22 DF 85 FE           jsl   GetRFRec
2749 85D9              ;
2750 85D9 A0 04 00              ldy   #4
2751 85DC 4C A7 FC              jmp   BusyEC
2752 85DF              ;
2753 85DF                       ENDP 
2754 85DF              ;
2755 85DF                       EXPORT GetRFRec 
2756 85DF              GetRFRec PROC 
2757 85DF              ;
2758 85DF              ;
2759 85DF A9 FE FF              lda   #rfFamNum
2760 85E2 87 D2                 sta   [fontTemp]
2761 85E4              ;
2762 85E4 A9 00 00              lda   #rfStyle
2763 85E7 A0 02 00              ldy   #o_RFStyle
2764 85EA 97 D2                 sta   [fontTemp],y
2765 85EC              ;
2766 85EC A9 08 00              lda   #rfSize
2767 85EF A0 04 00              ldy   #o_RFSize
2768 85F2 97 D2                 sta   [fontTemp],y
2769 85F4              ;
2770 85F4 A9 FC 00              lda   #^SystemFont
2771 85F7 A0 08 00              ldy   #(o_RFHandle+2)
2772 85FA 97 D2                 sta   [fontTemp],y
2773 85FC A9 1B DD              lda   #SystemFont
2774 85FF A0 06 00              ldy   #o_RFHandle
2775 8602 97 D2                 sta   [fontTemp],y
2776 8604              ;
2777 8604 A9 FE 00              lda   #^rfName
2778 8607 A0 0C 00              ldy   #(o_RFNamePtr+2)
2779 860A 97 D2                 sta   [fontTemp],y
2780 860C A9 1D 86              lda   #rfName
2781 860F A0 0A 00              ldy   #o_RFNamePtr
2782 8612 97 D2                 sta   [fontTemp],y
2783 8614              ;
2784 8614 A9 0C 00              lda   #rfFBRExtent
2785 8617 A0 0E 00              ldy   #o_RFFBRXtnt
2786 861A 97 D2                 sta   [fontTemp],y
2787 861C              ;
2788 861C 6B                    rtl   
2789 861D              ;
2790 861D 07           rfName   DC B:7
2791 861E 53 68 61 73  rfNameStr DC B:'Shaston'
2792 8625                       ENDP 
2793 8625
2794 8625                       EJECT 
2795 8625              *******************************************************************************
2796 8625              *
2797 8625              SetUpFontHeadPtr PROC Export 
2798 8625              *
2799 8625              * Description: This routine derefs the current grafports font handle and
2800 8625              *              stuffs the derefed version of it in FontHeadPtr. This should
2801 8625              *              be called by any routine that wants to look at the font 
2802 8625              *              record directly. 
2803 8625              *
2804 8625              * NOTE:        This routine modifies temp
2805 8625              *
2806 8625              *
2807 8625              * Inputs:      NotMuch
2808 8625              *
2809 8625              * Outputs:     FontHeadPtr
2810 8625              *
2811 8625              * External Refs:
2812 8625              *
2813 8625              * Entry Points:
2814 8625              *
2815 8625              *******************************************************************************
2816 8625 A0 76 00              ldy   #(O_font+2)
2817 8628 B7 24                 lda   [portRef],y              ;font handle high word
2818 862A 10 24                 bpl   standardFont             ; if high bit clear we are using a standard font
2819 862C
2820 862C              loadStdData  
2821 862C 85 2C                 sta   temp+2                   ; get the handle to the fastfont stuff
2822 862E A0 74 00              ldy   #o_font
2823 8631 B7 24                 lda   [portRef],y
2824 8633 85 2A                 sta   temp
2825 8635 A7 2A                 lda   [temp]                   ; and deref it...
2826 8637 85 70                 sta   fontHeadPtr
2827 8639 A0 02 00              ldy   #2
2828 863C B7 2A                 lda   [temp],y
2829 863E 85 72                 sta   fontHeadPtr+2
2830 8640              ;
2831 8640 A0 0A 00              ldy   #o_oldFontHandle         ; offset to the old font..
2832 8643 B7 70                 lda   [fontHeadPtr],y          ; get the old font handle
2833 8645 85 2A                 sta   temp
2834 8647 A0 0C 00              ldy   #o_oldFontHandle+2
2835 864A B7 70                 lda   [fontHeadPtr],y
2836 864C 85 2C                 sta   temp+2                   ; set temp to be the old font handle
2837 864E 80 08                 bra   SF0010                   ; and branch into standard font stuff
2838 8650
2839 8650              standardFont  
2840 8650 85 2C                 sta   temp+2
2841 8652 88                    dey   
2842 8653 88                    dey   
2843 8654 B7 24                 lda   [portRef],y
2844 8656 85 2A                 sta   temp
2845 8658              ;
2846 8658              SF0010    
2847 8658 A7 2A                 lda   [temp]
2848 865A 85 70                 sta   fontHeadPtr
2849 865C A0 02 00              ldy   #2
2850 865F B7 2A                 lda   [temp],y
2851 8661 85 72                 sta   fontHeadPtr+2
2852 8663 6B                    rtl   
2853 8664                       EndP 
2854 8664
2855 8664              ;
2856 8664              ;  The following version of GetFontGlobals should go into
2857 8664              ;  the 1.1 ROM, along with the new ROM font
2858 8664              *****************************************************************************
2859 8664              ;  Feb. 6, 1987
2860 8664              ;  BHM  x6245
2861 8664              ;
2862 8664              ;  GetFontLore
2863 8664              ;
2864 8664              ;This call returns information about a font just like GetFontGlobals
2865 8664              ;does.  However, it takes a maximum buffer size parameter, and will
2866 8664              ;not overflow a buffer of that size.  GetFontLore also returns (on the
2867 8664              ;stack) the number of bytes that it actually returned.  This can be
2868 8664              ;less than the given max buffer size for a variety of reasons (for example,
2869 8664              ;there aren't that many bytes of font lore currently defined, or the max
2870 8664              ;cutoff comes in the middle of a field).  Any space in the buffer after
2871 8664              ;that number of bytes will be untouched by this call.
2872 8664              ;
2873 8664              ;GetFontGlobals uses this same code, with some massaging up front.
2874 8664              ;
2875 8664              *
2876 8664              * Change History
2877 8664              * 7/23/87       GCP     corrected typo. temp+2 had been incorrectly entered
2878 8664              *                       as temp2+2.
2879 8664              *                       Replaced jsr BusyEC with BusyEC6.
2880 8664              *
2881 8664              * 13 Oct 88    SMD      the Apple IIGS font header now has 14 bytes due to the
2882 8664              *                       addition of "highOwTLoc", the high word of the offset
2883 8664              *                       to the offset width table.  GetFontLore has been modified
2884 8664              *                       to return this new field if the version is >= 1.02
2885 8664              *
2886 8664              * 30 Dec 88             Steven Glass
2887 8664              *
2888 8664              * Made jmp BusyEC6 into jml BusyEC6 so this can be used in patch.
2889 8664              *
2890 8664              *****************************************************************************
2891 8664              GetFontLore PROC EXPORT 
2892 8664              ;
2893 8664              OrigDirect equ   1
2894 8664              RTL1     equ   OrigDirect+2
2895 8664              RTL2     equ   RTL1+3
2896 8664              maxSize  equ   RTL2+3
2897 8664              FLPtr    equ   maxSize+2
2898 8664              trueSize equ   FLPtr+4
2899 8664              ;
2900 8664 20 AA 0F              jsr   QDStart
2901 8667              ;
2902 8667 A3 09                 lda   maxSize,s
2903 8669 85 2E                 sta   temp2
2904 866B              ;
2905 866B A3 0B                 lda   FLPtr,s
2906 866D 85 D2                 sta   fontTemp
2907 866F A3 0D                 lda   FLPtr+2,s
2908 8671 85 D4                 sta   fontTemp+2
2909 8673              ;
2910 8673 22 7F 86 FE           jsl   GetFL
2911 8677              ;
2912 8677 A5 2E                 lda   temp2
2913 8679 83 0F                 sta   trueSize,s
2914 867B              ;
2915 867B 5C 2F FC FE           jml   BusyEC6
2916 867F              ;
2917 867F                       ENDP 
2918 867F              ;
2919 867F              ;
2920 867F              GetFL    PROC EXPORT 
2921 867F              ;
2922 867F              ; Changed 3/2/89 Mensch
2923 867F              ; Modified this routine so that it is compatible with fastfont stuff
2924 867F 22 25 86 FE           jsl   SetUpFontHeadPtr
2925 8683              ;
2926 8683 A7 70                 lda   [fontHeadPtr]
2927 8685 0A                    asl   a
2928 8686 18                    clc   
2929 8687 65 70                 adc   fontHeadPtr
2930 8689 85 74                 sta   fontRecPtr
2931 868B A5 72                 lda   fontHeadPtr+2
2932 868D 90 01                 bcc   @NoCarry
2933 868F 1A                    inc   a
2934 8690
2935 8690 85 76        @NoCarry sta   fontRecPtr+2
2936 8692              ;
2937 8692 A6 2E                 ldx   temp2
2938 8694 64 2E                 stz   temp2
2939 8696              ;
2940 8696 CA                    dex   
2941 8697 CA                    dex   
2942 8698 10 03                 bpl   Field1
2943 869A 82 8E 00              brl   NoMoreLore
2944 869D              ;
2945 869D              Field1                                  ; 
2946 869D A0 02 00              ldy   #o_FamNum
2947 86A0 B7 70                 lda   [fontHeadPtr],y
2948 86A2 A0 00 00              ldy   #o_FLFamNum
2949 86A5 97 D2                 sta   [fontTemp],y
2950 86A7 E6 2E                 inc   temp2
2951 86A9 E6 2E                 inc   temp2
2952 86AB              ;
2953 86AB CA                    dex   
2954 86AC CA                    dex   
2955 86AD 10 03                 bpl   Field2
2956 86AF 82 79 00              brl   NoMoreLore
2957 86B2              ;
2958 86B2              Field2                                  ; 
2959 86B2 A0 04 00              ldy   #o_Style
2960 86B5 B7 70                 lda   [fontHeadPtr],y
2961 86B7 A0 02 00              ldy   #o_FLStyle
2962 86BA 97 D2                 sta   [fontTemp],y
2963 86BC E6 2E                 inc   temp2
2964 86BE E6 2E                 inc   temp2
2965 86C0              ;
2966 86C0 CA                    dex   
2967 86C1 CA                    dex   
2968 86C2 10 02                 bpl   Field3
2969 86C4 80 65                 bra   NoMoreLore
2970 86C6              ;
2971 86C6              Field3                                  ; 
2972 86C6 A0 06 00              ldy   #o_Size
2973 86C9 B7 70                 lda   [fontHeadPtr],y
2974 86CB A0 04 00              ldy   #o_FLSize
2975 86CE 97 D2                 sta   [fontTemp],y
2976 86D0 E6 2E                 inc   temp2
2977 86D2 E6 2E                 inc   temp2
2978 86D4              ;
2979 86D4 CA                    dex   
2980 86D5 CA                    dex   
2981 86D6 10 02                 bpl   Field4
2982 86D8 80 51                 bra   NoMoreLore
2983 86DA              ;
2984 86DA              Field4                                  ; 
2985 86DA A0 08 00              ldy   #o_Version
2986 86DD B7 70                 lda   [fontHeadPtr],y
2987 86DF A0 06 00              ldy   #o_FLVersion
2988 86E2 97 D2                 sta   [fontTemp],y
2989 86E4 E6 2E                 inc   temp2
2990 86E6 E6 2E                 inc   temp2
2991 86E8              ;
2992 86E8 CA                    dex   
2993 86E9 CA                    dex   
2994 86EA 10 02                 bpl   Field5
2995 86EC 80 3D                 bra   NoMoreLore
2996 86EE              ;
2997 86EE              Field5                                  ; 
2998 86EE A0 06 00              ldy   #o_MaxWd
2999 86F1 B7 74                 lda   [fontRecPtr],y
3000 86F3 A0 08 00              ldy   #o_FLMaxWd
3001 86F6 97 D2                 sta   [fontTemp],y
3002 86F8 E6 2E                 inc   temp2
3003 86FA E6 2E                 inc   temp2
3004 86FC              ;
3005 86FC CA                    dex   
3006 86FD CA                    dex   
3007 86FE 10 02                 bpl   Field6
3008 8700 80 29                 bra   NoMoreLore
3009 8702              ;
3010 8702              Field6                                  ; 
3011 8702 A0 0A 00              ldy   #o_fbrExtent
3012 8705 B7 70                 lda   [fontHeadPtr],y
3013 8707 A0 0A 00              ldy   #o_FLFBRXtent
3014 870A 97 D2                 sta   [fontTemp],y
3015 870C E6 2E                 inc   temp2
3016 870E E6 2E                 inc   temp2
3017 8710              *******
3018 8710              *
3019 8710              * SMD - provide for highOwTLoc field
3020 8710              *
3021 8710              *******
3022 8710 CA                    dex   
3023 8711 CA                    dex   
3024 8712 10 02                 bpl   Field7
3025 8714 80 15                 bra   NoMoreLore
3026 8716
3027 8716 A0 08 00     Field7   ldy   #o_Version
3028 8719 B7 70                 lda   [fontHeadPtr],y
3029 871B C9 05 01              cmp   #V0102                   ;compare to Version 1.02
3030 871E 30 0B                 bmi   NoMoreLore
3031 8720 A0 0C 00              ldy   #o_highOwTLoc            ;SMD - Version 1.02 or greater
3032 8723 B7 70                 lda   [fontHeadPtr],y
3033 8725 97 D2                 sta   [fontTemp],y
3034 8727 E6 2E                 inc   temp2
3035 8729 E6 2E                 inc   temp2
3036 872B              ;
3037 872B              NoMoreLore                              ; 
3038 872B 6B                    rtl   
3039 872C                       ENDP 
3040 872C
3041 872C
3042 872C              ;                copy text/itb
3043 872C              ;Monday, Nov. 17, 1986  2:30 pm
3044 872C              ;
3045 872C              ;QD II call InflateTextBuffer
3046 872C              ;
3047 872C              ;This call takes 2 inputs, a font width and a font height.  If
3048 872C              ;a font with this width and height would require a text buffer
3049 872C              ;either wider or taller than the current text buffer (or both),
3050 872C              ;the call resizes the text buffer.  The resulting text buffer
3051 872C              ;will be at least as wide and tall as the old one, and will
3052 872C              ;also be wide and tall enough for the (hypothetical) font.  The
3053 872C              ;call also clears the new text buffer.
3054 872C              ;
3055 872C              ;If the current text buffer is already large enough (in both
3056 872C              ;directions) for the given width and height, the call leaves
3057 872C              ;it alone.
3058 872C              ;
3059 872C              ;Forced vs. unForced (the great albatross around the neck of
3060 872C              ;the text buffer subroutines):
3061 872C              ;
3062 872C              ;InflateTextBuffer does not allow the new font width to be forced;
3063 872C              ;it will always pad that value.  If the old font width was forced,
3064 872C              ;the new one will also be marked as forced.  For its forced font
3065 872C              ;width value, it will use the old forced font width OR the new value
3066 872C              ;AFTER IT'S BEEN PADDED - whichever is larger.
3067 872C              ;
3068 872C              ;"font width" means fbrExtent, of course.
3069 872C              ;
3070 872C                       EXPORT InflateTextBuffer 
3071 872C              InflateTextBuffer PROC 
3072 872C              ;
3073 872C              ;This is the shell:
3074 872C              ;
3075 872C              OrigDirect equ   1
3076 872C              RTL1     equ   OrigDirect+2
3077 872C              RTL2     equ   RTL1+3
3078 872C              newHeight equ   RTL2+3
3079 872C              newWidth equ   newHeight+2
3080 872C              ;
3081 872C 20 AA 0F              jsr   QDStart
3082 872F
3083 872F A3 0B                 lda   newWidth,s
3084 8731 85 56                 sta   newFontWidth
3085 8733 A3 09                 lda   newHeight,s
3086 8735 85 50                 sta   newTBHeight
3087 8737
3088 8737 22 41 87 FE           jsl   InflateTB
3089 873B
3090 873B A0 04 00              ldy   #4
3091 873E 4C A7 FC              jmp   BusyEC
3092 8741              ;
3093 8741                       ENDP 
3094 8741              ;
3095 8741                       EXPORT InflateTB 
3096 8741              InflateTB PROC 
3097 8741              *              using E0Vectors
3098 8741              ;
3099 8741              ;This does the actual work:
3100 8741              ;
3101 8741              changeFlag equ   fontTemp
3102 8741              ;
3103 8741 A5 56                 lda   newFontWidth
3104 8743 18                    clc   
3105 8744 65 56                 adc   newFontWidth             ;pad
3106 8746 65 56                 adc   newFontWidth
3107 8748 69 24 00              adc   #36
3108 874B              ;
3109 874B 1A                    inc   a
3110 874C              ;
3111 874C 85 56                 sta   newFontWidth             ;ADDED 11/17/86 - BHM
3112 874E              ;
3113 874E 65 28                 adc   maxWidth
3114 8750 0A                    asl   a
3115 8751 0A                    asl   a
3116 8752              ;
3117 8752 85 D4                 sta   fontTemp+2               ;CHANGED 11/17/86 - BHM
3118 8754              ;
3119 8754 A5 4A                 lda   textBufHeight
3120 8756 C5 50                 cmp   newTBHeight
3121 8758 30 06                 bmi   ChangeHeight
3122 875A              ;current height O.K.:
3123 875A 85 50                 sta   newTBHeight
3124 875C 64 D2                 stz   changeFlag
3125 875E 80 05                 bra   GotHeight
3126 8760              ;
3127 8760              ChangeHeight                            ; 
3128 8760 A9 01 00              lda   #1
3129 8763 85 D2                 sta   changeFlag
3130 8765              ;
3131 8765              GotHeight                               ; ;"correct" height in newTBHeight
3132 8765              ;
3133 8765 A5 D4                 lda   fontTemp+2               ;CHANGED 11/17/86 - BHM
3134 8767 4A                    lsr   a
3135 8768 4A                    lsr   a
3136 8769 4A                    lsr   a
3137 876A 4A                    lsr   a
3138 876B 85 54                 sta   newTBRowWords            ;possible new textBufRowWords
3139 876D              ;
3140 876D A5 48                 lda   textBufRowWords
3141 876F C5 54                 cmp   newTBRowWords
3142 8771 30 0B                 bmi   ChangeTBRW
3143 8773              ;textBufRowWords just fine, thank you:
3144 8773 85 54                 sta   newTBRowWords            ;"correct" value in newTBRowWords
3145 8775              ;
3146 8775              ;NEXT PART ADDED 11/17/86 - BHM
3147 8775              ;use old "forced vs. unforced" value as new one
3148 8775              ;(it's not elegant, but it's simple)
3149 8775 A2 00 01              ldx   #256
3150 8778 B5 04                 lda   fontWidth,x
3151 877A 85 56                 sta   newFontWidth
3152 877C              ;END OF ADD-ON
3153 877C 80 16                 bra   GotTBRW
3154 877E              ;
3155 877E              ChangeTBRW                              ; 
3156 877E A9 01 00              lda   #1
3157 8781 85 D2                 sta   changeFlag
3158 8783              ;check to see if the change in width also involves a "forced" width:
3159 8783 A2 00 01              ldx   #256
3160 8786 B5 04                 lda   fontWidth,x
3161 8788 F0 08                 beq   NotForced
3162 878A              ;the old was forced, the new must be also:
3163 878A              ;
3164 878A C5 56                 cmp   newFontWidth             ;(actually, this can be dropped)
3165 878C 30 06                 bmi   ChangeFW                 ;(ditto)
3166 878E              ;font width is forced, but the old value is ok:
3167 878E 85 56                 sta   newFontWidth             ;(ditto)
3168 8790 80 02                 bra   GotFW                    ;(ditto)
3169 8792              ;
3170 8792              ;(NOTE:  if it turns out that we must enlarge the textBufRowWords,
3171 8792              ;then the new fbrExtent - which happens to be padded - must have
3172 8792              ;been larger than the previous fbrExtent, which may have been padded
3173 8792              ;or forced.  Consequently we can drop the comparison between the new
3174 8792              ;fbrExtent and the old, forced fbrExtent.  I would do so, except I
3175 8792              ;haven't quite convinced myself yet . . . .)
3176 8792              ;
3177 8792              NotForced                               ; ;make sure ResetTB knows:
3178 8792 64 56                 stz   newFontWidth
3179 8794              ChangeFW                                ; 
3180 8794              ;(the new value is already in newFontWidth for the change case)
3181 8794              GotFW                                   ; 
3182 8794              ;"Got" either new forced value, old forced value, or 0 indicating unforced
3183 8794              ;
3184 8794              GotTBRW                                 ; 
3185 8794              ;at this point, newTBRowWords, newTBHeight, and newFontWidth have
3186 8794              ;all been accounted for
3187 8794              ;
3188 8794 A5 D2                 lda   changeFlag
3189 8796 F0 04                 beq   NoChange
3190 8798              ;
3191 8798 22 AC 1F E0           jsl   ResetTB
3192 879C              ;
3193 879C              NoChange                                ; 
3194 879C              ;
3195 879C 6B                    rtl   
3196 879D                       ENDP 
3197 879D
3198 879D
3199 879D
3200 879D
3201 879D              ;*****************************************************************************
3202 879D              ;Wednesday, Nov. 12, 1986  1:00 pm
3203 879D              ;Bennet Marks  x6245
3204 879D              ;
3205 879D              ;  GetFontGlobals
3206 879D              ;
3207 879D              * Change History
3208 879D              *
3209 879D              * 7/23/87      	Gary Phipps
3210 879D              *
3211 879D              * Replaced BusyEC with BusyEC4
3212 879D              *
3213 879D              * 30 Dec 88	Steven Glass
3214 879D              *
3215 879D              * Made jmp BusyEC6 into jml BusyEC6 so this can be used in patch.
3216 879D              *
3217 879D              ******************************************************************************
3218 879D              GetFontGlobals PROC EXPORT 
3219 879D
3220 879D              OrigDirect equ   1
3221 879D              RTL1     equ   OrigDirect+2
3222 879D              RTL2     equ   RTL1+3
3223 879D              FGRecPtr equ   RTL2+3
3224 879D              ;
3225 879D 20 AA 0F              jsr   QDStart
3226 87A0              ;
3227 87A0 A3 09                 lda   FGRecPtr,s
3228 87A2 85 D2                 sta   fontTemp
3229 87A4 A3 0B                 lda   FGRecPtr+2,s
3230 87A6 85 D4                 sta   fontTemp+2
3231 87A8              ;
3232 87A8 22 B8 1E E0           jsl   GetFGS
3233 87AC 85 2E                 sta   temp2
3234 87AE              ;
3235 87AE 22 7F 86 FE           jsl   GetFL
3236 87B2              ;
3237 87B2 5C 19 FC FE           jml   BusyEC4
3238 87B6
3239 87B6                       ENDP 
3240 87B6
3241 87B6
3242 87B6
3243 87B6              *****************************************
3244 87B6              *                                       *
3245 87B6              *  file TextSubs1                       *
3246 87B6              *  contains:                            *
3247 87B6              *    ValidChar                          *
3248 87B6              *    GetNextChar                        *
3249 87B6              *    BumpPen                            *
3250 87B6              *                                       *
3251 87B6              *****************************************
3252 87B6              ;
3253 87B6              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
3254 87B6              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
3255 87B6              ;
3256 87B6              ;
3257 87B6              ;
3258 87B6              ******************************************************************************
3259 87B6              *                                                                            *
3260 87B6              *              subroutine ValidChar                                          *
3261 87B6              *                                                                            *
3262 87B6              *                                       started 3/27/86 or before            *
3263 87B6              *                                       Bennet Marks  x6245                  *
3264 87B6              *                                                                            *
3265 87B6              *  This subroutine takes the character whose ascii code is in charToDraw     *
3266 87B6              *  and returns its offset/width value (possibly modified) in the acc. and    *
3267 87B6              *  its index into the font's location table in y.  If the character width is *
3268 87B6              *  0, then it will not be modified; otherwise, ValidChar may alter the       *
3269 87B6              *  width on the basis of the font flags, style mods, chExtra, and spExtra.   *
3270 87B6              *  ValidChar also checks to see if the character is "missing"; if it is,     *
3271 87B6              *  the routine returns the o/w value and location table offset of the        *
3272 87B6              *  "missing symbol.  charToDraw is not altered in any case.                  *
3273 87B6              *                                                                            *
3274 87B6              *  ASSUMPTIONS:  SetUpFontInfo, or its equivalent, has been called.          *
3275 87B6              *                                                                            *
3276 87B6              *  RETURNS:  (possibly modified) offset/width value in acc.; location table  *
3277 87B6              *  offset in y.                                                              *
3278 87B6              *                                                                            *
3279 87B6              *  NOTES:  ValidChar was broken up into smaller subroutines and rewritten on *
3280 87B6              *  or about 2/5/87.  See documentation of the individual subroutines for     *
3281 87B6              *  more information.                                                         *
3282 87B6              *                                                                            *
3283 87B6              *  Every character seen by the text routines passes through ValidChar.       *
3284 87B6              *                                                                            *
3285 87B6              * 2/12/89	Mensch
3286 87B6              * Valid char changed to watch for fastfont flag being set, if this flag is set
3287 87B6              * this routine will simply return the characters width in <A>
3288 87B6              *
3289 87B6              ******************************************************************************
3290 87B6              ;
3291 87B6                       EXPORT iValidChar 
3292 87B6              iValidChar PROC 
3293 87B6              *              using E0Vectors
3294 87B6              ;
3295 87B6              ; This tests for fast font routines...
3296 87B6              ; first test the high bit of the font handle to see if it is set,
3297 87B6              ; if it is, we will call the fast text routines!
3298 87B6 A5 72                 lda   <fastHeadPtr+2
3299 87B8 10 3F                 bpl   iValidCharOld            ; if clear, forget this next stuff
3300 87BA A5 F6                 lda   <fontFlags               ; get the font flags...
3301 87BC 29 03 00              and   #$0003                   ; strip the crap off here
3302 87BF F0 0F                 beq   @stdValue
3303 87C1 C9 02 00              cmp   #$0002                   ; is it numeric spacing?
3304 87C4 D0 05                 bne   @StdMono                 ; use standard monospacing
3305 87C6 A0 30 00              ldy   #'0'
3306 87C9 80 07                 bra   @1
3307 87CB A9 0C 00     @stdMono lda   #12                      ; <widMax
3308 87CE 80 07                 bra   @AddExtrasHere
3309 87D0              @StdValue  
3310 87D0 A4 D6                 ldy   <charToDraw              ; get the character to draw
3311 87D2 B7 70        @1       lda   [<fastHeadPtr],y
3312 87D4 29 FF 00              and   #$00FF
3313 87D7              ;
3314 87D7              ; Now test to see if we are going to be using char extra and spExtra, if so add them in
3315 87D7              ; now, if not then just forget it.
3316 87D7              @AddExtrasHere  
3317 87D7 24 F6                 bit   <fontFlags
3318 87D9 30 1D                 bmi   @done                    ; if no extras are needed we are done
3319 87DB              ; now be sure to add the spExtra and charExtra fields NOTE: this is almost the
3320 87DB              ; same as the other addextras routine except for the fact that it uses fastbucket
3321 87DB              ; instead of bucket.
3322 87DB AA                    tax                            ;temp. storage
3323 87DC              ;
3324 87DC A5 E8                 lda   <fastbucket
3325 87DE 18                    clc   
3326 87DF 65 F0                 adc   chExtra
3327 87E1 85 E8                 sta   <fastbucket
3328 87E3 8A                    txa   
3329 87E4 65 F2                 adc   chExtra+2                ;for chExtra
3330 87E6              ;
3331 87E6 A6 D6                 ldx   charToDraw
3332 87E8 E0 20 00              cpx   #asciiSpace
3333 87EB D0 0B                 bne   @NotASpace
3334 87ED              ;it's a space:
3335 87ED AA                    tax   
3336 87EE A5 E8                 lda   <fastbucket
3337 87F0 18                    clc   
3338 87F1 65 EC                 adc   spExtra
3339 87F3 85 E8                 sta   <fastbucket
3340 87F5 8A                    txa   
3341 87F6 65 EE                 adc   spExtra+2
3342 87F8              @NotASpace                              ; 
3343 87F8              @done     
3344 87F8 6B                    rtl                            ; and just return
3345 87F9              iValidCharOld  
3346 87F9 A5 D6                 lda   charToDraw
3347 87FB              ;
3348 87FB              ;check for missing character, get appropriate o/w value and index:
3349 87FB 22 E8 1F E0           jsl   GetCharVals
3350 87FF              ;
3351 87FF 89 FF 00              bit   #lowByte                 ;check for 0 character width
3352 8802 F0 0C                 beq   ZeroWidth                ;0 width - do not alter
3353 8804              ;
3354 8804              ;maybe alter:
3355 8804 A6 F6                 ldx   fontFlags
3356 8806 F0 04                 beq   NoFntFlgMods
3357 8808              ;
3358 8808              ;apply font flag mods:
3359 8808 22 EC 1F E0           jsl   DoFntFlgMods
3360 880C              ;
3361 880C              NoFntFlgMods                            ; 
3362 880C              ;take care of style extra, chExtra, spExtra:
3363 880C 22 F0 1F E0           jsl   AddExtras
3364 8810              ;
3365 8810              ZeroWidth                               ; 
3366 8810 6B                    rtl   
3367 8811                       ENDP 
3368 8811              ;
3369 8811              ******************************************************************************
3370 8811              *                                                                            *
3371 8811              *              subroutine GetCharVals                                        *
3372 8811              *                                                                            *
3373 8811              *                                       started 2/5/87                       *
3374 8811              *                                       Bennet Marks  x6245                  *
3375 8811              *                                                                            *
3376 8811              *  This subroutine checks the character whose ascii code is in the acc.      *
3377 8811              *  against the current font, so that valid offset/width and location values  *
3378 8811              *  can be obtained.  It returns with the offset/width value in the acc. and  *
3379 8811              *  the index from the start of the font's location table to the character's  *
3380 8811              *  table entry in y.  It particularly checks to see if the character is a    *
3381 8811              *  "missing" (that is, undefined) character; if it is, the routine returns   *
3382 8811              *  the offset/width and index values for the "missing symbol" (the fill-in   *
3383 8811              *  character at the end of the font.                                         *
3384 8811              *                                                                            *
3385 8811              *  ASSUMPTIONS:  font information must be in the usual places (this means    *
3386 8811              *  that SetUpFontInfo has been executed - at least, most of it.)             *
3387 8811              *                                                                            *
3388 8811              *  RETURNS:  (1)  offset/width entry in acc.                                 *
3389 8811              *            (2)  index into location table in y                             *
3390 8811              *                                                                            *
3391 8811              *  NOTES:  this used to be part of ValidChar's in-line code; it was factored *
3392 8811              *  out when it was needed to help calculate the width of the digit 0 for     *
3393 8811              *  "numerical spacing".                                                      *
3394 8811              *                                                                            *
3395 8811              ******************************************************************************
3396 8811              ;
3397 8811                       EXPORT iGetCharVals 
3398 8811              iGetCharVals PROC 
3399 8811              ;
3400 8811              ;character code in acc.:
3401 8811              ;
3402 8811 C5 88                 cmp   firstChar
3403 8813 30 06                 bmi   UseMS                    ;charToDraw < firstChar
3404 8815              ;charToDraw >= firstChar . . .
3405 8815 C5 8A                 cmp   lastChar
3406 8817 30 05                 bmi   GoodRange                ;and < lastChar
3407 8819 F0 03                 beq   GoodRange                ;or = lastChar
3408 881B              ;charToDraw outside firstChar-to-lastChar range:
3409 881B              UseMS                                   ; 
3410 881B A5 8A                 lda   lastChar
3411 881D 1A                    inc   a                        ;code for missing symbol
3412 881E              ;charToDraw in range (and in acc.) OR missing symbol code in acc.
3413 881E              GoodRange                               ; 
3414 881E 38                    sec   
3415 881F E5 88                 sbc   firstChar                ;subtract off to access arrays
3416 8821 0A                    asl   a                        ;(which are 2 bytes per entry)
3417 8822 A8                    tay   
3418 8823 B7 80                 lda   [owTPtr],y               ;offset/width entry
3419 8825 C9 FF FF              cmp   #owMSVal
3420 8828 D0 04                 bne   GoodChar
3421 882A              ;an in-range missing character:
3422 882A A4 8E                 ldy   msCodeT2                 ;use missing symbol code (*2)
3423 882C B7 80                 lda   [owTPtr],y
3424 882E              ;
3425 882E              GoodChar                                ; 
3426 882E 6B                    rtl   
3427 882F                       ENDP 
3428 882F              ;
3429 882F              ;
3430 882F              ******************************************************************************
3431 882F              *                                                                            *
3432 882F              *              subroutine DoFntFlgMods                                       *
3433 882F              *                                                                            *
3434 882F              *                                       started 2/5/87                       *
3435 882F              *                                       Bennet Marks  x6245                  *
3436 882F              *                                                                            *
3437 882F              *  This subroutine applies any of the width modifications specifed by the    *
3438 882F              *  font flags to the offset/width value of the current character.  It        *
3439 882F              *  should only be called if the font flags are not all 0 and the width byte  *
3440 882F              *  of the offset/width entry is not 0; the subroutine does not check for     *
3441 882F              *  these things.  It expects to find the o/w value in the acc., and returns  *
3442 882F              *  the modified value in the acc.                                            *
3443 882F              *                                                                            *
3444 882F              *  ASSUMPTIONS:  o/w entry in acc. (width byte not 0); font flags not all 0. *
3445 882F              *                                                                            *
3446 882F              *  RETURNS:  modified o/w value in acc.                                      *
3447 882F              *                                                                            *
3448 882F              *  NOTES:  this routine was once part of ValidChar.  We have added the       *
3449 882F              *  "numerical width" option to the font flags (if this is set, every charac- *
3450 882F              *  ter is given the same width as the digit 0).                              *
3451 882F              *                                                                            *
3452 882F              *  The routine does not change y.                                            *
3453 882F              *                                                                            *
3454 882F              ******************************************************************************
3455 882F              ;
3456 882F              ***************************************
3457 882F              *                                     *
3458 882F              *  Feb. 5, 1987  2:45 pm              *
3459 882F              *                                     *
3460 882F              ***************************************
3461 882F              ;
3462 882F                       EXPORT iDoFntFlgMods 
3463 882F              iDoFntFlgMods PROC 
3464 882F              ;
3465 882F AA                    tax                            ;temporary storage
3466 8830 A5 F6                 lda   fontFlags
3467 8832 89 01 00              bit   #FxdWdthBit
3468 8835 F0 07                 beq   NotFixedWidth
3469 8837              ;fixed width:
3470 8837 8A                    txa                            ;get back o/w value
3471 8838 29 00 FF              and   #highByte                ;blot out width byte
3472 883B 05 E0                 ora   widMax                   ;replace with widMax
3473 883D 6B                    rtl   
3474 883E              ;
3475 883E              NotFixedWidth                           ; 
3476 883E 89 02 00              bit   #$0002
3477 8841 F0 07                 beq   NotNumWidth
3478 8843
3479 8843              ; numerical width:
3480 8843 8A                    txa   
3481 8844 29 00 FF              and   #highByte
3482 8847 05 F8                 ora   digitWidth
3483 8849 6B                    rtl   
3484 884A
3485 884A 8A           NotNumWidth txa   
3486 884B 6B                    rtl   
3487 884C                       ENDP 
3488 884C              ;
3489 884C              ;
3490 884C              ******************************************************************************
3491 884C              *                                                                            *
3492 884C              *              subroutine AddExtras                                          *
3493 884C              *                                                                            *
3494 884C              *                                       started 2/5/87                       *
3495 884C              *                                       Bennet Marks  x6245                  *
3496 884C              *                                                                            *
3497 884C              *  This subroutine modifies the width byte of a character's offset/width     *
3498 884C              *  value on the basis of extra (the additional character width that comes    *
3499 884C              *  from style mods), chExtra (which is added to the width of every char-     *
3500 884C              *  acter that has non-zero width), and spExtra (which is added to the width  *
3501 884C              *  of the space character).  It expects to find the o/w value in the acc.    *
3502 884C              *  (possibly already modified by the font flags), and returns the modified   *
3503 884C              *  value in the acc.                                                         *
3504 884C              *                                                                            *
3505 884C              *  ASSUMPTIONS:  offset/width value in acc.                                  *
3506 884C              *                                                                            *
3507 884C              *  RETURNS:  new offset/width value in acc.                                  *
3508 884C              *                                                                            *
3509 884C              *  NOTES:  AddExtras does not check to see if the width value is 0.          *
3510 884C              *                                                                            *
3511 884C              *  AddExtras does all the bookkeeping for chExtra and spExtra, which are     *
3512 884C              *  each 4-byte, fixed-point numbers.  (This would be a good place to handle  *
3513 884C              *  fractional pixelwidths.)  However, it ASSUMES that the new, modified      *
3514 884C              *  width is neither greater than 255 pixels or less than 0.  (Possibly we    *
3515 884C              *  should add in a check.  Also, we could cut down on time for strings by    *
3516 884C              *  computing (chExtra AND chExtra+2 AND spExtra AND spExtra+2) in            *
3517 884C              *  SetUpFontInfo - it would tell us quick whether to bother with these       *
3518 884C              *  calculations.  But it's probably not worth it.)                           *
3519 884C              *                                                                            *
3520 884C              *  The only character to which spExtra is applied is ascii $20.              *
3521 884C              *                                                                            *
3522 884C              *  The routine does not alter y.                                             *
3523 884C              *                                                                            *
3524 884C              ******************************************************************************
3525 884C              ;
3526 884C              ***************************************
3527 884C              *                                     *
3528 884C              *  Feb. 5, 1987  2:45 pm              *
3529 884C              *                                     *
3530 884C              ***************************************
3531 884C              ;
3532 884C                       EXPORT iAddExtras 
3533 884C              iAddExtras PROC 
3534 884C              ;
3535 884C 18                    clc   
3536 884D 65 F4                 adc   extra                    ;for style
3537 884F              ;
3538 884F                       Export AddExtras2 
3539 884F              AddExtras2  
3540 884F AA                    tax                            ;temp. storage
3541 8850              ;
3542 8850 A5 94                 lda   bucket
3543 8852 18                    clc   
3544 8853 65 F0                 adc   chExtra
3545 8855 85 94                 sta   bucket
3546 8857 8A                    txa   
3547 8858 65 F2                 adc   chExtra+2                ;for chExtra
3548 885A              ;
3549 885A A6 D6                 ldx   charToDraw
3550 885C E0 20 00              cpx   #asciiSpace
3551 885F D0 0B                 bne   NotASpace
3552 8861              ;it's a space:
3553 8861 AA                    tax   
3554 8862 A5 94                 lda   bucket
3555 8864 18                    clc   
3556 8865 65 EC                 adc   spExtra
3557 8867 85 94                 sta   bucket
3558 8869 8A                    txa   
3559 886A 65 EE                 adc   spExtra+2
3560 886C              NotASpace                               ; 
3561 886C 6B                    rtl   
3562 886D                       ENDP 
3563 886D              ;
3564 886D              ;
3565 886D              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
3566 886D              ;
3567 886D              *****************************************
3568 886D              *                                       *
3569 886D              *  current date and time:               *
3570 886D              *    5:30 PM, 3/30/86                   *
3571 886D              *                                       *
3572 886D              *****************************************
3573 886D              ;
3574 886D              *******************************************************************************
3575 886D              *                                                                             *
3576 886D              *              subroutine GetNextChar                                         *
3577 886D              *                                                                             *
3578 886D              *                                       started 3/27/86 or before             *
3579 886D              *                                       Bennet Marks x6245                    *
3580 886D              *                                                                             *
3581 886D              *  ABSTRACT:  this subroutine is used to get successive characters from a     *
3582 886D              *  string, text block, or Cstring, and to signal (using the carry bit as a    *
3583 886D              *  flag) whether any character remained to be fetched.  The new character, if *
3584 886D              *  any, is placed in charToDraw.                                              *
3585 886D              *                                                                             *
3586 886D              *  The "no new characters" condition is equivalent to textLength = 0 (for     *
3587 886D              *  strings and text blocks), or textPtr pointing to a 0 byte (for Cstrings).  *
3588 886D              *                                                                             *
3589 886D              *  ASSUMPTIONS:  text call information (drawVerb, textPtr, textLength if      *
3590 886D              *  needed; ordinarily set by DrawString, DrawText, or DrawCString)            *
3591 886D              *                                                                             *
3592 886D              *  RETURNS:                                                                   *
3593 886D              *              (1)  carry bit clear if a new character was fetched, carry bit *
3594 886D              *                   set otherwise.                                            *
3595 886D              *              (2)  new character (if any) in charToDraw                      *
3596 886D              *                                                                             *
3597 886D              *  ALTERS:                                                                    *
3598 886D              *              (1)  textPtr - incremented to point to next character IF a     *
3599 886D              *                   new character was fetched                                 *
3600 886D              *              (2)  (for strings and text blocks) textLength - decremented IF *
3601 886D              *                   a new character was fetched                               *
3602 886D              *                                                                             *
3603 886D              *  If, on the other hand, there was no new character to be fetched, those     *
3604 886D              *  values are left alone: for strings and text blocks, textLength is left at  *
3605 886D              *  0, and textPtr is left pointing 1 byte beyond the last byte of the string; *
3606 886D              *  for Cstrings, textPtr is left pointing at the 0 byte which terminates the  *
3607 886D              *  Cstring.                                                                   *
3608 886D              *                                                                             *
3609 886D              *  NOTES:  every character in a string, text block, or Cstring passes through *
3610 886D              *  this subroutine.  It is the sole place where the differing termination     *
3611 886D              *  conditions are used.  Consequently it is the best place for a RAM patch to *
3612 886D              *  handle other kinds of text data structures, or other termination condi-    *
3613 886D              *  tions (e.g., terminate string on a CR).  It should have a vector entry     *
3614 886D              *  point.                                                                     *
3615 886D              *                                                                             *
3616 886D              *  GetNextChar returns with an RTL.                                           *
3617 886D              *                                                                             *
3618 886D              *******************************************************************************
3619 886D              ;
3620 886D              *****************************************
3621 886D              *                                       *
3622 886D              *  V.0.1.0 - 3/27/86                    *
3623 886D              *                                       *
3624 886D              *****************************************
3625 886D              ;
3626 886D                       EXPORT iGetNextChar 
3627 886D              iGetNextChar PROC 
3628 886D A5 38                 lda   DrawVerb
3629 886F C9 02 00              cmp   #DrawCStrVerb
3630 8872 F0 15                 beq   ItsACString
3631 8874              ;no, it's ordinary string or text block:
3632 8874 A5 D8                 lda   textLength
3633 8876 F0 22                 beq   NoMoreChars              ;0 textLength
3634 8878 A7 DA                 lda   [textPtr]                ;get current character
3635 887A 29 FF 00              and   #lowByte
3636 887D 85 D6                 sta   charToDraw
3637 887F C6 D8                 dec   textLength
3638 8881 E6 DA D0 02           IncLong textPtr                ;to point to next character
3639 8887 18                    clc                            ;to signal presence of current char.
3640 8888 6B                    rtl   
3641 8889              ;
3642 8889              ItsACString                             ; 
3643 8889 A7 DA                 lda   [textPtr]
3644 888B 29 FF 00              and   #lowByte
3645 888E F0 0A                 beq   NoMoreChars              ;0 byte in string
3646 8890 85 D6                 sta   charToDraw
3647 8892 E6 DA D0 02           IncLong textPtr 
3648 8898 18                    clc   
3649 8899 6B                    rtl   
3650 889A              ;
3651 889A              NoMoreChars                             ; 
3652 889A 38                    sec                            ;signal no characters remaining
3653 889B 6B                    rtl   
3654 889C                       ENDP 
3655 889C              *****************************************
3656 889C              *                                       *
3657 889C              *  end of GetNextChar                   *
3658 889C              *                                       *
3659 889C              *****************************************
3660 889C              ;
3661 889C              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
3662 889C              ;
3663 889C              *****************************************
3664 889C              *                                       *
3665 889C              *  current date and time:               *
3666 889C              *    3:40 PM, 3/27/86                   *
3667 889C              *                                       *
3668 889C              *****************************************
3669 889C              ;
3670 889C              *******************************************************************************
3671 889C              *                                                                             *
3672 889C              *              subroutine BumpPen                                             *
3673 889C              *                                                                             *
3674 889C              *                                       started 3/27/86 or before             *
3675 889C              *                                       Bennet Marks x6245                    *
3676 889C              *                                                                             *
3677 889C              *  ABSTRACT:  this subroutine increases the 0-page value currPen by the sum   *
3678 889C              *  of the character widths of a sequence of characters.  The sequence can be  *
3679 889C              *  a string, text block, or Cstring; or it can be a "final substring", that   *
3680 889C              *  is, all the characters of a string ("or text block or Cstring"; please in- *
3681 889C              *  sert this phrase wherever it seems useful) from some particular character  *
3682 889C              *  in it to the end of it.                                                    *
3683 889C              *                                                                             *
3684 889C              *  In either case, the first character to be used (not necessarily the first  *
3685 889C              *  character of the original string) should be the most recent character      *
3686 889C              *  fetched and placed in charToDraw by the subroutine GetNextChar.  See       *
3687 889C              *  ASSUMPTIONS and NOTES below for more detail.                               *
3688 889C              *                                                                             *
3689 889C              *  ASSUMPTIONS:  BumpPen assumes that GetNextChar has been called one or more *
3690 889C              *  times already, so that the first character to be included in the bumping   *
3691 889C              *  process is already in charToDraw, and textPtr is pointing at the next      *
3692 889C              *  character (if any); and, for strings and text blocks, textLength has al-   *
3693 889C              *  ready been decremented so that it represents the number of characters      *
3694 889C              *  left (that haven't already been fetched by GetNextChar).  (see NOTES       *
3695 889C              *  below)                                                                     *
3696 889C              *                                                                             *
3697 889C              *  BumpPen calls GetNextChar and ValidChar, so font and text information      *
3698 889C              *  used by those subroutines must be set up (see documentation for each).     *
3699 889C              *                                                                             *
3700 889C              *  Strings or substrings ("or etc.") of length 0 should never make it to this *
3701 889C              *  subroutine; the calling routine should screen them out on the basis of its *
3702 889C              *  previous call to GetNextChar.  (however, the number of remaining charac-   *
3703 889C              *  characters, not yet fetched by GetNextChar, may be 0)                      *
3704 889C              *                                                                             *
3705 889C              *  RETURNS:  new value in currPen.                                            *
3706 889C              *                                                                             *
3707 889C              *  ALTERS:  textPtr and (for strings and text blocks) textLength.             *
3708 889C              *                                                                             *
3709 889C              *  NOTES:  in the abstract above, a big deal seems to have been made about    *
3710 889C              *  BumpPen's ability to handle "final substrings" as well as complete         *
3711 889C              *  strings.  This was mentioned explicitly because BumpPen is frequently used *
3712 889C              *  to "finish off" the updating of currPen after it has been partially up-    *
3713 889C              *  dated by characters handled by PutChar.                                    *
3714 889C              *                                                                             *
3715 889C              *  However, the truth of the matter is that, because of the way GetNextChar   *
3716 889C              *  works, NONE of the QD II text routines can tell the difference between a   *
3717 889C              *  string and a "final substring".  If textPtr and (when used) textLength are *
3718 889C              *  kept up to date - GetNextChar does this - any final substring looks just   *
3719 889C              *  like a string.                                                             *
3720 889C              *                                                                             *
3721 889C              *  BumpPen is only used with strings, text blocks, and Cstrings.  It does not *
3722 889C              *  work with individual characters (although it will handle strings of length *
3723 889C              *  1 just fine).                                                              *
3724 889C              *                                                                             *
3725 889C              *  BumpPen returns with an RTL.                                               *
3726 889C              *                                                                             *
3727 889C              *******************************************************************************
3728 889C              ;
3729 889C              *****************************************
3730 889C              *                                       *
3731 889C              *  V.0.1.0 - 3/27/86                    *
3732 889C              *                                       *
3733 889C              *****************************************
3734 889C              ;
3735 889C                       EXPORT iBumpPen 
3736 889C              iBumpPen PROC 
3737 889C              *              using E0Vectors
3738 889C              ;
3739 889C              NextChar                                ; 
3740 889C 22 50 1F E0           jsl   ValidChar
3741 88A0 29 FF 00              and   #lowByte                 ;get character width
3742 88A3 18                    clc   
3743 88A4 65 AC                 adc   currPen
3744 88A6 85 AC                 sta   currPen
3745 88A8              ;
3746 88A8 22 54 1F E0           jsl   GetNextChar
3747 88AC 90 EE                 bcc   NextChar                 ;if any
3748 88AE              ;no more:
3749 88AE 6B                    rtl   
3750 88AF                       ENDP 
3751 88AF              *****************************************
3752 88AF              *                                       *
3753 88AF              *  end of BumpPen                       *
3754 88AF              *                                       *
3755 88AF              *****************************************
3756 88AF              ;
3757 88AF              ;                copy text/TextSubs2
3758 88AF              *****************************************
3759 88AF              *                                       *
3760 88AF              *  file TextSubs2                       *
3761 88AF              *    CalcDrawStatus                     *
3762 88AF              *    TextAndMinRect                     *
3763 88AF              *                                       *
3764 88AF              *****************************************
3765 88AF              ;
3766 88AF              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
3767 88AF              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
3768 88AF              ;
3769 88AF              *****************************************
3770 88AF              *                                       *
3771 88AF              *  current date and time:               *
3772 88AF              *    3:00 PM, 3/30/86                   *
3773 88AF              *                                       *
3774 88AF              *****************************************
3775 88AF              ;
3776 88AF              *******************************************************************************
3777 88AF              *                                                                             *
3778 88AF              *              subroutine CalcDrawStatus                                      *
3779 88AF              *                                                                             *
3780 88AF              *                                       started 3/28/86                       *
3781 88AF              *                                       Bennet Marks x6245                    *
3782 88AF              *                                                                             *
3783 88AF              *  ABSTRACT:  this subroutine determines whether it is appropriate to draw    *
3784 88AF              *  anything into the current grafport's pixelmap.  Two conditions are         *
3785 88AF              *  checked:  (1)  is the pen visible?  (2)  is the minRect non-null?  If the  *
3786 88AF              *  answers to both those questions are yes, CalcDrawStatus returns with the   *
3787 88AF              *  carry bit cleared, meaning drawing can be done.  Otherwise, no drawing can *
3788 88AF              *  be done; the carry is set.  The subroutine also sets (by a call to         *
3789 88AF              *  makeMinRect) the minRect based on the current grafport.                    *
3790 88AF              *                                                                             *
3791 88AF              *  ASSUMPTIONS:  the subroutine requires the usual information about the      *
3792 88AF              *  current grafport to be on 0-page.  This can be insured by calls to         *
3793 88AF              *  PortLoc2ZP and SetUpPortRegions.                                           *
3794 88AF              *                                                                             *
3795 88AF              *  RETURNS:  carry bit clear if drawing is appropriate (i.e., pen visible     *
3796 88AF              *  and minRect non-null), carry bit set otherwise. Overflow set if ok to      *
3797 88AF              *  use fasttext routines                                                      *
3798 88AF              *                                                                             *
3799 88AF              *  ALTERS:  minRect (and anything else changed by a call to makeMinRect).     *
3800 88AF              *                                                                             *
3801 88AF              *  NOTES:  CalcDrawStatus returns via an RTL.                                 *
3802 88AF              *                                                                             *
3803 88AF              *******************************************************************************
3804 88AF              ;
3805 88AF              *****************************************
3806 88AF              *                                       *
3807 88AF              *  V.0.1.0 - 3/28/86                    *
3808 88AF              *                                       *
3809 88AF              * 2/24/89	Mensch
3810 88AF              * Modified to support fasttext routines this now sets the overflow flag if
3811 88AF              * MinRect can be safely relied upon to be a "safe" drawing area
3812 88AF              *
3813 88AF              *****************************************
3814 88AF              ;
3815 88AF                       EXPORT iCalcDrawStatus 
3816 88AF              iCalcDrawStatus PROC 
3817 88AF              ;
3818 88AF              *              USING E0Vectors
3819 88AF              *              USING CoreData
3820 88AF              ;
3821 88AF A0 72 00              ldy   #O_pnVis
3822 88B2 B7 24                 lda   [portRef],y
3823 88B4 30 57                 bmi   PenInvisible
3824 88B6              ;pen visible, so check minRect:
3825 88B6 A9 01 C0              lda   #(-maxInt)               ;set up max rectangle in minRect
3826 88B9 85 00                 sta   minRect+O_V1
3827 88BB 85 02                 sta   minRect+O_H1
3828 88BD A9 FF 3F              lda   #maxInt
3829 88C0 85 04                 sta   minRect+O_V2
3830 88C2 85 06                 sta   minRect+O_H2
3831 88C4              ;
3832 88C4 22 94 1E E0           jsl   MakeMinRect
3833 88C8 B0 44                 bcs   NullRect
3834 88CA              ; pen visible, rect not null; signal o.k. to draw:
3835 88CA              ; Also test regionPointers A and B for rectangular reqions, If they are
3836 88CA              ; rectangular set the overflow flag
3837 88CA
3838 88CA A7 54                 lda   [<rgnPtrA]
3839 88CC 07 64                 ora   [<rgnPtrB]
3840 88CE C9 0A 00              cmp   #10                      ; are they both rects???
3841 88D1 D0 33                 bne   NotRects
3842 88D3              ;
3843 88D3              ; 2/24/89 Mensch
3844 88D3              ; Add checks for grafport fields, fgcolor bgcolor and txMode
3845 88D3              ; 3/21/89 and txFace
3846 88D3 A0 82 00              ldy   #o_txMode
3847 88D6 B7 24                 lda   [<portRef],y             ; combine mode and forcolor
3848 88D8 29 FB FF              and   #$FFFB                   ; strip off bit 3...
3849 88DB A0 8C 00              ldy   #o_FGColor               ; offset to foreground color field
3850 88DE 17 24                 ora   [<portRef],y             ; combine mode and forcolor
3851 88E0 A0 80 00              ldy   #o_txFace
3852 88E3 17 24                 ora   [<portRef],y             ; also take into account the text face...
3853 88E5 D0 1F                 bne   NotRects                 ; are they both zero???
3854 88E7 A0 8E 00              ldy   #o_BGColor
3855 88EA B7 24                 lda   [<portRef],y
3856 88EC C9 FF FF              cmp   #$FFFF
3857 88EF F0 0A                 beq   @cont
3858 88F1 C9 03 00              cmp   #$0003
3859 88F4 F0 05                 beq   @cont
3860 88F6 C9 0F 00              cmp   #$000F
3861 88F9 D0 0B                 bne   NotRects
3862 88FB A5 0C        @cont    lda   <portSCB
3863 88FD 29 80 00              and   #$0080
3864 8900 F0 04                 beq   NotRects
3865 8902 E2 40                 sep   #$40                     ; set overflow
3866 8904 18                    clc                            ; clear carry
3867 8905 6B                    rtl   
3868 8906              NotRects  
3869 8906 8F 00 30 FF           sta   >$FF3000                 ; trigger analyser
3870 890A B8                    clv                            ; clear rect flag
3871 890B 18                    clc                            ; we got a minrect
3872 890C 6B                    rtl   
3873 890D              ;
3874 890D              PenInvisible                            ; 
3875 890D 38                    sec                            ;to signal not O.K.
3876 890E              NullRect                                ; ;carry already set by makeMinRect
3877 890E 6B                    rtl   
3878 890F 80 F5                 bra   NotRects
3879 8911                       ENDP 
3880 8911              *****************************************
3881 8911              *                                       *
3882 8911              *  end of CalcDrawStatus                *
3883 8911              *                                       *
3884 8911              *****************************************
3885 8911              ;
3886 8911              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
3887 8911              ;
3888 8911              *****************************************
3889 8911              *                                       *
3890 8911              *  current date and time:               *
3891 8911              *    10:00 PM, 5/13/86                  *
3892 8911              *                                       *
3893 8911              *****************************************
3894 8911              ;
3895 8911              *******************************************************************************
3896 8911              *                                                                             *
3897 8911              *              subroutine TextAndMinRect                                      *
3898 8911              *                                                                             *
3899 8911              *                                       started 3/28/86                       *
3900 8911              *                                       Bennet Marks x6245                    *
3901 8911              *                                                                             *
3902 8911              *  ABSTRACT:  this subroutine calculates the intersection of the "text rec-   *
3903 8911              *  tangle" and the current minRect, and replaces minRect with the result.  If *
3904 8911              *  the result is a null rectangle, the carry bit is set on return; otherwise  *
3905 8911              *  the carry is cleared.                                                      *
3906 8911              *                                                                             *
3907 8911              *  The "text rectangle" is the smallest rectangle that completely encloses a  *
3908 8911              *  graphical text object and its background (by "graphical text object", we   *
3909 8911              *  mean character, string, text block, or Cstring).  It is represented in     *
3910 8911              *  local coordinates.  In this subroutine, we do not start with the text      *
3911 8911              *  rectangle as a given, but calculate it on the fly from leftExtent,         *
3912 8911              *  rightExtent, startBufPen, and bufPen.  The conversion to local coordinates *
3913 8911              *  is also done on the fly.                                                   *
3914 8911              *                                                                             *
3915 8911              *  ASSUMPTIONS:  TextAndMinRect expects:                                      *
3916 8911              *                                                                             *
3917 8911              *              (1)  a minRect on 0-page (usually set by a call to             *
3918 8911              *                   CalcDrawStatus, which calls MakeMinRect)                  *
3919 8911              *              (2)  startBufPen, and buffer-to-local translation values       *
3920 8911              *                   (usually set by a call to SetUpBufInfo)                   *
3921 8911              *              (3)  bufPen, leftExtent, and rightExtent (usually set by       *
3922 8911              *                   SetUpBufInfo and altered by 1 ore more calls to PutChar)  *
3923 8911              *              (4)  chHeight, generally from SetUpFontInfo (we may wind up    *
3924 8911              *                   using something other than chHeight eventually; see NOTE  *
3925 8911              *                   embedded in code below)                                   *
3926 8911              *                                                                             *
3927 8911              *  RETURNS:  (1)  carry bit clear if the intersection is non-null, carry set  *
3928 8911              *                 otherwise                                                   *
3929 8911              *            (2)  resulting rectangle in minRect on 0-page                    *
3930 8911              *                                                                             *
3931 8911              *  NOTES: TextAndMinRect returns via an RTL                                   *
3932 8911              *                                                                             *
3933 8911              *******************************************************************************
3934 8911              ;
3935 8911              *****************************************
3936 8911              *                                       *
3937 8911              *  V.0.1.0 - 3/28/86                    *
3938 8911              *                                       *
3939 8911              *    addded a missing RTL (of all       *
3940 8911              *    things!) - 5/13/86, BHM            *
3941 8911              *                                       *
3942 8911              *****************************************
3943 8911              ;
3944 8911                       EXPORT iTextAndMinRect 
3945 8911              iTextAndMinRect PROC 
3946 8911              ;
3947 8911              ;find left boundary of text rectangle (first in buffer coordinates):
3948 8911 A5 CE                 lda   leftExtent
3949 8913 C5 92                 cmp   startBufPen              ;we want the smaller
3950 8915 30 02                 bmi   LeftExtOK                ;it's leftExtent
3951 8917 A5 92                 lda   startBufPen              ;no, it's startBufPen
3952 8919              LeftExtOK                               ; 
3953 8919              ;
3954 8919              ;shift to local coordinates
3955 8919 18                    clc   
3956 891A 65 A0                 adc   hBufToLoc
3957 891C              ;
3958 891C              ;compare against corresponding minRect length
3959 891C C5 02                 cmp   minRect+O_H1             ;we now want the larger
3960 891E 30 02                 bmi   MRH1Larger               ;minRect.H1 is larger
3961 8920 85 02                 sta   minRect+O_H1             ;no it's not, so replace it
3962 8922              MRH1Larger                              ; 
3963 8922              ;
3964 8922              ;the rest is very much the same
3965 8922              ;
3966 8922 A9 01 00              lda   #1                       ;the top row, in buffer coordinates
3967 8925 18                    clc   
3968 8926 65 A2                 adc   vBufToLoc                ;switch to local coordinates
3969 8928 C5 00                 cmp   minRect+O_V1             ;and compare
3970 892A 30 02                 bmi   MRV1Larger
3971 892C 85 00                 sta   minRect+O_V1             ;replace if necessary
3972 892E              MRV1Larger                              ; 
3973 892E              ;
3974 892E A5 D0                 lda   rightExtent
3975 8930              ;For rightExtent, we must add 1 to maintain the QD distinction between pixels
3976 8930              ;and rectangles (the enclosing rectangle always has a right boundary 1 greater
3977 8930              ;than the pixel it encloses; same for bottom boundary, but not left or top).
3978 8930              ;bufPen is, serendipitously, already 1 greater than the rightmost pixel of
3979 8930              ;the character and its background, because it is the starting pen position
3980 8930              ;for the next character
3981 8930 1A                    inc   a
3982 8931 C5 90                 cmp   bufPen                   ;we want the larger of these two
3983 8933 10 02                 bpl   rightExtOK
3984 8935 A5 90                 lda   bufPen
3985 8937              rightExtOK                              ; 
3986 8937              ;
3987 8937              ;shift to local
3988 8937 18                    clc   
3989 8938 65 A0                 adc   hBufToLoc
3990 893A C5 06                 cmp   minRect+O_H2             ;compare to minRect - want the smaller
3991 893C 10 02                 bpl   MRH2Smaller              ;minRect.H2 smaller
3992 893E 85 06                 sta   minRect+O_H2             ;no, so replace it
3993 8940              MRH2Smaller                             ; 
3994 8940              ;
3995 8940              ;H2 should be strictly larger than H1
3996 8940 A5 02                 lda   minRect+O_H1
3997 8942 C5 06                 cmp   minRect+O_H2
3998 8944 30 03                 bmi   HOK                      ;horizontal length ok
3999 8946 82 17 00              brl   NullRect                 ;no, it's not
4000 8949              ;
4001 8949              HOK                                     ; 
4002 8949              ;
4003 8949 A5 CA                 lda   chHeight                 ;bottom row in buffer coord.'s
4004 894B 1A                    inc   a                        ;for the same reason as before
4005 894C              ;[NOTE:  this chHeight may be embarrassing later when we have style mods that
4006 894C              ;change the nominal buffer size.  We may want a new 0-page location to hold a
4007 894C              ;mutable value]
4008 894C 18                    clc   
4009 894D 65 A2                 adc   vBufToLoc                ;local coord.
4010 894F C5 04                 cmp   minRect+O_V2
4011 8951 10 02                 bpl   MRV2Smaller              ;minRect.V2 fine
4012 8953 85 04                 sta   minRect+O_V2             ;or replace it
4013 8955              MRV2Smaller                             ; 
4014 8955              ;
4015 8955              ;V2 should be strictly greater than V1
4016 8955 A5 00                 lda   minRect+O_V1
4017 8957 C5 04                 cmp   minRect+O_V2
4018 8959 30 03                 bmi   VOK                      ;vertical ok
4019 895B 82 02 00              brl   NullRect                 ;nuh-uh!
4020 895E              ;
4021 895E              VOK                                     ; 
4022 895E              ;
4023 895E 18                    clc                            ;to signal non-null intersection
4024 895F 6B                    rtl   
4025 8960              ;
4026 8960              NullRect                                ; 
4027 8960 38                    sec                            ;or not
4028 8961 6B                    rtl   
4029 8962                       ENDP 
4030 8962              *****************************************
4031 8962              *                                       *
4032 8962              *  end of TextAndMinRect                *
4033 8962              *                                       *
4034 8962              *****************************************
4035 8962              ;
4036 8962              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
4037 8962              ;
4038 8962              ;                copy text/TextSubs3
4039 8962              *****************************************
4040 8962              *                                       *
4041 8962              *  file TextSubs3                       *
4042 8962              *    CalcTextBounds                     *
4043 8962              *                                       *
4044 8962              *****************************************
4045 8962              ;
4046 8962              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
4047 8962              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
4048 8962              ;
4049 8962              *****************************************
4050 8962              *                                       *
4051 8962              *  current date and time:               *
4052 8962              *    9:45 AM, 4/15/86                   *
4053 8962              *                                       *
4054 8962              *****************************************
4055 8962              ;
4056 8962              *******************************************************************************
4057 8962              *                                                                             *
4058 8962              *              subroutine CalcTextBounds                                      *
4059 8962              *                                                                             *
4060 8962              *                                       started 3/28/86                       *
4061 8962              *                                       Bennet Marks x6245                    *
4062 8962              *                                                                             *
4063 8962              *  ABSTRACT:  this subroutine calculates several pointers, offsets, and other *
4064 8962              *  values which are used by the subroutine BlowItUp to determine which        *
4065 8962              *  chunk of the text buffer needs to be transferred to what piece of the      *
4066 8962              *  destination pixelmap (BlowItUp is the routine which does that transfer,    *
4067 8962              *  also in the process expanding the 1 bit/pixel text buffer information      *
4068 8962              *  into the 2 bit/pixel or 4 bit/pixel information needed by the destina-     *
4069 8962              *  tion - hence the name).                                                    *
4070 8962              *                                                                             *
4071 8962              *  ASSUMPTIONS:  CalcTextBounds requires the following:                       *
4072 8962              *                                                                             *
4073 8962              *              (1)  the usual current grafport information on 0-page; in      *
4074 8962              *                   particular, width, boundsRect, imageRef, and portSCB      *
4075 8962              *              (2)  similar information for the text buffer - bufRowBytes     *
4076 8962              *                   and bufPtr                                                *
4077 8962              *              (3)  the results of TextAndMinRect placed in 0-page's minRect  *
4078 8962              *                                                                             *
4079 8962              *  RETURNS:  the subroutine returns the following:                            *
4080 8962              *                                                                             *
4081 8962              *              (1)  tbRowPtr - a 4-byte pointer to the start of the first     *
4082 8962              *                   (i.e., highest) text buffer row which is to be trans-     *
4083 8962              *                   ferred to the destination pixelmap (that is, the row      *
4084 8962              *                   corresponding to the top of our new minRect)              *
4085 8962              *                                                                             *
4086 8962              *              (2)  tbStartByte - the offset, in bytes, from tbRowPtr to the  *
4087 8962              *                   first text buffer word containing any image bits which    *
4088 8962              *                   are to be transferred into to be transferred into the     *
4089 8962              *                   destination pixelmap (that is, the word containing the    *
4090 8962              *                   pixel corresponding to the left side of minRect).  This   *
4091 8962              *                   will always be even.                                      *
4092 8962              *                                                                             *
4093 8962              *              (3)  pmRowPtr - a 4-byte pointer to the start of the row in    *
4094 8962              *                   the destination pixelmap corresponding to the top of      *
4095 8962              *                   minRect (see tbRowPtr).                                   *
4096 8962              *                                                                             *
4097 8962              *              (4)  pmStartByte - the offset, in bytes, from pmRowPtr to the  *
4098 8962              *                   beginning of the first PIXELWORD of the destination       *
4099 8962              *                   pixelmap into which character image pixels are to be      *
4100 8962              *                   transferred.  A pixelword is a collection of 16 contig-   *
4101 8962              *                   ous pixels, aligned to some starting point (in this case, *
4102 8962              *                   pmRowPtr).  pmStartByte will always be divisible by 4 in  *
4103 8962              *                   640 mode, 8 in 320.                                       *
4104 8962              *                                                                             *
4105 8962              *              (5)  numOfWords - the number of distinct words in each text    *
4106 8962              *                   buffer row which contain character image pixels which     *
4107 8962              *                   are to be transferred into the destination.  IMPORTANT    *
4108 8962              *                   NOTE:  this is a "0-based counter"; that is, a value of   *
4109 8962              *                   0 means 1 word to be transferred, 1 means 2 words, etc.   *
4110 8962              *                                                                             *
4111 8962              *              (6)  rowCounter - the number of rows to be transferred to the  *
4112 8962              *                   destination.  IMPORTANT NOTE:  this is also a 0-based     *
4113 8962              *                   counter.                                                  *
4114 8962              *                                                                             *
4115 8962              *******************************************************************************
4116 8962              ;
4117 8962              *****************************************
4118 8962              *                                       *
4119 8962              *  V.0.1.0 - 3/30/86                    *
4120 8962              *    4/15/86 - changed to allow cross-  *
4121 8962              *    bank boundaries - BHM              *
4122 8962              *                                       *
4123 8962              *****************************************
4124 8962              ;
4125 8962                       EXPORT iCalcTextBounds 
4126 8962              iCalcTextBounds PROC 
4127 8962              ;
4128 8962              ;rowCounter:
4129 8962 A5 04                 lda   minRect+O_V2             ;rect coordinate
4130 8964              ;bottom (and right) boundaries of enclosing rectangles are always 1 more than
4131 8964              ;the most extreme pixel they enclose, so to get pixel coordinate we decrement
4132 8964 3A                    dec   a                        ;(a lot of talk for a dumb DEC)
4133 8965 38                    sec   
4134 8966 E5 00                 sbc   minRect+O_V1
4135 8968 85 C8                 sta   rowCounter
4136 896A              ;
4137 896A              ;pmRowPtr:
4138 896A              ;we need multiples of pixelmap width to calculate pointer
4139 896A              ;
4140 896A F4 00 00 F4           pushlong #0 
4141 8970 D4 12                 pei   width                    ;pixelmap width in bytes
4142 8972 A5 00                 lda   minRect+O_V1             ;first row
4143 8974 38                    sec   
4144 8975 E5 14                 sbc   boundsRect+O_V1          ;shift to global coordinates
4145 8977 48                    pha   
4146 8978              ;
4147 8978 A2 0B 09 22           _Multiply 
4148 897F              ;
4149 897F 68                    pla                            ;result low word
4150 8980 85 2A                 sta   temp
4151 8982 68                    pla                            ;high word
4152 8983 85 2C                 sta   temp+2
4153 8985              ;
4154 8985 A5 0E                 lda   imageRef                 ;pointer to dest. start
4155 8987 18                    clc   
4156 8988 65 2A                 adc   temp
4157 898A 85 B6                 sta   pmRowPtr
4158 898C A5 10                 lda   imageRef+2
4159 898E 65 2C                 adc   temp+2
4160 8990 85 B8                 sta   pmRowPtr+2
4161 8992
4162 8992              ;
4163 8992              ;tbRowPtr:
4164 8992              ;similar to pmRowPtr, mutatis mutandis
4165 8992              ;
4166 8992 F4 00 00 F4           pushlong #0 
4167 8998 D4 C4                 pei   bufRowBytes
4168 899A A5 00                 lda   minRect+O_V1
4169 899C 38                    sec   
4170 899D E5 A2                 sbc   vBufToLoc                ;this gets us buffer coord.
4171 899F 3A                    dec   a                        ;dec, because buffer rows start at 1
4172 89A0 48                    pha   
4173 89A1              ;
4174 89A1 A2 0B 09 22           _Multiply 
4175 89A8              ;(in the future we may wish to replace these multiplies with in-line routines
4176 89A8              ;optimized for small second arguments.  In particular, this last one is
4177 89A8              ;usually 0 - whenever the top of the character fits in the destination
4178 89A8              ;pixelmap)
4179 89A8              ;
4180 89A8 68                    pla   
4181 89A9 85 2A                 sta   temp
4182 89AB 68                    pla   
4183 89AC 85 2C                 sta   temp+2
4184 89AE              ;
4185 89AE A5 AE                 lda   bufPtr
4186 89B0 18                    clc   
4187 89B1 65 2A                 adc   temp
4188 89B3 85 B2                 sta   tbRowPtr
4189 89B5 A5 B0                 lda   bufPtr+2
4190 89B7 65 2C                 adc   temp+2
4191 89B9 85 B4                 sta   tbRowPtr+2
4192 89BB              ;
4193 89BB              ;now hone in on the boundary words
4194 89BB              ;pmStartByte:
4195 89BB              ;
4196 89BB A5 02                 lda   minRect+O_H1             ;minRect.H1, in local
4197 89BD 38                    sec   
4198 89BE E5 16                 sbc   boundsRect+O_H1          ;change to global
4199 89C0              ;we now have pixel position
4200 89C0 4A                    lsr   a
4201 89C1              ;for 320, that LSR gets us from number of pixels to number of bytes
4202 89C1              ;(2 pixels/byte in 320) -  we'll need another for 640
4203 89C1 24 0B                 bit   portSCB-1
4204 89C3 30 05                 bmi   mode640
4205 89C5              ;mode320:
4206 89C5 29 F8 FF              and   #first13bits             ;round down to nearest multiple of 8
4207 89C8 80 04                 bra   GotPMSB
4208 89CA              mode640                                 ; 
4209 89CA 4A                    lsr   a
4210 89CB              ;pixel position now divided by 4 altogether to get number of bytes -
4211 89CB              ;(4 pixels/byte in 640)
4212 89CB 29 FC FF              and   #first14bits             ;round down to nearest multiple of 4
4213 89CE              ;
4214 89CE              GotPMSB                                 ; ;got pixelmap startbyte
4215 89CE 85 BC                 sta   pmStartByte
4216 89D0              ;
4217 89D0              ;tbStartByte:
4218 89D0 A5 02                 lda   minRect+O_H1             ;starting pixel, local
4219 89D2 38                    sec   
4220 89D3 E5 A0                 sbc   hBufToLoc                ;buffer coordinate thereof
4221 89D5 4A                    lsr   a
4222 89D6 4A                    lsr   a
4223 89D7 4A                    lsr   a
4224 89D8 4A                    lsr   a
4225 89D9 85 2A                 sta   temp                     ;this would be "tbStartWord"
4226 89DB 0A                    asl   a
4227 89DC              ;
4228 89DC 85 BA                 sta   tbStartByte
4229 89DE              ;
4230 89DE              ;numOfWords:
4231 89DE A5 06                 lda   minRect+O_H2             ;right rect boundary
4232 89E0 3A                    dec   a                        ;ending pixel, local
4233 89E1 38                    sec   
4234 89E2 E5 A0                 sbc   hBufToLoc                ;buffer coordinate
4235 89E4 4A                    lsr   a
4236 89E5 4A                    lsr   a
4237 89E6 4A                    lsr   a
4238 89E7 4A                    lsr   a
4239 89E8              ;this is "tbEndWord", but we just need it for a calculation
4240 89E8 38                    sec   
4241 89E9 E5 2A                 sbc   temp                     ;subtract "tbStartWord"
4242 89EB 85 C6                 sta   numOfWords
4243 89ED 6B                    rtl   
4244 89EE                       ENDP 
4245 89EE              *****************************************
4246 89EE              *                                       *
4247 89EE              *  end of CalcTextBounds                *
4248 89EE              *                                       *
4249 89EE              *****************************************
4250 89EE              ;
4251 89EE              ;                copy text/TextSubs4
4252 89EE              *****************************************
4253 89EE              *                                       *
4254 89EE              *  file TextSubs4                       *
4255 89EE              *    SetUpFontInfo                      *
4256 89EE              *    SetUpBufInfo                       *
4257 89EE              *                                       *
4258 89EE              *****************************************
4259 89EE              ;
4260 89EE              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
4261 89EE              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
4262 89EE              ;
4263 89EE              ;
4264 89EE              ;  This version of SetUpFontInfo goes into the 1.1 ROM
4265 89EE              ;
4266 89EE              *******************************************************************************
4267 89EE              *                                                                             *
4268 89EE              *              subroutine SetUpFontInfo                                       *
4269 89EE              *                                                                             *
4270 89EE              *                                       started 3/30/86 or before             *
4271 89EE              *                                       Bennet Marks x6245                    *
4272 89EE              *                                                                             *
4273 89EE              *  ABSTRACT:  this subroutine gets and/or calculates certain font-related     *
4274 89EE              *  information from the current font (the one whose handle is in the current  *
4275 89EE              *  grafport).If the current font is a fastfont, this routine uses the acc     *
4276 89EE              * on entry to determine which font info to set up. If you pass a zero, it     *
4277 89EE              * will pass you the realfont info, if you pass a -1 it will give you fastfont *
4278 89EE              * info on dpage.                                                              *
4279 89EE              *  ASSUMPTIONS:  only that portRef points to a valid grafport, and that the   *
4280 89EE              *  grafport's font field points to a valid font.                              *
4281 89EE              *                                                                             *
4282 89EE              *  RETURNS:                                                                   *
4283 89EE              *              (1)  4-byte pointers:                                          *
4284 89EE              *                                                                             *
4285 89EE              *              fontRecPtr - to the start of the font record                   *
4286 89EE              *              strikePtr - to the start of the font strike                    *
4287 89EE              *              owTPtr - to the start of the font offset/width table           *
4288 89EE              *              locTPtr - to the start of the font location table              *
4289 89EE              *              locTP2Ptr - 2 bytes into the location table (trust me, it's    *
4290 89EE              *              useful)                                                        *
4291 89EE              *                                                                             *
4292 89EE              *              (2)  2-byte values:                                            *
4293 89EE              *                                                                             *
4294 89EE              *              firstChar - ASCII code of the font's first defined character   *
4295 89EE              *              lastChar - ASCII code of the font's last defined character     *
4296 89EE              *              msCodeT2 - index value for the font's "missing symbol", given  *
4297 89EE              *              by:                                                            *
4298 89EE              *                       msCodeT2 = 2 * (lastChar + 1 - firstChar)             *
4299 89EE              *                                                                             *
4300 89EE              *              kernMax - the font's maximum leftward kern, represented as a   *
4301 89EE              *              negative number (or 0)                                         *
4302 89EE              *              chHeight - the font's character height                         *
4303 89EE              *              ascent - the font's ascent                                     *
4304 89EE              *              descent - the font's descent                                   *
4305 89EE              *              fbrExtent - (see external doc. for description)                *
4306 89EE              *              rowBytes - width of the font strike, in bytes - must be even   *
4307 89EE              *              (rowBytes = 2 * textRowWords)                                  *
4308 89EE              *                                                                             *
4309 89EE              *  NOTES:  DBR is preserved.                                                  *
4310 89EE              *                                                                             *
4311 89EE              *  SetUpFontInfo returns with an RTL.                                         *
4312 89EE              *                                                                             *
4313 89EE              *                                                                             *
4314 89EE              *  Change History:                                                            *
4315 89EE              *                                                                             *
4316 89EE              *  This version of SetUpFontInfo was modified on 2/6/87 for use in the 1.1    *
4317 89EE              *  ROM.  It has absorbed the patch replacing fRectMax with fbrExtent, and it  *
4318 89EE              *  includes the patch which calculates digitWidth.  It also no longer locks   *
4319 89EE              *  the font.                                                                  *
4320 89EE              *                                                                             *
4321 89EE              *  13 Oct 88        Sue Dumont                                                *
4322 89EE              *                                                                             *
4323 89EE              *  Version 1.02  -- Apple IIGS font header contains an additional field.  This*
4324 89EE              *  is highOwTLoc, the high word of the offset to the offset/width table.      *
4325 89EE              *                                                                             *
4326 89EE              *
4327 89EE              * 2/15/89           Mensch
4328 89EE              * 
4329 89EE              * Added fastfont info handling stuff...                                       *
4330 89EE              *******************************************************************************
4331 89EE              ;
4332 89EE              ***************************************
4333 89EE              *                                     *
4334 89EE              *  Mar. 10, 1987  11:30 am            *
4335 89EE              *                                     *
4336 89EE              ***************************************
4337 89EE              ;
4338 89EE                       EXPORT iSetUpFontInfo 
4339 89EE              iSetUpFontInfo PROC 
4340 89EE              ;
4341 89EE              *              USING Coredata
4342 89EE              *              using E0Vectors
4343 89EE
4344 89EE              ;
4345 89EE              ;(the two values aren't necessarily the same - we've just replaced the
4346 89EE              ;text routine's use of fRectMax with fbrExtent, which is a more useful
4347 89EE              ;measure.  Probably we should drop the 0-page location name fRectMax
4348 89EE              ;altogether.)
4349 89EE              ;
4350 89EE AA                    tax                            ; place flag in <X> for a second
4351 89EF 8B                    phb   
4352 89F0              ;
4353 89F0              ;THE FOLLOWING CHANGED FROM A CALL TO DEREFANDLOC - 2/7/87
4354 89F0              ;
4355 89F0              ; Modified 2/12/89 to load new info if the fastfont is being used... Mensch
4356 89F0              ;
4357 89F0              ; Modified 3/21/89  Mensch
4358 89F0              ; Added spExtra/charExtra and fontflags to this load...
4359 89F0
4360 89F0 A0 76 00              ldy   #(O_font+2)
4361 89F3 B7 24                 lda   [portRef],y              ;font handle high word
4362 89F5 30 03                 bmi   @FastFont
4363 89F7 82 AD 00              brl   standardFont             ; if high bit clear we are using a standard font;;;
4364 89FA              @FastFont  
4365 89FA E0 FF FF              cpx   #-1                      ; is it a negative 1???
4366 89FD D0 65                 bne   loadStdData              ; if not, load the standard data
4367 89FF 22 05 7F FE           jsl   MakeFastFontInfo         ; else load the good data
4368 8A03              FastSetupCont  
4369 8A03 A0 84 00              ldy   #O_spExtra
4370 8A06 B7 24                 lda   [portRef],y
4371 8A08 85 EC                 sta   spExtra
4372 8A0A C8                    iny   
4373 8A0B C8                    iny   
4374 8A0C B7 24                 lda   [portRef],y
4375 8A0E 85 EE                 sta   spExtra+2
4376 8A10
4377 8A10 A0 88 00              ldy   #O_chExtra
4378 8A13 B7 24                 lda   [portRef],y
4379 8A15 85 F0                 sta   chExtra
4380 8A17 C8                    iny   
4381 8A18 C8                    iny   
4382 8A19 B7 24                 lda   [portRef],y
4383 8A1B 85 F2                 sta   chExtra+2
4384 8A1D              ;
4385 8A1D A0 82 00              ldy   #o_txMode
4386 8A20 B7 24                 lda   [<portRef],y             ; combine mode and forcolor
4387 8A22 85 30                 sta   <FastMode
4388 8A24
4389 8A24 A0 7C 00              ldy   #O_fontFlags
4390 8A27 B7 24                 lda   [portRef],y
4391 8A29 29 03 00              and   #$0003
4392 8A2C 85 F6                 sta   fontFlags
4393 8A2E              ;
4394 8A2E 05 F0                 ora   chExtra                  ; now make sure spextra/fontflags and 
4395 8A30 05 F2                 ora   chExtra+2                ; char extra are zero
4396 8A32 05 EC                 ora   spExtra
4397 8A34 05 EE                 ora   SpExtra+2
4398 8A36 D0 07                 bne   @UseExtra
4399 8A38 A9 00 C0              lda   #$C000
4400 8A3B 85 F6                 sta   <FontFlags
4401 8A3D AB                    plb   
4402 8A3E 6B                    rtl   
4403 8A3F              @UseExtra  
4404 8A3F A5 F6                 lda   <fontflags
4405 8A41 D0 17                 bne   @cantuse                 ; damn we got monospacing bullshit
4406 8A43              ; now test chExtra too see if it is too large (it can't be >= $10000)
4407 8A43 A5 F2                 lda   chExtra+2
4408 8A45 D0 13                 bne   @cantuse
4409 8A47              ; now test to see if spExtra is set, if so see if too large (it can't be >=$40000)
4410 8A47 A5 EE                 lda   spExtra+2
4411 8A49 C9 04 00              cmp   #4
4412 8A4C B0 0C                 bge   @cantUse
4413 8A4E              ; otherwise, just go ahead and use it...
4414 8A4E A9 00 40              lda   #$4000
4415 8A51 85 F6                 sta   <fontFlags
4416 8A53 A9 00 80              lda   #half
4417 8A56 85 E8                 sta   fastbucket               ; fastfonts use a different bucket than slowfonts
4418 8A58              ;
4419 8A58 AB                    plb                            ; suck off the data bank
4420 8A59 6B                    rtl                            ; and just return...
4421 8A5A              ;
4422 8A5A              ; 4/24/89 Mensch
4423 8A5A              ; If we get to this point the port ref can contain either a fastfont handle or a
4424 8A5A              ; standard font handle. If its the fast font handle we must deref a few levels,
4425 8A5A              ; if not we should just rejoin the standard code as it was.
4426 8A5A              @cantuse  
4427 8A5A A0 76 00              ldy   #(O_font+2)
4428 8A5D B7 24                 lda   [portRef],y              ;font handle high word
4429 8A5F 30 03                 bmi   LoadStdData              ; we have an actual fastfont in the port
4430 8A61 82 5B 00              brl   SF0005                   ; else, just finish setting up the slow way0
4431 8A64              o_FFOldFont equ   $0100
4432 8A64              loadStdData  
4433 8A64 85 2C                 sta   temp+2                   ; get the handle to the fastfont stuff
4434 8A66 A0 74 00              ldy   #o_font
4435 8A69 B7 24                 lda   [portRef],y
4436 8A6B 85 2A                 sta   temp
4437 8A6D A7 2A                 lda   [temp]                   ; and deref it...
4438 8A6F 85 70                 sta   fontHeadPtr
4439 8A71 A0 02 00              ldy   #2
4440 8A74 B7 2A                 lda   [temp],y
4441 8A76 85 72                 sta   fontHeadPtr+2
4442 8A78              ;
4443 8A78 A0 0A 00              ldy   #o_oldFontHandle         ; offset to the old font..
4444 8A7B B7 70                 lda   [fontHeadPtr],y          ; get the old font handle
4445 8A7D 85 2A                 sta   temp
4446 8A7F A0 0C 00              ldy   #o_oldFontHandle+2
4447 8A82 B7 70                 lda   [fontHeadPtr],y
4448 8A84 85 2C                 sta   temp+2                   ; set temp to be the old font handle
4449 8A86 80 3F                 bra   SF0010                   ; and branch into standard font stuff
4450 8A88              ShowFastROMFont  
4451 8A88 A2 00 02              ldx   #512                     ; get the fast ROM font off dpage
4452 8A8B B5 F0                 lda   <FastRomFont,x           ; see if fast ROMFont exists
4453 8A8D 15 F2                 ora   <FastRomFont+2,x
4454 8A8F D0 07                 bne   SFRF0005
4455 8A91 A0 76 00              ldy   #o_Font+2
4456 8A94 B7 24                 lda   [<portRef],y
4457 8A96 80 27                 bra   SF0005                   ; call back the standard stuff now...
4458 8A98              SFRF0005  
4459 8A98              ;	brk	00
4460 8A98 B5 F0                 lda   <FastRomFont,x           ; copy the fast font handle to zpage
4461 8A9A 85 70                 sta   <FastHeadPtr
4462 8A9C B5 F2                 lda   <FastRomFont+2,x
4463 8A9E 85 72                 sta   <FastHeadPtr+2
4464 8AA0 22 12 7F FE           jsl   MakeFastFontInfo2        ; else load the good data
4465 8AA4 82 5C FF              brl   FastSetupCont            ; and finish the setup...
4466 8AA7
4467 8AA7              standardFont  
4468 8AA7              ;
4469 8AA7              ; 3/21/89           Mensch
4470 8AA7              ; Changed for invisiblefastfont. This will test to see if we are using the systemfont now, if
4471 8AA7              ; we are it will use the fastfont instead
4472 8AA7 E0 FF FF              cpx   #-1                      ; see if we want the fast font even...
4473 8AAA D0 13                 bne   SF0005                   ; if not, load the standard data
4474 8AAC C9 FC 00              cmp   #^SystemFont
4475 8AAF D0 0E                 bne   SF0005                   ; if not the ROM font then forget it
4476 8AB1 85 2C                 sta   temp+2                   ; save this for a sec...
4477 8AB3 88                    dey   
4478 8AB4 88                    dey   
4479 8AB5 B7 24                 lda   [portRef],y
4480 8AB7 C9 1B DD              cmp   #SystemFont
4481 8ABA D0 09                 bne   SF0006                   ; if these are both not equal then not ROM font
4482 8ABC              ; else, show the fastromfont now!
4483 8ABC 82 C9 FF              brl   ShowFastRomFont          ; else load the fast rom font stuff...
4484 8ABF              SF0005    
4485 8ABF 85 2C                 sta   temp+2
4486 8AC1 88                    dey   
4487 8AC2 88                    dey   
4488 8AC3 B7 24                 lda   [portRef],y
4489 8AC5 85 2A        SF0006   sta   temp
4490 8AC7              ;
4491 8AC7              SF0010    
4492 8AC7 A7 2A                 lda   [temp]
4493 8AC9 85 70                 sta   fontHeadPtr
4494 8ACB A0 02 00              ldy   #2
4495 8ACE B7 2A                 lda   [temp],y
4496 8AD0 85 72                 sta   fontHeadPtr+2
4497 8AD2              ;
4498 8AD2              ;END OF CHANGE - BHM  x6245
4499 8AD2              ;
4500 8AD2 A7 70                 lda   [fontHeadPtr]
4501 8AD4 0A                    asl   a
4502 8AD5 18                    clc   
4503 8AD6 65 70                 adc   fontHeadPtr
4504 8AD8 85 74                 sta   fontRecPtr
4505 8ADA A5 72                 lda   fontHeadPtr+2
4506 8ADC 90 01                 bcc   @NoCarry
4507 8ADE 1A                    inc   a
4508 8ADF
4509 8ADF 85 76        @NoCarry sta   fontRecPtr+2
4510 8AE1              ;
4511 8AE1              ;the next 2 are first guesses, to be modified by arithmetic further down
4512 8AE1              ;
4513 8AE1 85 7A                 sta   strikePtr+2
4514 8AE3 85 82                 sta   owTPtr+2
4515 8AE5              ;
4516 8AE5 D4 71                 pei   fontHeadPtr+1            ; set dbr to access font
4517 8AE7 AB                    plb   
4518 8AE8 AB                    plb   
4519 8AE9              ;
4520 8AE9 A6 74                 ldx   fontRecPtr
4521 8AEB              ;
4522 8AEB BD 02 00              lda   |FMinChar,x
4523 8AEE                       MacSwitch 
4524 8AEE 85 88                 sta   firstChar
4525 8AF0              ;
4526 8AF0 BD 04 00              lda   |FMaxChar,x
4527 8AF3                       MacSwitch 
4528 8AF3 85 8A                 sta   lastChar
4529 8AF5              ;
4530 8AF5 1A                    inc   a
4531 8AF6 38                    sec   
4532 8AF7 E5 88                 sbc   firstChar
4533 8AF9 0A                    asl   a
4534 8AFA 85 8E                 sta   msCodeT2
4535 8AFC              ;
4536 8AFC BD 06 00              lda   |FMaxWd,x
4537 8AFF                       MacSwitch 
4538 8AFF 85 E0                 sta   widMax
4539 8B01              ;
4540 8B01 BD 08 00              lda   |FBBOX,x
4541 8B04                       MacSwitch 
4542 8B04 85 8C                 sta   kernMax
4543 8B06              ;
4544 8B06              ;FETCHING OF FRECTMAX DROPPED HERE - 2/7/87, BHM  x6245
4545 8B06              ;
4546 8B06              ;CALCULATION OF FBREXTENT MOVED HERE WHEN WE DISCOVERED THAT THERE
4547 8B06              ;WERE 1.0 FONTS OTHER THAN THE ORIGINAL ROM FONT (namely, Dan's
4548 8B06              ;controls font) - 3/10/87, BHM
4549 8B06              ;
4550 8B06 A9 00 01              lda   #V0100                   ;version 1.0
4551 8B09 A0 08 00              ldy   #o_Version
4552 8B0C D7 70                 cmp   [fontHeadPtr],y          ;actual version
4553 8B0E 10 09                 bpl   ItsVersion1              ;or less (if there were any such)
4554 8B10              ;version > 1.0
4555 8B10 A0 0A 00              ldy   #o_FBRExtent
4556 8B13 B7 70                 lda   [fontHeadPtr],y
4557 8B15 85 9E                 sta   fbrExtent
4558 8B17 80 11                 bra   GotFBRX
4559 8B19              ;
4560 8B19              ItsVersion1                             ; 
4561 8B19              ;need a reasonable guess for fbrExtent:
4562 8B19 A0 06 00              ldy   #FmaxWd
4563 8B1C B7 74                 lda   [fontRecPtr],y
4564 8B1E A0 0C 00              ldy   #FBBDX
4565 8B21 D7 74                 cmp   [fontRecPtr],y           ;fRectMax
4566 8B23 10 02                 bpl   MaxWdBigger
4567 8B25              ;fRectMax bigger - use it instead:
4568 8B25 B7 74                 lda   [fontRecPtr],y
4569 8B27              MaxWdBigger                             ; 
4570 8B27 18                    clc   
4571 8B28 65 8C                 adc   kernMax                  ;add kernMax to the soup
4572 8B2A              ;
4573 8B2A              GotFBRX                                 ; ;stir later
4574 8B2A 85 9E                 sta   fbrExtent
4575 8B2C              ;
4576 8B2C              ;END OF CALCULATION OF FBREXTENT
4577 8B2C              ;
4578 8B2C              **********************************************************************
4579 8B2C              * Version 1.02 - SMD      13 Oct 88
4580 8B2C              *
4581 8B2C              *                the following is highOwTLoc, the high word of 
4582 8B2C              *                the offset to the offset/width table.
4583 8B2C              *
4584 8B2C              *
4585 8B2C              * 30 Oct 88	Steven Glass
4586 8B2C              *
4587 8B2C              * (Moved Version102 variable from in line to direct page.)
4588 8B2C              **********************************************************************
4589 8B2C
4590 8B2C A0 08 00              ldy   #o_Version               ;check the version number
4591 8B2F B7 70                 lda   [fontHeadPtr],y
4592 8B31 C9 05 01              cmp   #V0102
4593 8B34 10 04                 bpl   Vers102
4594 8B36 64 FA                 stz   Version102               ;version less than 1.02
4595 8B38 80 0C                 bra   GetHeight
4596 8B3A
4597 8B3A A9 01 00     Vers102  lda   #1                       ;Version 1.02 or greater
4598 8B3D 85 FA                 sta   Version102
4599 8B3F A0 0C 00              ldy   #12
4600 8B42 B7 70                 lda   [fontHeadPtr],y
4601 8B44 85 82                 sta   owTPtr+2                 ;for now, keep #words in highOwTLoc here
4602 8B46
4603 8B46 BD 0E 00     GetHeight lda   |FBBDY,x
4604 8B49                       MacSwitch 
4605 8B49 85 CA                 sta   chHeight
4606 8B4B              ;
4607 8B4B BD 12 00              lda   |FAscent,x
4608 8B4E                       MacSwitch 
4609 8B4E 85 84                 sta   ascent
4610 8B50              ;
4611 8B50 BD 14 00              lda   |FDescent,x
4612 8B53                       MacSwitch 
4613 8B53 85 E2                 sta   descent
4614 8B55              ;
4615 8B55 BD 16 00              lda   |FLeading,x
4616 8B58                       MacSwitch 
4617 8B58 85 E4                 sta   leading
4618 8B5A              ;
4619 8B5A BD 10 00              lda   |FLength,x               ;owTLoc in WORDS
4620 8B5D                       MacSwitch 
4621 8B5D 0A                    asl   a                        ;now in BYTES
4622 8B5E 85 2A                 sta   temp
4623 8B60 A5 FA                 lda   Version102               ;check if version
4624 8B62 F0 08                 beq   NotV102
4625 8B64 A5 82                 lda   owTPtr+2
4626 8B66 2A                    rol   a
4627 8B67 18                    clc   
4628 8B68 65 76                 adc   fontRecPtr+2
4629 8B6A 85 82                 sta   owTPtr+2
4630 8B6C
4631 8B6C A5 2A        NotV102  lda   temp
4632 8B6E 18                    clc   
4633 8B6F 69 10 00              adc   #FLength
4634 8B72 90 02                 bcc   NoCarry1
4635 8B74 E6 82                 inc   owTPtr+2
4636 8B76              NoCarry1                                ; 
4637 8B76 18                    clc   
4638 8B77 65 74                 adc   fontRecPtr
4639 8B79 90 02                 bcc   NoCarry2
4640 8B7B E6 82                 inc   owTPtr+2
4641 8B7D              NoCarry2                                ; 
4642 8B7D 85 80                 sta   owTPtr
4643 8B7F              ;
4644 8B7F              ;now calculate loc table pointers from whatever's handy:
4645 8B7F A5 82                 lda   owTPtr+2
4646 8B81 85 7E                 sta   locTPtr+2
4647 8B83 A5 8E                 lda   msCodeT2
4648 8B85 18                    clc   
4649 8B86 69 04 00              adc   #4
4650 8B89 85 2A                 sta   temp
4651 8B8B A5 80                 lda   owTPtr
4652 8B8D 38                    sec   
4653 8B8E E5 2A                 sbc   temp
4654 8B90 85 7C                 sta   locTPtr
4655 8B92 B0 02                 bcs   NoBorrow
4656 8B94 C6 7E                 dec   locTPtr+2
4657 8B96              NoBorrow                                ; 
4658 8B96 A9 1A 00              lda   #FStrike
4659 8B99 18                    clc   
4660 8B9A 65 74                 adc   fontRecPtr
4661 8B9C 85 78                 sta   strikePtr
4662 8B9E 90 02                 bcc   NoCarry3
4663 8BA0 E6 7A                 inc   strikePtr+2
4664 8BA2              NoCarry3                                ; 
4665 8BA2              ;
4666 8BA2 BD 18 00              lda   |FRaster,x               ;width of strike in words
4667 8BA5                       MacSwitch 
4668 8BA5 0A                    asl   a                        ;now bytes
4669 8BA6 85 86                 sta   rowBytes
4670 8BA8              ;
4671 8BA8 A0 04 00              ldy   #O_fontStyle
4672 8BAB B7 70                 lda   [fontHeadPtr],y
4673 8BAD 49 FF FF              eor   #allBitsOn
4674 8BB0 A0 80 00              ldy   #O_txFace
4675 8BB3 37 24                 and   [portRef],y
4676 8BB5 85 E6                 sta   txFace
4677 8BB7              ;
4678 8BB7 64 F4                 stz   extra
4679 8BB9 89 01 00              bit   #boldBit
4680 8BBC F0 02                 beq   NotBold
4681 8BBE E6 F4                 inc   extra
4682 8BC0              NotBold                                 ; 
4683 8BC0              ;
4684 8BC0 A0 84 00              ldy   #O_spExtra
4685 8BC3 B7 24                 lda   [portRef],y
4686 8BC5 85 EC                 sta   spExtra
4687 8BC7 C8                    iny   
4688 8BC8 C8                    iny   
4689 8BC9 B7 24                 lda   [portRef],y
4690 8BCB 85 EE                 sta   spExtra+2
4691 8BCD              ;
4692 8BCD A0 88 00              ldy   #O_chExtra
4693 8BD0 B7 24                 lda   [portRef],y
4694 8BD2 85 F0                 sta   chExtra
4695 8BD4 C8                    iny   
4696 8BD5 C8                    iny   
4697 8BD6 B7 24                 lda   [portRef],y
4698 8BD8 85 F2                 sta   chExtra+2
4699 8BDA              ;
4700 8BDA A0 7C 00              ldy   #O_fontFlags
4701 8BDD B7 24                 lda   [portRef],y
4702 8BDF 85 F6                 sta   fontFlags
4703 8BE1              ;
4704 8BE1 A9 00 80              lda   #half
4705 8BE4 85 94                 sta   bucket
4706 8BE6              ;
4707 8BE6              ;ADDED 2/6/87:
4708 8BE6              ;
4709 8BE6 A5 F6                 lda   fontFlags
4710 8BE8 29 02 00              and   #numWdthBit
4711 8BEB F0 0C                 beq   NotNumWidth              ;so don't calculate digitWidth
4712 8BED              ;calculate digitWidth:
4713 8BED A9 30 00              lda   #asciiZero
4714 8BF0 22 E8 1F E0           jsl   GetCharVals              ;get o/w value of digit 0
4715 8BF4 29 FF 00              and   #lowByte                 ;isolate width
4716 8BF7 85 F8                 sta   digitWidth
4717 8BF9              ;
4718 8BF9              NotNumWidth                             ; 
4719 8BF9              ;
4720 8BF9              ;END OF ADDITION - BHM  x6245
4721 8BF9              ;
4722 8BF9 AB                    plb   
4723 8BFA 6B                    rtl   
4724 8BFB
4725 8BFB
4726 8BFB                       ENDP 
4727 8BFB              *****************************************
4728 8BFB              *                                       *
4729 8BFB              *  end of SetUpFontInfo                 *
4730 8BFB              *                                       *
4731 8BFB              *****************************************
4732 8BFB
4733 8BFB
4734 8BFB
4735 8BFB              ;
4736 8BFB              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
4737 8BFB              ;
4738 8BFB              *****************************************
4739 8BFB              *                                       *
4740 8BFB              *  current date and time:               *
4741 8BFB              *    2:30 PM, 4/23/86                   *
4742 8BFB              *                                       *
4743 8BFB              *****************************************
4744 8BFB              ;
4745 8BFB              ;
4746 8BFB              *******************************************************************************
4747 8BFB              *                                                                             *
4748 8BFB              *              subroutine SetUpBufInfo                                        *
4749 8BFB              *                                                                             *
4750 8BFB              *                                       started 3/30/86                       *
4751 8BFB              *                                       Bennet Marks x6245                    *
4752 8BFB              *                                                                             *
4753 8BFB              *  ABSTRACT:  this subroutine gets and/or calculates certain information      *
4754 8BFB              *  regarding the text buffer to be used by QD II text-drawing routines.       *
4755 8BFB              *                                                                             *
4756 8BFB              *  ASSUMPTIONS:                                                               *
4757 8BFB              *              (1)  textBufHandle, textBufRowWords, and textBufHeight on      *
4758 8BFB              *              0-page                                                         *
4759 8BFB              *              (2)  the usual 0-page grafport information, including portRef  *
4760 8BFB              *              and boundsRect                                                 *
4761 8BFB              *              (3)  SetUpFontInfo has been called (we need fRectMax)          *
4762 8BFB              *              (4)  currPen has been set.  This is the horizontal pen posi-   *
4763 8BFB              *              tion in the destination pixelmap where character drawing is to *
4764 8BFB              *              start, expressed in local coordinates (you can think of it as  *
4765 8BFB              *              the "current pen position", except that it may have been ad-   *
4766 8BFB              *              justed to account for characters in a string that would, in    *
4767 8BFB              *              drawing, fall to the left of the current visible region).      *
4768 8BFB              *                                                                             *
4769 8BFB              *  RETURNS:                                                                   *
4770 8BFB              *              (1)  4-byte pointers:                                          *
4771 8BFB              *              bufPtr - to the start of the text buffer                       *
4772 8BFB              *                                                                             *
4773 8BFB              *              (2)  2-byte values:                                            *
4774 8BFB              *              bufRowBytes - buffer width in bytes; must be even              *
4775 8BFB              *              (bufRowBytes = 2 * textBufRowWords)                            *
4776 8BFB              *              hBufToLoc - horizontal translation value from buffer coord-    *
4777 8BFB              *              inates to local coordinates                                    *
4778 8BFB              *              vBufToLoc - vertical translation from buffer to local          *
4779 8BFB              *              startBufPen - a good starting pixel position (horizontal) in   *
4780 8BFB              *              the text buffer for the transfer of character images from the  *
4781 8BFB              *              font strike.  "Good", here, subsumes the following properties: *
4782 8BFB              *                                                                             *
4783 8BFB              *              (a)  startBufPen has the same pixel-in-word alignment (i.e.,   *
4784 8BFB              *              has the same last 4 bits) as the destination pen expressed in  *
4785 8BFB              *              GLOBAL coordinates (that is, currPen transformed from local    *
4786 8BFB              *              to global).  This insures that BlowItUp (the buffer-to-destin- *
4787 8BFB              *              ation transfer subroutine) won't have to rotate buffer image   *
4788 8BFB              *              words for use in the destination.                              *
4789 8BFB              *              [yeah, I know that's verbose, but I didn't understand the      *
4790 8BFB              *              the idea myself for the LONGEST time, so I'm showing off]      *
4791 8BFB              *                                                                             *
4792 8BFB              *              (b)  startBufPen is large enough (i.e., the "buffer pen"       *
4793 8BFB              *              starts far enough into the buffer) that neither kerning nor    *
4794 8BFB              *              the vagaries of PutChar (the strike-to-buffer transfer rou-    *
4795 8BFB              *              tine) will involve memory words outside the text buffer.       *
4796 8BFB              *                                                                             *
4797 8BFB              *              bufPen - a copy of startBufPen.  bufPen will be updated by     *
4798 8BFB              *              calls to PutChar; startBufPen will be left alone.  Both values *
4799 8BFB              *              are needed later.                                              *
4800 8BFB              *                                                                             *
4801 8BFB              *  NOTES:  both textBufRowWords and textBufHeight are 1-based counters [check *
4802 8BFB              *  this].                                                                     *
4803 8BFB              *                                                                             *
4804 8BFB              *  SetUpBufInfo does NOT clear the buffer; ClearBufPart is used for that.     *
4805 8BFB              *                                                                             *
4806 8BFB              *  The "safety margins" built into this subroutine and SizeTextBuffer do not  *
4807 8BFB              *  take into account spExtra, charExtra, style mods, etc.; they may have to   *
4808 8BFB              *  be changed when those features are implemented.                            *
4809 8BFB              *                                                                             *
4810 8BFB              *                                                                             *
4811 8BFB              *  SetUpBufInfo returns with an RTL.                                          *
4812 8BFB              *                                                                             *
4813 8BFB              *******************************************************************************
4814 8BFB              ;
4815 8BFB              *****************************************
4816 8BFB              *                                       *
4817 8BFB              *  V.0.1.0 - 3/31/86                    *
4818 8BFB              *                                       *
4819 8BFB              *****************************************
4820 8BFB              ;
4821 8BFB                       EXPORT iSetUpBufInfo 
4822 8BFB              iSetUpBufInfo PROC 
4823 8BFB              ;
4824 8BFB              *              USING Coredata
4825 8BFB              ;
4826 8BFB A6 46                 ldx   textBufHandle+2
4827 8BFD A5 44                 lda   textBufHandle            ;handle to buffer
4828 8BFF 20 BD 85              jsr   TextDeref                ;now pointer to locked buffer
4829 8C02 86 B0                 stx   bufPtr+2
4830 8C04 85 AE                 sta   bufPtr
4831 8C06              ;
4832 8C06 A5 48                 lda   textBufRowWords
4833 8C08 0A                    asl   a
4834 8C09 85 C4                 sta   bufRowBytes
4835 8C0B              ;
4836 8C0B              ;we want to align buffer pen position (horizontal) and destination pixelmap
4837 8C0B              ;position (horizontal, and in GLOBAL coordinates) with respect to pixel
4838 8C0B              ;position within pixelmap -
4839 8C0B              ;get destination pixelmap horizontal pen position, in local:
4840 8C0B A5 AC                 lda   currPen
4841 8C0D              ;switch to global:
4842 8C0D 38                    sec   
4843 8C0E E5 16                 sbc   boundsRect+O_H1
4844 8C10              ;
4845 8C10 29 0F 00              and   #last4Bits               ;pixel position within pixelword
4846 8C13 85 2A                 sta   temp
4847 8C15              ;
4848 8C15              ****  SUBROUTINE CHANGED 3/10/87
4849 8C15              ;
4850 8C15              ;  The calculation of "fontSlop" (the current fbrExtent, including style
4851 8C15              ;  mods et al) has been pushed off to the new subroutine CalcSlop, which
4852 8C15              ;  is called before SetUpBufInfo, and which hides the slop on the third
4853 8C15              ;  0-page for SetUpBufInfo to find.
4854 8C15              ;
4855 8C15              ;so go fetch:
4856 8C15 A2 00 02              ldx   #512
4857 8C18 B5 00                 lda   fontSlop,x
4858 8C1A              ;
4859 8C1A              ****  END OF THAT CHANGE - BHM  x6245
4860 8C1A              ;
4861 8C1A 18                    clc   
4862 8C1B 69 20 00              adc   #$0020                   ;for round-off and algorithm
4863 8C1E              ;
4864 8C1E 29 F0 FF              and   #first12Bits             ;occasion of possible round-off error
4865 8C21 05 2A                 ora   temp                     ;align buffer pen to dest. pen
4866 8C23 85 92                 sta   startBufPen
4867 8C25 85 90                 sta   bufPen
4868 8C27              ;
4869 8C27              ;get some translation values:
4870 8C27              ;
4871 8C27 A5 AC                 lda   currPen                  ;pnLoc.H
4872 8C29 38                    sec   
4873 8C2A E5 92                 sbc   startBufPen
4874 8C2C 85 A0                 sta   hBufToLoc                ;horizontal translation from buffer
4875 8C2E              ;                                       ;coordinates to local coordinates
4876 8C2E A0 40 00              ldy   #(O_pnLoc+O_V)
4877 8C31 B7 24                 lda   [portRef],y              ;pnLoc.V
4878 8C33 38                    sec   
4879 8C34 E5 84                 sbc   ascent
4880 8C36              ;HERE IT COMES AGAIN
4881 8C36 3A                    dec   a
4882 8C37              ;DID YOU BLINK?
4883 8C37 85 A2                 sta   vBufToLoc                ;vertical translation
4884 8C39              ;
4885 8C39              ;
4886 8C39              ;the following assignments may seem backwards, but they guarantee valid
4887 8C39              ;leftExtent and rightExtent as soon as a pixel is put down, as well as
4888 8C39              ;enabling us to check easily on a null image (no pixels put down) condition.
4889 8C39              ;
4890 8C39 A9 FF 3F              lda   #maxInt
4891 8C3C 85 CE                 sta   leftExtent
4892 8C3E A9 01 C0              lda   #(-maxInt)
4893 8C41 85 D0                 sta   rightExtent
4894 8C43              ;
4895 8C43 6B                    rtl   
4896 8C44                       ENDP 
4897 8C44              *****************************************
4898 8C44              *                                       *
4899 8C44              *  end of SetUpBufInfo                  *
4900 8C44              *                                       *
4901 8C44              *****************************************
4902 8C44              ;
4903 8C44              ;                copy text/TextSubs5
4904 8C44              *****************************************
4905 8C44              *                                       *
4906 8C44              *  file TextSubs5                       *
4907 8C44              *    SizeTextBuffer                     *
4908 8C44              *    GetTextHandle                      *
4909 8C44              *                                       *
4910 8C44              *****************************************
4911 8C44              ;
4912 8C44              ;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
4913 8C44              ;
4914 8C44              *****************************************
4915 8C44              *                                       *
4916 8C44              *  current date and time:               *
4917 8C44              *    5:00 PM, 4/1/86                    *
4918 8C44              *                                       *
4919 8C44              *****************************************
4920 8C44              ;
4921 8C44              *******************************************************************************
4922 8C44              *                                                                             *
4923 8C44              *              subroutine GetTextHandle                                       *
4924 8C44              *                                                                             *
4925 8C44              *                                       started 4/1/86 or before              *
4926 8C44              *                                       Bennet Marks  x6245                   *
4927 8C44              *                                                                             *
4928 8C44              *  ABSTRACT:  this subroutine allocates a block of space for the QD II text   *
4929 8C44              *  buffer, and places a handle to this block in the 0-page global location    *
4930 8C44              *  textBufHandle.  The buffer block itself is set to some nominal amount of   *
4931 8C44              *  space, and is in this form basically useless; proper sizing (and clearing) *
4932 8C44              *  of the buffer is done later by the subroutine SizeTextBuffer.              *
4933 8C44              *                                                                             *
4934 8C44              *  GetTextHandle should be called when QD II is initialized, and must be      *
4935 8C44              *  called before any call to SizeTextBuffer, which expects to find a valid,   *
4936 8C44              *  if puny, textBufHandle.                                                    *
4937 8C44              *                                                                             *
4938 8C44              *  ASSUMPTIONS:  only that the memory manager is active.                      *
4939 8C44              *                                                                             *
4940 8C44              *  RETURNS:  if the call to the memory manager returns no error, this sub-    *
4941 8C44              *  routine sets textBufHandle and clears the carry bit.  If there was a mem-  *
4942 8C44              *  ory manager error, then the carry is set and the error code passed back    *
4943 8C44              *  unchanged in the acc.  (in that case, textBufHandle will not be set).      *
4944 8C44              *  The only expected error is MFullErr (memory full error).                   *
4945 8C44              *                                                                             *
4946 8C44              *  NOTES:  currently GetTextHandle insists that the text buffer be entirely   *
4947 8C44              *  in one bank.  This will probably be relaxed later.                         *
4948 8C44              *                                                                             *
4949 8C44              *  GetTextHandle returns with an RTL.                                         *
4950 8C44              *                                                                             *
4951 8C44              *******************************************************************************
4952 8C44              ;
4953 8C44              *****************************************
4954 8C44              *                                       *
4955 8C44              *  V.0.1.0 - 4/1/86                     *
4956 8C44              *    changed to permit buffer to        *
4957 8C44              *    stradle bank boundaries -          *
4958 8C44              *    BHM, 4/21/86                       *
4959 8C44              *                                       *
4960 8C44              *****************************************
4961 8C44              ;
4962 8C44                       EXPORT iGetTextHandle 
4963 8C44              iGetTextHandle PROC 
4964 8C44              ;
4965 8C44 F4 00 00 F4           pushlong #0                    ;for result
4966 8C4A F4 00 00 F4           pushlong #15                   ;a token amount
4967 8C50 A5 0A                 lda   UserID
4968 8C52 48                    pha   
4969 8C53 F4 00 00              pea   0
4970 8C56 F4 00 00 F4           pushlong #0                    ;I assume this is not used
4971 8C5C              ;
4972 8C5C A2 02 09 22           _NewHandle 
4973 8C63 90 03                 bcc   NoMemError
4974 8C65              ;memory error:
4975 8C65 FA                    plx   
4976 8C66 FA                    plx                            ;clear stack
4977 8C67              ;note carry set and error code in acc. still
4978 8C67 6B                    rtl                            ;so just return
4979 8C68              ;
4980 8C68              ;
4981 8C68              NoMemError                              ; 
4982 8C68 68                    pla   
4983 8C69 85 44                 sta   textBufHandle
4984 8C6B 68                    pla   
4985 8C6C 85 46                 sta   textBufHandle+2
4986 8C6E              ;note carry clear still
4987 8C6E A9 00 00              lda   #0                       ;so clear acc.
4988 8C71 6B                    rtl                            ;and just return
4989 8C72                       ENDP 
4990 8C72              *****************************************
4991 8C72              *                                       *
4992 8C72              *  end of GetTextHandle                 *
4993 8C72              *                                       *
4994 8C72              *****************************************
4995 8C72              ;
4996 8C72              ;                copy text/TextSubs6
4997 8C72              *****************************************
4998 8C72              *                                       *
4999 8C72              *  file TextSubs6                       *
5000 8C72              *    ClearBufPart                       *
5001 8C72              *    CleanUpBuffer                      *
5002 8C72              *                                       *
5003 8C72              *****************************************
5004 8C72              ;
5005 8C72              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
5006 8C72              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
5007 8C72              ;
5008 8C72              *****************************************
5009 8C72              *                                       *
5010 8C72              *  current date and time:               *
5011 8C72              *    4:45 PM, 5/9/86                    *
5012 8C72              *                                       *
5013 8C72              *****************************************
5014 8C72              ;
5015 8C72              *******************************************************************************
5016 8C72              *                                                                             *
5017 8C72              *              subroutine ClearBufPart                                        *
5018 8C72              *                                                                             *
5019 8C72              *                                       started 3/31/86 or before             *
5020 8C72              *                                       Bennet Marks x6245                    *
5021 8C72              *                                                                             *
5022 8C72              *  ABSTRACT:  this subroutine zeros out every word of the text buffer from    *
5023 8C72              *  leftExtent to rightExtent, along every row (from 1 to textBufHeight).      *
5024 8C72              *  Note that leftExtent = 0 refers to the first word in a row, but that the   *
5025 8C72              *  rows themselves are counted starting from 1.  To clear the entire buffer,  *
5026 8C72              *  set leftExtent = 0 and rightExtent = bufRowWords - 1.                      *
5027 8C72              *                                                                             *
5028 8C72              *  ASSUMPTIONS:  textBufHeight (usually set by SizeTextBuffer) and bufPtr     *
5029 8C72              *  and bufRowBytes (both usually set by SetUpBufInfo) are on 0-page.          *
5030 8C72              *  leftExtent and rightExtent are defined, and measured in words.             *
5031 8C72              *                                                                             *
5032 8C72              *  ALTERS:  ClearBufPart uses numOfWords, currBufByte, bufByte, wordCounter,  *
5033 8C72              *  and rowCounter for bookkeeping.                                            *
5034 8C72              *                                                                             *
5035 8C72              *  NOTES:  throughout most of the QD II text routines, leftExtent and         *
5036 8C72              *  rightExtent are measured in PIXELS.  They are initialized by SetUpBufInfo, *
5037 8C72              *  altered by PutChar, and used to get text boundaries.  Before they are      *
5038 8C72              *  used here, they must be "boiled down" to words (i.e., divided by 4 and     *
5039 8C72              *  rounded down).                                                             *
5040 8C72              *                                                                             *
5041 8C72              *  DBR is preserved.                                                          *
5042 8C72              *                                                                             *
5043 8C72              *  ClearBufPart returns with an RTL.                                          *
5044 8C72              *                                                                             *
5045 8C72              *******************************************************************************
5046 8C72              ;
5047 8C72              *****************************************
5048 8C72              *                                       *
5049 8C72              *  V.0.1.0 - 3/31/86                    *
5050 8C72              *    changed to handle bank boundaries; *
5051 8C72              *    doc. not up to date yet - BHM,     *
5052 8C72              *    4/21/86                            *
5053 8C72              *                                       *
5054 8C72              *    changed to use chHeight in place   *
5055 8C72              *    textBufHeight - doc. STILL not up  *
5056 8C72              *    to date - BHM, 5/9/86              *
5057 8C72              *                                       *
5058 8C72              *****************************************
5059 8C72              ;
5060 8C72                       EXPORT iClearBufPart 
5061 8C72              iClearBufPart PROC 
5062 8C72 8B                    phb   
5063 8C73              ;
5064 8C73 A5 CE                 lda   leftExtent               ;words
5065 8C75 0A                    asl   a                        ;now bytes
5066 8C76 85 2A                 sta   temp
5067 8C78 18                    clc   
5068 8C79 65 AE                 adc   bufPtr
5069 8C7B 85 B2                 sta   tbRowPtr
5070 8C7D A5 B0                 lda   bufPtr+2
5071 8C7F 90 01                 bcc   @NoCarry
5072 8C81 1A                    inc   a
5073 8C82
5074 8C82 85 B4        @NoCarry sta   tbRowPtr+2
5075 8C84 D4 B3                 pei   tbRowPtr+1               ;set DBR to match current row position
5076 8C86 AB                    plb   
5077 8C87 AB                    plb   
5078 8C88              ;
5079 8C88 A5 D0                 lda   rightExtent
5080 8C8A 0A                    asl   a
5081 8C8B 38                    sec   
5082 8C8C E5 2A                 sbc   temp
5083 8C8E 85 EA                 sta   numOfBytes
5084 8C90              ;
5085 8C90 A5 CA                 lda   chHeight
5086 8C92 85 C8                 sta   rowCounter
5087 8C94              ;
5088 8C94              NextRow                                 ; 
5089 8C94 A9 00 00              lda   #0
5090 8C97 A0 00 00              ldy   #0
5091 8C9A              ;
5092 8C9A              NextWord                                ; 
5093 8C9A 91 B2                 sta   (tbRowPtr),y
5094 8C9C              ;
5095 8C9C C4 EA                 cpy   numOfBytes
5096 8C9E F0 04                 beq   CheckRows                ;this row done
5097 8CA0              ;no, it isn't:
5098 8CA0 C8                    iny   
5099 8CA1 C8                    iny   
5100 8CA2 80 F6                 bra   NextWord
5101 8CA4              ;
5102 8CA4              CheckRows                               ; 
5103 8CA4 C6 C8                 dec   rowCounter
5104 8CA6 F0 11                 beq   BufCleared               ;all rows cleared
5105 8CA8              ;bump pointer for next row:
5106 8CA8 A5 B2                 lda   tbRowPtr
5107 8CAA 18                    clc   
5108 8CAB 65 C4                 adc   bufRowBytes
5109 8CAD 85 B2                 sta   tbRowPtr
5110 8CAF 90 06                 bcc   NoCarry
5111 8CB1 E6 B4                 inc   tbRowPtr+2
5112 8CB3 D4 B3                 pei   tbRowPtr+1               ;reset DBR if necessary
5113 8CB5 AB                    plb   
5114 8CB6 AB                    plb   
5115 8CB7              NoCarry                                 ; 
5116 8CB7 80 DB                 bra   NextRow
5117 8CB9              ;
5118 8CB9              BufCleared                              ; 
5119 8CB9              ;please note it is only cleared along the columns specified
5120 8CB9 AB                    plb   
5121 8CBA 6B                    rtl   
5122 8CBB                       ENDP 
5123 8CBB              *****************************************
5124 8CBB              *                                       *
5125 8CBB              *  end of ClearBufPart                  *
5126 8CBB              *                                       *
5127 8CBB              *****************************************
5128 8CBB              ;
5129 8CBB              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
5130 8CBB              ;
5131 8CBB              *****************************************
5132 8CBB              *                                       *
5133 8CBB              *  current date and time:               *
5134 8CBB              *    4:10 PM, 4/4/86                    *
5135 8CBB              *                                       *
5136 8CBB              *****************************************
5137 8CBB              ;
5138 8CBB              *******************************************************************************
5139 8CBB              *                                                                             *
5140 8CBB              *              subroutine CleanUpBuffer                                       *
5141 8CBB              *                                                                             *
5142 8CBB              *                                        started 4/4/86                       *
5143 8CBB              *                                        Bennet Marks x6245                   *
5144 8CBB              *                                                                             *
5145 8CBB              *  ABSTRACT:  this subroutine zeroes out all words in the text buffer that    *
5146 8CBB              *  may have been written into by PutChar (or any other routine that may write *
5147 8CBB              *  into the text buffer, and observes the right bookkeeping protocols).       *
5148 8CBB              *                                                                             *
5149 8CBB              *  ASSUMPTIONS:  textBufHeight (usually set by SizeTextBuffer) and bufPtr     *
5150 8CBB              *  and bufRowBytes (both usually set by SetUpBufInfo) are on 0-page.          *
5151 8CBB              *  leftExtent and rightExtent are the leftmost pixel and rightmost pixel pos- *
5152 8CBB              *  sitions, respectively, that have been "dirtied" by PutChar or some similar *
5153 8CBB              *  routine; if no pixel in the text buffer has been touched, then leftExtent  *
5154 8CBB              *  is greater that rightExtent (these conditions are insured by a call to     *
5155 8CBB              *  SetUpBufInfo, followed by 0 or more calls to PutChar).                     *
5156 8CBB              *                                                                             *
5157 8CBB              *  ALTERS:  leftExtent and rightExtent are "boiled down" from pixel units to  *
5158 8CBB              *  words.  The call to ClearBufPart may change numOfWords, currBufByte,       *
5159 8CBB              *  bufByte, wordCounter, and rowCounter.                                      *
5160 8CBB              *                                                                             *
5161 8CBB              *  NOTES: CleanUpBuffer returns with an RTL.                                  *
5162 8CBB              *                                                                             *
5163 8CBB              *******************************************************************************
5164 8CBB              ;
5165 8CBB              *****************************************
5166 8CBB              *                                       *
5167 8CBB              *  V.0.1.0 - 4/4/86                     *
5168 8CBB              *                                       *
5169 8CBB              *****************************************
5170 8CBB              ;
5171 8CBB                       EXPORT iCleanUpBuffer 
5172 8CBB              iCleanUpBuffer PROC 
5173 8CBB              *              using E0Vectors
5174 8CBB              ;
5175 8CBB A5 D0                 lda   rightExtent
5176 8CBD C5 CE                 cmp   leftExtent
5177 8CBF 10 02                 bpl   SomeExtent
5178 8CC1 80 12                 bra   NoExtent                 ;no pixel has been touched
5179 8CC3              ;
5180 8CC3              SomeExtent                              ; 
5181 8CC3              ;note rightExtent is in acc. (measured in pixels)
5182 8CC3 4A                    lsr   a
5183 8CC4 4A                    lsr   a
5184 8CC5 4A                    lsr   a
5185 8CC6 4A                    lsr   a
5186 8CC7 85 D0                 sta   rightExtent              ;now boiled down to words
5187 8CC9              ;
5188 8CC9 A5 CE                 lda   leftExtent               ;in pixels
5189 8CCB 4A                    lsr   a
5190 8CCC 4A                    lsr   a
5191 8CCD 4A                    lsr   a
5192 8CCE 4A                    lsr   a
5193 8CCF 85 CE                 sta   leftExtent               ;now words
5194 8CD1              ;
5195 8CD1 22 70 1F E0           jsl   ClearBufPart
5196 8CD5              ;
5197 8CD5              NoExtent                                ; 
5198 8CD5              ;
5199 8CD5 6B                    rtl   
5200 8CD6                       ENDP 
5201 8CD6              *****************************************
5202 8CD6              *                                       *
5203 8CD6              *  end of CleanUpBuffer                 *
5204 8CD6              *                                       *
5205 8CD6              *****************************************
5206 8CD6              ;
5207 8CD6              ;
5208 8CD6              ;                copy text/textstyles
5209 8CD6              *****************************************
5210 8CD6              *                                       *
5211 8CD6              *  current date and time:               *
5212 8CD6              *    4:00 PM, 5/3/86                    *
5213 8CD6              *                                       *
5214 8CD6              *****************************************
5215 8CD6              ;
5216 8CD6              *******************************************************************************
5217 8CD6              *                                                                             *
5218 8CD6              *              subroutine StyleText (also, StyleExtents)                      *
5219 8CD6              *                                                                             *
5220 8CD6              *                                        started 5/2/86                       *
5221 8CD6              *                                        Bennet Marks x6245                   *
5222 8CD6              *                                                                             *
5223 8CD6              *  ABSTRACT:  this subroutine subroutine modifies the text buffer to reflect  *
5224 8CD6              *  any current styles specified by the value of txFace.  It also updates      *
5225 8CD6              *  rightExtent and leftExtent to match the new "active text buffer" limits.   *
5226 8CD6              *                                                                             *
5227 8CD6              *  The subroutine has a separate entry point, StyleExtents, which only        *
5228 8CD6              *  changes the extents.  This is useful in text bounding-box calls, in which  *
5229 8CD6              *  only the measuring of the text extent is important                         *
5230 8CD6              *                                                                             *
5231 8CD6              *  ASSUMPTIONS:  the subroutine requires qwerty qwerty qwerty qwerty qwerty   *
5232 8CD6              *                                                                             *
5233 8CD6              *  RETURNS:  iamozymandiaskingofkingslokuponmyworksyemightyanddespair         *
5234 8CD6              *                                                                             *
5235 8CD6              *  NOTES: doe a deer a female deer ray a drop of golden sun me a name I call  *
5236 8CD6              *                                                                             *
5237 8CD6              *                                                                             *
5238 8CD6              *  Modification History                                                       *
5239 8CD6              *                                                                             *
5240 8CD6              *  19 May 86    StyleText, StyleExtents, DoBold and DoUnderline are now       *
5241 8CD6              *  (SEG)        E0Vectors and StyleText has a new using E0Vectors statement.  *
5242 8CD6              *                                                                             *
5243 8CD6              *******************************************************************************
5244 8CD6              ;
5245 8CD6              *****************************************
5246 8CD6              *                                       *
5247 8CD6              *  V.0.1.0 - 5/2/8666                   *
5248 8CD6              *                                       *
5249 8CD6              *****************************************
5250 8CD6              ;
5251 8CD6                       EXPORT iStyleText 
5252 8CD6              iStyleText PROC 
5253 8CD6              ;
5254 8CD6              *              using E0Vectors	; new using statement SEB
5255 8CD6              ;
5256 8CD6 64 E8                 stz   justExtents              ;style both text buffer and extents
5257 8CD8 80 05                 bra   DoStyle
5258 8CDA              ;
5259 8CDA                       EXPORT iStyleExtents 
5260 8CDA              iStyleExtents                           ; 
5261 8CDA A9 FF FF              lda   #TRUE
5262 8CDD 85 E8                 sta   justExtents              ;text buffer irrelevant
5263 8CDF              ;
5264 8CDF              DoStyle                                 ; 
5265 8CDF A5 E6                 lda   txFace
5266 8CE1 F0 14                 beq   PlainStyle
5267 8CE3              ;
5268 8CE3 89 01 00              bit   #boldBit
5269 8CE6 F0 06                 beq   NotBold
5270 8CE8              ;it's BOLD!
5271 8CE8 22 B8 1F E0           jsl   DoBold
5272 8CEC A5 E6                 lda   txFace
5273 8CEE              NotBold                                 ; 
5274 8CEE 89 04 00              bit   #ulineBit
5275 8CF1 F0 04                 beq   NotUline
5276 8CF3              ;underline it __________ __!
5277 8CF3              ;
5278 8CF3 22 BC 1F E0           jsl   DoUnderline
5279 8CF7              NotUline                                ; 
5280 8CF7              ;
5281 8CF7              PlainStyle                              ; 
5282 8CF7 6B                    rtl   
5283 8CF8                       ENDP 
5284 8CF8              *****************************************
5285 8CF8              *                                       *
5286 8CF8              *  end of StyleText                     *
5287 8CF8              *  (also, StyleExtents)                 *
5288 8CF8              *                                       *
5289 8CF8              *****************************************
5290 8CF8              ;
5291 8CF8              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
5292 8CF8              ;
5293 8CF8              ;
5294 8CF8              ;this routine fixes a bug in DoBold and simplifies the implementation of
5295 8CF8              ;the bolding algorithm.  It should be patched in instead of DoBold in the
5296 8CF8              ;1.0 ROM, and should replace DoBold in the 1.1 ROM
5297 8CF8              ;
5298 8CF8              *******************************************************************************
5299 8CF8              *                                                                             *
5300 8CF8              *              subroutine DoBold                                              *
5301 8CF8              *                                                                             *
5302 8CF8              *                                        started 4/29/86                      *
5303 8CF8              *                                        Bennet Marks x6245                   *
5304 8CF8              *                                                                             *
5305 8CF8              *  ABSTRACT:  this subroutine performs a simple bolding transformation on the *
5306 8CF8              *  text buffer.  The entire active chunk of the buffer is shifted 1 pixel to  *
5307 8CF8              *  the right, and ORed with the original buffer.  rightExtent is incremented  *
5308 8CF8              *  by 1 as well.                                                              *
5309 8CF8              *                                                                             *
5310 8CF8              *  ASSUMPTIONS: to follow                                                     *
5311 8CF8              *                                                                             *
5312 8CF8              *  NOTES: DBR is preserved.  DoBold returns with an RTL.                      *
5313 8CF8              *                                                                             *
5314 8CF8              *******************************************************************************
5315 8CF8              ;
5316 8CF8              ***************************************
5317 8CF8              *                                     *
5318 8CF8              *  Feb. 5, 1987  5:00 pm              *
5319 8CF8              *                                     *
5320 8CF8              ***************************************
5321 8CF8              ;
5322 8CF8                       EXPORT iDoBold 
5323 8CF8              iDoBold  PROC 
5324 8CF8              ;
5325 8CF8              AnotherNewY equ   temp2+2
5326 8CF8              ;
5327 8CF8 A5 D0                 lda   rightExtent
5328 8CFA C5 CE                 cmp   leftExtent
5329 8CFC 10 01                 bpl   ExtentOK                 ;there are some pixels to bold
5330 8CFE 6B                    rtl                            ;nothing to work with
5331 8CFF              ExtentOK                                ; 
5332 8CFF              ;
5333 8CFF              ****  ADDED 2/5/87 - BHM
5334 8CFF              ;
5335 8CFF E6 D0                 inc   rightExtent              ;saves some effort later
5336 8D01              ;
5337 8D01              ****  END OF ADDITION
5338 8D01 A5 E8                 lda   justExtents
5339 8D03 F0 01                 beq   BoldAll                  ;bold text buffer and extents
5340 8D05 6B                    rtl                            ;extents already bolded
5341 8D06              ;
5342 8D06              BoldAll                                 ; 
5343 8D06 8B                    phb   
5344 8D07              ;
5345 8D07 A5 CA                 lda   chHeight
5346 8D09 85 C8                 sta   rowCounter
5347 8D0B              ;
5348 8D0B              ;
5349 8D0B A5 CE                 lda   leftExtent
5350 8D0D 4A                    lsr   a
5351 8D0E 4A                    lsr   a
5352 8D0F 4A                    lsr   a
5353 8D10 29 FE FF              and   #first15Bits             ;even-byte offset to left edge
5354 8D13 85 2A                 sta   temp
5355 8D15              ;
5356 8D15 18                    clc   
5357 8D16 65 AE                 adc   bufPtr
5358 8D18 85 B2                 sta   tbRowPtr
5359 8D1A A5 B0                 lda   bufPtr+2
5360 8D1C 90 01                 bcc   NoCarry
5361 8D1E 1A                    inc   a
5362 8D1F
5363 8D1F 85 B4        NoCarry  sta   tbRowPtr+2
5364 8D21              ;tbRowPtr now points to the low byte of the first
5365 8D21              ;word in the text buffer containing image bits
5366 8D21              ;
5367 8D21 D4 B3                 pei   tbRowPtr+1
5368 8D23 AB                    plb   
5369 8D24 AB                    plb                            ;set DBR for this part of buffer
5370 8D25              ;
5371 8D25 A5 D0                 lda   rightExtent
5372 8D27 4A                    lsr   a
5373 8D28 4A                    lsr   a
5374 8D29 4A                    lsr   a
5375 8D2A 29 FE FF              and   #first15Bits             ;even-byte offset to right edge
5376 8D2D              ;
5377 8D2D 38                    sec   
5378 8D2E E5 2A                 sbc   temp                     ;get number of words spanned (* 2)
5379 8D30 D0 03                 bne   MoreThanAWord
5380 8D32 82 48 00              brl   OnlyOneWord
5381 8D35              ;
5382 8D35              MoreThanAWord                           ; 
5383 8D35              ;active text buffer crosses word boundaries.
5384 8D35 85 EA                 sta   numOfBytes               ;so this is >= 2
5385 8D37              ;
5386 8D37              NextRow                                 ; 
5387 8D37              ;we will work from right to left along each row:
5388 8D37 A4 EA                 ldy   numOfBytes
5389 8D39 B1 B2                 lda   (tbRowPtr),y             ;rightmost word
5390 8D3B EB                    xba                            ;[IS THIS RIGHT?]
5391 8D3C 4A                    lsr   a                        ;shift right 1 pixel
5392 8D3D 85 2A                 sta   temp
5393 8D3F              ;
5394 8D3F              NextWord                                ; 
5395 8D3F BB                    tyx                            ;temp. storage
5396 8D40 88                    dey   
5397 8D41 88                    dey   
5398 8D42 84 30                 sty   AnotherNewY
5399 8D44 B1 B2                 lda   (tbRowPtr),y             ;the word just to the left
5400 8D46 EB                    xba   
5401 8D47 4A                    lsr   a
5402 8D48              ;we'll need this next time through the loop
5403 8D48 85 2E                 sta   temp2
5404 8D4A A5 2A                 lda   temp
5405 8D4C              ;we have a carry bit still left over from the LSR
5406 8D4C 90 03                 bcc   RightBit0                ;no bit to shift in
5407 8D4E              ;oh, yeah?
5408 8D4E 09 00 80              ora   #firstBit
5409 8D51              RightBit0                               ; 
5410 8D51              ;
5411 8D51 9B                    txy                            ;y set again for rightmore word
5412 8D52 EB                    xba   
5413 8D53 11 B2                 ora   (tbRowPtr),y             ;merge with existing buffer
5414 8D55 91 B2                 sta   (tbRowPtr),y
5415 8D57              ;
5416 8D57 A4 30                 ldy   AnotherNewY              ;moving left along . . .
5417 8D59 F0 06                 beq   LeftMostWord
5418 8D5B              ;
5419 8D5B A5 2E                 lda   temp2
5420 8D5D 85 2A                 sta   temp                     ;set up for next pass
5421 8D5F 80 DE                 bra   NextWord
5422 8D61              ;
5423 8D61              LeftMostWord                            ; 
5424 8D61              ;we've gotten to the left edge of the active buffer -
5425 8D61              ;no previous word to bother with
5426 8D61 A5 2E                 lda   temp2                    ;already fetched and shifted
5427 8D63 EB                    xba   
5428 8D64 12 B2                 ora   (tbRowPtr)
5429 8D66 92 B2                 sta   (tbRowPtr)
5430 8D68              ;
5431 8D68 C6 C8                 dec   rowCounter
5432 8D6A F0 2F                 beq   AllDone
5433 8D6C              ;more rows to go - bump pointer:
5434 8D6C A5 B2                 lda   tbRowPtr
5435 8D6E 18                    clc   
5436 8D6F 65 C4                 adc   bufRowBytes
5437 8D71 85 B2                 sta   tbRowPtr
5438 8D73 90 06                 bcc   NoCarry1
5439 8D75 E6 B4                 inc   tbRowPtr+2               ;on carry, inc high word . . .
5440 8D77 D4 B3                 pei   tbRowPtr+1               ;and reset DBR
5441 8D79 AB                    plb   
5442 8D7A AB                    plb   
5443 8D7B              NoCarry1                                ; 
5444 8D7B 80 BA                 bra   NextRow
5445 8D7D              ;
5446 8D7D              ;
5447 8D7D              ****  CHANGED 2/5/87 - BHM
5448 8D7D              ;only-one-word case changed to reflect already-bolded buffer
5449 8D7D              ;
5450 8D7D              OnlyOneWord                             ; 
5451 8D7D              ;active buffer confined to one word in width
5452 8D7D              ;
5453 8D7D              OOWNextRow                              ; 
5454 8D7D B2 B2                 lda   (tbRowPtr)
5455 8D7F EB                    xba   
5456 8D80 4A                    lsr   a
5457 8D81 EB                    xba   
5458 8D82 12 B2                 ora   (tbRowPtr)
5459 8D84 92 B2                 sta   (tbRowPtr)
5460 8D86              ;
5461 8D86 C6 C8                 dec   rowCounter
5462 8D88 F0 11                 beq   AllDone
5463 8D8A              ;rows to go:
5464 8D8A A5 B2                 lda   tbRowPtr
5465 8D8C 18                    clc   
5466 8D8D 65 C4                 adc   bufRowBytes
5467 8D8F 85 B2                 sta   tbRowPtr
5468 8D91 90 06                 bcc   NoCarry2
5469 8D93 E6 B4                 inc   tbRowPtr+2
5470 8D95 D4 B3                 pei   tbRowPtr+1
5471 8D97 AB                    plb   
5472 8D98 AB                    plb   
5473 8D99              NoCarry2                                ; 
5474 8D99 80 E2                 bra   OOWNextRow
5475 8D9B              ;
5476 8D9B              AllDone                                 ; 
5477 8D9B AB                    plb   
5478 8D9C              ;
5479 8D9C 6B                    rtl   
5480 8D9D                       ENDP 
5481 8D9D              ;
5482 8D9D              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
5483 8D9D              ;
5484 8D9D              *****************************************
5485 8D9D              *                                       *
5486 8D9D              *  current date and time:               *
5487 8D9D              *    2:00 PM, 5/3/86                    *
5488 8D9D              *                                       *
5489 8D9D              *****************************************
5490 8D9D              ;
5491 8D9D              *******************************************************************************
5492 8D9D              *                                                                             *
5493 8D9D              *              subroutine DoUnderline                                         *
5494 8D9D              *                                                                             *
5495 8D9D              *                                        started 5/3/86                       *
5496 8D9D              *                                        Bennet Marks x6245                   *
5497 8D9D              *                                                                             *
5498 8D9D              *  ABSTRACT:  this subroutine adds underlining to the current image in the    *
5499 8D9D              *  text buffer.  The underline is put at 2 pixels below the base line.  If    *
5500 8D9D              *  the font descent is less than 2, no underlining is done.                   *
5501 8D9D              *                                                                             *
5502 8D9D              *  The underlining is a "smart" one, in which an underline pixel is skipped   *
5503 8D9D              *  if there is an image pixel just above, below, to the right, or to the      *
5504 8D9D              *  left of it.                                                                *
5505 8D9D              *                                                                             *
5506 8D9D              *  ASSUMPTIONS:  the subroutine requires qwerty qwerty qwerty qwerty qwerty   *
5507 8D9D              *                                                                             *
5508 8D9D              *  RETURNS:  iamozymandiaskingofkingslokuponmyworksyemightyanddespair         *
5509 8D9D              *                                                                             *
5510 8D9D              *  NOTES: doe a deer a female deer ray a drop of golden sun me a name I call  *
5511 8D9D              *                                                                             *
5512 8D9D              *******************************************************************************
5513 8D9D              ;
5514 8D9D              *****************************************
5515 8D9D              *                                       *
5516 8D9D              *  V.0.1.0 - 5/3/86                     *
5517 8D9D              *                                       *
5518 8D9D              *****************************************
5519 8D9D              ;
5520 8D9D                       EXPORT iDoUnderline 
5521 8D9D              iDoUnderline PROC 
5522 8D9D              *              USING E0Vectors
5523 8D9D              ;
5524 8D9D              descentMod equ   temp+2
5525 8D9D              ;
5526 8D9D A5 E2                 lda   descent
5527 8D9F C9 02 00              cmp   #2
5528 8DA2 F0 03                 beq   DescentEQ2
5529 8DA4 10 06                 bpl   DescentGT2
5530 8DA6              ;descent < 2 - do not underline
5531 8DA6 6B                    rtl   
5532 8DA7              ;
5533 8DA7              DescentEQ2                              ; 
5534 8DA7 A9 00 00              lda   #AllBitsOff
5535 8DAA 80 03                 bra   GotDescent
5536 8DAC              DescentGT2                              ; 
5537 8DAC A9 FF FF              lda   #AllBitsOn
5538 8DAF              GotDescent                              ; 
5539 8DAF 85 2C                 sta   DescentMod
5540 8DB1              ;DescentMod will be used to zero out any garbage from below the
5541 8DB1              ;underline when there is no valid image info there
5542 8DB1              ;
5543 8DB1 A5 D0                 lda   rightExtent
5544 8DB3 C5 CE                 cmp   LeftExtent
5545 8DB5 10 10                 bpl   ExtentsOK
5546 8DB7              ;0 image width:
5547 8DB7 A5 90                 lda   bufPen
5548 8DB9 C5 92                 cmp   startBufPen
5549 8DBB              ;
5550 8DBB              **  BUG FIX
5551 8DBB D0 01                 bne   NotUtterNull             ;changed from "bpl"
5552 8DBD              ;
5553 8DBD              **  END OF BUG FIX - BHM  x6245
5554 8DBD              ;
5555 8DBD              ;utter null:  no image pixels, no pen change
5556 8DBD 6B                    rtl                            ;so what can you do?
5557 8DBE              ;
5558 8DBE              NotUtterNull                            ; ;but still 0 image width
5559 8DBE 3A                    dec   a                        ;bufPen was in acc.
5560 8DBF 85 D0                 sta   rightExtent
5561 8DC1 A5 92                 lda   startBufPen
5562 8DC3 85 CE                 sta   leftExtent
5563 8DC5 80 11                 bra   LNROK
5564 8DC7              ;
5565 8DC7              ExtentsOK                               ; 
5566 8DC7 A5 90                 lda   bufPen
5567 8DC9 3A                    dec   a
5568 8DCA C5 D0                 cmp   rightExtent
5569 8DCC 30 02                 bmi   rightOK
5570 8DCE 85 D0                 sta   rightExtent
5571 8DD0              RightOK                                 ; 
5572 8DD0              ;
5573 8DD0 A5 92                 lda   startBufPen
5574 8DD2 C5 CE                 cmp   leftExtent
5575 8DD4 10 02                 bpl   LeftOK
5576 8DD6 85 CE                 sta   leftExtent
5577 8DD8              LeftOK                                  ; 
5578 8DD8              ;leftExtent and rightExtent have now been modified to include entire underline
5579 8DD8              ;
5580 8DD8              LNROK                                   ; 
5581 8DD8 A5 E8                 lda   justExtents
5582 8DDA F0 01                 beq   UlineIt
5583 8DDC              ;only extents to be changed - and they're done:
5584 8DDC 6B                    rtl   
5585 8DDD              ;
5586 8DDD              UlineIt                                 ; 
5587 8DDD A5 CE                 lda   leftExtent
5588 8DDF 4A                    lsr   a
5589 8DE0 4A                    lsr   a
5590 8DE1 4A                    lsr   a
5591 8DE2 29 FE FF              and   #first15Bits             ;boiled down to even-byte offset
5592 8DE5 85 2A                 sta   temp
5593 8DE7              ;
5594 8DE7 F4 00 00 F4           PushLong #0                    ;for result of multiply
5595 8DED D4 C4                 pei   bufRowBytes
5596 8DEF D4 84                 pei   ascent
5597 8DF1 A2 0B 09 22           _Multiply 
5598 8DF8 68                    pla                            ;low word
5599 8DF9 18                    clc   
5600 8DFA 65 AE                 adc   bufPtr
5601 8DFC 85 B6                 sta   pmRowPtr
5602 8DFE 68                    pla   
5603 8DFF 65 B0                 adc   bufPtr+2
5604 8E01 85 B8                 sta   pmRowPtr+2
5605 8E03              ;
5606 8E03 A5 B6                 lda   pmRowPtr
5607 8E05 18                    clc   
5608 8E06 65 2A                 adc   temp
5609 8E08 85 B6                 sta   pmRowPtr
5610 8E0A 90 02                 bcc   NoCarry1
5611 8E0C E6 B8                 inc   pmRowPtr+2
5612 8E0E              NoCarry1                                ; 
5613 8E0E              ;
5614 8E0E A5 B6                 lda   pmRowPtr
5615 8E10 18                    clc   
5616 8E11 65 C4                 adc   bufRowBytes
5617 8E13 85 B2                 sta   tbRowPtr
5618 8E15 A5 B8                 lda   pmRowPtr+2
5619 8E17 90 01                 bcc   NoCarry2
5620 8E19 1A                    inc   a
5621 8E1A
5622 8E1A 85 B4        NoCarry2 sta   tbRowPtr+2
5623 8E1C 85 D4                 sta   fontTemp+2
5624 8E1E              ;
5625 8E1E A5 B2                 lda   tbRowPtr
5626 8E20 18                    clc   
5627 8E21 65 C4                 adc   bufRowBytes
5628 8E23 85 D2                 sta   fontTemp
5629 8E25 90 02                 bcc   NoCarry3
5630 8E27 E6 D4                 inc   fontTemp+2
5631 8E29              NoCarry3                                ; 
5632 8E29              ;
5633 8E29              ;pmRowPtr now points to the first important byte in the row above
5634 8E29              ;the underline, tbRowPtr to the analogous byte in the underline's row,
5635 8E29              ;and fontTemp just one row below that
5636 8E29              ;
5637 8E29 8B                    phb   
5638 8E2A D4 B3                 pei   tbRowPtr+1               ;set DBR for underline's row
5639 8E2C AB                    plb   
5640 8E2D AB                    plb   
5641 8E2E              ;
5642 8E2E A5 D0                 lda   rightExtent
5643 8E30 4A                    lsr   a
5644 8E31 4A                    lsr   a
5645 8E32 4A                    lsr   a
5646 8E33 29 FE FF              and   #first15Bits             ;boiled down to even byte
5647 8E36 38                    sec   
5648 8E37 E5 2A                 sbc   temp                     ;same for left bound
5649 8E39 D0 03                 bne   MoreThanAWord            ;. . . of active text buffer
5650 8E3B 82 69 00              brl   OnlyOneWord
5651 8E3E              ;
5652 8E3E              MoreThanAWord                           ; 
5653 8E3E              ;acc. holds even numOfBytes, >= 2
5654 8E3E 85 EA                 sta   numOfBytes               ;added 3/10/87
5655 8E40 A8                    tay   
5656 8E41              ;temp will be used to accumulate "interfering" image pixels for the current
5657 8E41              ;word; temp2 will serve the same purpose for the previous word.  Since we
5658 8E41              ;need the previous word shifted to handle the current one, a lot of work can
5659 8E41              ;be saved for the next pass ("previous", here, means one word to the left)
5660 8E41              ;
5661 8E41 B1 B2                 lda   (tbRowPtr),y             ;current word
5662 8E43 EB                    xba   
5663 8E44 4A                    lsr   a
5664 8E45 EB                    xba   
5665 8E46 85 2A                 sta   temp
5666 8E48              ;
5667 8E48              NextWord                                ; ;(actually, "PreviousWord")
5668 8E48              ;
5669 8E48 64 2E                 stz   temp2
5670 8E4A B1 B2                 lda   (tbRowPtr),y
5671 8E4C EB                    xba   
5672 8E4D 0A                    asl   a
5673 8E4E EB                    xba   
5674 8E4F 05 2A                 ora   temp
5675 8E51 85 2A                 sta   temp
5676 8E53 90 05                 bcc   LeftBit0
5677 8E55              ;left bit of current word is set - hand it over for next pass:
5678 8E55 A9 00 01              lda   #lastBitXBAed
5679 8E58 85 2E                 sta   temp2
5680 8E5A              LeftBit0                                ; 
5681 8E5A              ;
5682 8E5A B7 D2                 lda   [fontTemp],y             ;word below
5683 8E5C 25 2C                 and   descentMod               ;0 if no row below, $FFFF ow
5684 8E5E 17 B6                 ora   [pmRowPtr],y
5685 8E60 05 2A                 ora   temp
5686 8E62 85 2A                 sta   temp
5687 8E64              ;
5688 8E64 88                    dey   
5689 8E65 88                    dey   
5690 8E66 B1 B2                 lda   (tbRowPtr),y
5691 8E68 EB                    xba   
5692 8E69 4A                    lsr   a
5693 8E6A EB                    xba   
5694 8E6B 05 2E                 ora   temp2
5695 8E6D 85 2E                 sta   temp2
5696 8E6F 90 07                 bcc   RightBit0
5697 8E71              ;right bit of previous word set - use it here
5698 8E71 A9 80 00              lda   #firstBitXBAed
5699 8E74 05 2A                 ora   temp
5700 8E76 85 2A                 sta   temp
5701 8E78              RightBit0                               ; 
5702 8E78              ;
5703 8E78 A5 2A                 lda   temp
5704 8E7A 49 FF FF              eor   #allBitsOn
5705 8E7D C8                    iny   
5706 8E7E C8                    iny   
5707 8E7F              ;TRY THIS, WHY DONTCHA?
5708 8E7F 11 B2                 ora   (tbRowPtr),y
5709 8E81              ;OK - CONSIDER IT TRIED
5710 8E81 91 B2                 sta   (tbRowPtr),y
5711 8E83              ;
5712 8E83 88                    dey   
5713 8E84 88                    dey   
5714 8E85 F0 06                 beq   LeftMostWord
5715 8E87              ;previous becomes current:
5716 8E87 A5 2E                 lda   temp2
5717 8E89 85 2A                 sta   temp
5718 8E8B 80 BB                 bra   NextWord
5719 8E8D              ;
5720 8E8D              LeftMostWord                            ; 
5721 8E8D              ;new current word right-shifted and bit from
5722 8E8D              ;word to the right already ORed in temp2
5723 8E8D              ;
5724 8E8D A7 D2                 lda   [fontTemp]               ;word below
5725 8E8F 25 2C                 and   descentMod               ;if any
5726 8E91 07 B6                 ora   [pmRowPtr]               ;above
5727 8E93 05 2E                 ora   temp2
5728 8E95 85 2E                 sta   temp2
5729 8E97              ;
5730 8E97 B2 B2                 lda   (tbRowPtr)
5731 8E99 EB                    xba   
5732 8E9A 0A                    asl   a
5733 8E9B EB                    xba   
5734 8E9C 05 2E                 ora   temp2
5735 8E9E 49 FF FF              eor   #allBitsOn
5736 8EA1              ;THIS TOO
5737 8EA1 12 B2                 ora   (tbRowPtr)
5738 8EA3              ;GOTCHA
5739 8EA3 92 B2                 sta   (tbRowPtr)
5740 8EA5              ;
5741 8EA5 80 20                 bra   AllDone
5742 8EA7              ;
5743 8EA7              OnlyOneWord                             ; 
5744 8EA7              ;
5745 8EA7              **  ADDED 3/10/87 TO HELP WITH THE BOUNDARY PROBLEM
5746 8EA7              ;  (see below)
5747 8EA7              ;
5748 8EA7 85 EA                 sta   numOfBytes               ;helps to know it's 0
5749 8EA9              ;
5750 8EA9              **  END OF CHANGE - BHM  x6245
5751 8EA9              ;
5752 8EA9 A7 D2                 lda   [fontTemp]
5753 8EAB 25 2C                 and   descentMod
5754 8EAD 07 B6                 ora   [pmRowPtr]
5755 8EAF 85 2A                 sta   temp
5756 8EB1              ;
5757 8EB1 B2 B2                 lda   (tbRowPtr)
5758 8EB3 EB                    xba   
5759 8EB4 AA                    tax                            ;temp. storage
5760 8EB5 4A                    lsr   a
5761 8EB6 EB                    xba   
5762 8EB7 05 2A                 ora   temp
5763 8EB9 85 2A                 sta   temp
5764 8EBB              ;
5765 8EBB 8A                    txa   
5766 8EBC 0A                    asl   a
5767 8EBD EB                    xba   
5768 8EBE 05 2A                 ora   temp
5769 8EC0 49 FF FF              eor   #allBitsOn
5770 8EC3              ;AND THIS?
5771 8EC3 12 B2                 ora   (tbRowPtr)
5772 8EC5              ;RIGHT
5773 8EC5 92 B2                 sta   (tbRowPtr)
5774 8EC7              ;
5775 8EC7              AllDone                                 ; 
5776 8EC7              ;
5777 8EC7              **  ADDED 3/10/87
5778 8EC7              ;formerly, the underlining was allowed to extend past the natural
5779 8EC7              ;boundaries of the text image being underlined to the nearest word
5780 8EC7              ;boundaries - we relied on BlowItUp to do the clipping.  However,
5781 8EC7              ;when outlining or shadowing intervene, this cause trouble.  Hence:
5782 8EC7              ;
5783 8EC7 A5 CE                 lda   leftExtent
5784 8EC9
5785 8EC9 29 0F 00              and   #last4Bits
5786 8ECC 0A                    asl   a
5787 8ECD AA                    tax   
5788 8ECE BF C2 5F FE           lda   >leftBitMask,x
5789 8ED2 32 B2                 and   (tbRowPtr)               ;mask out the extra on the left
5790 8ED4 92 B2                 sta   (tbRowPtr)
5791 8ED6              ;
5792 8ED6 A5 D0                 lda   rightExtent
5793 8ED8 29 0F 00              and   #last4Bits
5794 8EDB 0A                    asl   a
5795 8EDC AA                    tax   
5796 8EDD BF E2 5F FE           lda   >rightBitMask,x
5797 8EE1 A4 EA                 ldy   numOfBytes               ;can be 0
5798 8EE3 31 B2                 and   (tbRowPtr),y             ;mask out extra on right
5799 8EE5 91 B2                 sta   (tbRowPtr),y
5800 8EE7              ;
5801 8EE7              **  END OF CHANGE - BHM  x6245
5802 8EE7              ;
5803 8EE7 AB                    plb   
5804 8EE8 6B                    rtl   
5805 8EE9                       ENDP 
5806 8EE9              *****************************************
5807 8EE9              *                                       *
5808 8EE9              *  end of DoUnderline                   *
5809 8EE9              *                                       *
5810 8EE9              *****************************************
5811 8EE9              ;                copy text/putchar
5812 8EE9              *****************************************
5813 8EE9              *                                       *
5814 8EE9              *  current date and time:               *
5815 8EE9              *    4:30 PM, 4/18/86                   *
5816 8EE9              *                                       *
5817 8EE9              *****************************************
5818 8EE9              ;
5819 8EE9              *******************************************************************************
5820 8EE9              *                                                                             *
5821 8EE9              *              subroutine PutChar                                             *
5822 8EE9              *                                                                             *
5823 8EE9              *                                        started 4/17/86                      *
5824 8EE9              *                                        Bennet Marks x6245                   *
5825 8EE9              *                                                                             *
5826 8EE9              *  ABSTRACT:  this subroutine is used to transfer character images from the   *
5827 8EE9              *  font strike to the text buffer.                                            *
5828 8EE9              *                                                                             *
5829 8EE9              *  ASSUMPTIONS:  the subroutine requires qwerty qwerty qwerty qwerty qwerty   *
5830 8EE9              *                                                                             *
5831 8EE9              *  RETURNS:  iamozymandiaskingofkingslokuponmyworksyemightyanddespair         *
5832 8EE9              *                                                                             *
5833 8EE9              *  NOTES: doe a deer a female deer ray a drop of golden sun me a name I call  *
5834 8EE9              *                                                                             *
5835 8EE9              *******************************************************************************
5836 8EE9              ;
5837 8EE9              *****************************************
5838 8EE9              *                                       *
5839 8EE9              *  V.0.2.0 - 4/17/86                    *
5840 8EE9              *    A substantially different version  *
5841 8EE9              *    of this subroutine appeared in     *
5842 8EE9              *    earlier software.  Used by per-    *
5843 8EE9              *    mission - BHM, 4/17/86             *
5844 8EE9              *                                       *
5845 8EE9              *****************************************
5846 8EE9              ;
5847 8EE9                       EXPORT iPutChar 
5848 8EE9              iPutChar PROC 
5849 8EE9              *              using E0Vectors
5850 8EE9              ;
5851 8EE9              ;.......................................
5852 8EE9              *imageWidth    equ temp
5853 8EE9              *locTEnt       equ temp+2
5854 8EE9              *startBit      equ temp2
5855 8EE9              ;
5856 8EE9 8B                    phb   
5857 8EEA              ;
5858 8EEA A5 90                 lda   bufPen
5859 8EEC 85 98                 sta   imagePen                 ;a much-needed copy
5860 8EEE              ;
5861 8EEE 22 50 1F E0           jsl   ValidChar
5862 8EF2 AA                    tax                            ;temp. storage for o/w value
5863 8EF3              ;
5864 8EF3 29 FF 00              and   #lowByte                 ;get character width
5865 8EF6 18                    clc   
5866 8EF7 65 90                 adc   bufPen                   ;bump pen
5867 8EF9 85 90                 sta   bufPen
5868 8EFB              ;
5869 8EFB B7 7C                 lda   [locTPtr],y              ;this char's location table entry
5870 8EFD                       MacSwitch 
5871 8EFD 85 2C                 sta   locTEnt
5872 8EFF C8                    iny   
5873 8F00 C8                    iny   
5874 8F01 B7 7C                 lda   [locTPtr],y              ;next char's entry
5875 8F03                       MacSwitch 
5876 8F03              ;
5877 8F03 3A                    dec   a                        ;our char's rightmost pixel (in FS)
5878 8F04              ;                                       ;[FS = font strike]
5879 8F04 A8                    tay                            ;temp. storage
5880 8F05              ;
5881 8F05 38                    sec   
5882 8F06 E5 2C                 sbc   locTEnt
5883 8F08 10 03                 bpl   Not0Width
5884 8F0A 82 3B 01              brl   ZeroWidth
5885 8F0D              ;
5886 8F0D              Not0Width                               ; 
5887 8F0D 85 2A                 sta   imageWidth               ;actually, image width-1
5888 8F0F              ;
5889 8F0F 8A                    txa                            ;o/w value
5890 8F10 EB                    xba   
5891 8F11 29 FF 00              and   #lowByte                 ;offset
5892 8F14 18                    clc   
5893 8F15 65 8C                 adc   kernMax
5894 8F17 18                    clc   
5895 8F18 65 98                 adc   imagePen
5896 8F1A 85 98                 sta   imagePen                 ;our char's leftmost pixel (in buffer)
5897 8F1C              ;
5898 8F1C C5 CE                 cmp   leftExtent               ;new leftmost pixel?
5899 8F1E 10 02                 bpl   leftFine                 ;no
5900 8F20 85 CE                 sta   leftExtent               ;yes
5901 8F22              leftFine                                ; 
5902 8F22              ;
5903 8F22 18                    clc   
5904 8F23 65 2A                 adc   imageWidth               ;rightmost pixel (in buffer)
5905 8F25 C5 D0                 cmp   rightExtent
5906 8F27 30 02                 bmi   rightFine
5907 8F29 85 D0                 sta   rightExtent
5908 8F2B              RightFine                               ; ;thank'ee kindly, Ma'am
5909 8F2B              ;
5910 8F2B A5 2C                 lda   locTEnt                  ;rightmost pixel in FS
5911 8F2D 29 0F 00              and   #last4Bits
5912 8F30              ;startBit is the position of the rightmost pixel (of our
5913 8F30              ;character, in the font strike) within its pixelword:
5914 8F30 85 2E                 sta   startBit
5915 8F32 0A                    asl   a                        ;for access to mask table
5916 8F33 AA                    tax   
5917 8F34 BF C2 5F FE           lda   >leftBitMask,x
5918 8F38              ;maskLeft masks out all the garbage in the font strike to the left of our
5919 8F38              ;character's image (this "garbage" is, of course, perfectly good image
5920 8F38              ;information for the previous character):
5921 8F38 85 A4                 sta   maskLeft
5922 8F3A              ;
5923 8F3A A5 2C                 lda   locTEnt
5924 8F3C 4A                    lsr   a
5925 8F3D 4A                    lsr   a
5926 8F3E 4A                    lsr   a
5927 8F3F 29 FE FF              and   #first15Bits
5928 8F42              ;startByte is the first byte of the first font strike word containing any
5929 8F42              ;pixels of our character - it is constrained to be even:
5930 8F42 85 9C                 sta   startByte
5931 8F44              ;
5932 8F44              ;pmRowPtr (pm for "pixelmap" - it's generic) points to startByte; later it
5933 8F44              ;will be updated for each new row:
5934 8F44 18                    clc   
5935 8F45 65 78                 adc   strikePtr                ;add startByte to font strike pointer
5936 8F47 85 B6                 sta   pmRowPtr
5937 8F49 A5 7A                 lda   strikePtr+2
5938 8F4B 90 01                 bcc   @NoCarry1
5939 8F4D 1A                    inc   a
5940 8F4E
5941 8F4E 85 B8        @NoCarry1 sta   pmRowPtr+2
5942 8F50              ;
5943 8F50 98                    tya                            ;retrieve char's rightmost pixel in FS
5944 8F51 29 0F 00              and   #last4Bits               ;position within pixelword
5945 8F54 0A                    asl   a
5946 8F55 AA                    tax   
5947 8F56 BF E2 5F FE           lda   >rightBitMask,x
5948 8F5A 85 A6                 sta   maskRight                ;masks out "garbage" to the right
5949 8F5C              ;
5950 8F5C              ;now do some of the same things for the buffer:
5951 8F5C A5 98                 lda   imagePen
5952 8F5E 4A                    lsr   a
5953 8F5F 4A                    lsr   a
5954 8F60 4A                    lsr   a
5955 8F61 29 FE FF              and   #first15Bits             ;offset within buffer
5956 8F64 AA                    tax                            ;temp. storage
5957 8F65              ;
5958 8F65              ;subtract bit-within-word positions (one for FS,
5959 8F65              ;one for buffer) to get shift amount
5960 8F65 A5 98                 lda   imagePen
5961 8F67 29 0F 00              and   #last4Bits
5962 8F6A 38                    sec   
5963 8F6B E5 2E                 sbc   startBit
5964 8F6D 10 06                 bpl   GoodShift
5965 8F6F              ;sinister shift - add 16 to shift amount (making it positive),
5966 8F6F              ;then compensate by subtracting two bytes from the buffer offset:
5967 8F6F 18                    clc   
5968 8F70 69 10 00              adc   #bitsInWord
5969 8F73 CA                    dex                            ;buffer offset in x
5970 8F74 CA                    dex   
5971 8F75              ;
5972 8F75              GoodShift                               ; 
5973 8F75 0A                    asl   a
5974 8F76 85 42                 sta   HowFarToShift
5975 8F78              ;
5976 8F78              ;tbRowPtr is to the buffer as pmRowPtr is to the font strike:
5977 8F78 8A                    txa                            ;buffer offset
5978 8F79 18                    clc   
5979 8F7A 65 AE                 adc   bufPtr
5980 8F7C 85 B2                 sta   tbRowPtr
5981 8F7E A5 B0                 lda   bufPtr+2
5982 8F80 90 01                 bcc   @NoCarry2
5983 8F82 1A                    inc   a
5984 8F83
5985 8F83 85 B4        @NoCarry2 sta   tbRowPtr+2
5986 8F85              ;
5987 8F85              ;set DBR to match current piece of text buffer:
5988 8F85 D4 B3                 pei   tbRowPtr+1
5989 8F87 AB                    plb   
5990 8F88 AB                    plb   
5991 8F89              ;
5992 8F89 A5 CA                 lda   chHeight
5993 8F8B 85 C8                 sta   rowCounter               ;prepare for leap into row loop
5994 8F8D              ;
5995 8F8D 98                    tya                            ;STILL rightmost pixel, BION
5996 8F8E 4A                    lsr   a
5997 8F8F 4A                    lsr   a
5998 8F90 4A                    lsr   a
5999 8F91 29 FE FF              and   #first15Bits             ;"endByte", like startByte
6000 8F94              ;
6001 8F94 38                    sec   
6002 8F95 E5 9C                 sbc   startByte                ;speaking of which . . . .
6003 8F97              ;we special-case characters which do not span more than 1 font strike word:
6004 8F97 D0 03                 bne   MoreThanAWord            ;not these
6005 8F99 82 69 00              brl   OnlyOneWord              ;but these
6006 8F9C              ;
6007 8F9C              ;[BHMNOTE:  nice place for a file break, if needed]
6008 8F9C              ;[BHMNOTE:  it will be, it will be]
6009 8F9C              ;
6010 8F9C              MoreThanAWord                           ; 
6011 8F9C              ;
6012 8F9C 85 EA                 sta   numOfBytes               ;even, and here >= 2
6013 8F9E              ;
6014 8F9E              NextRow                                 ; 
6015 8F9E              ;
6016 8F9E A0 00 00              ldy   #0
6017 8FA1              ;leftmost word in row:
6018 8FA1 A7 B6                 lda   [pmRowPtr]               ;get font strike word
6019 8FA3 25 A4                 and   maskLeft                 ;mask the garbage
6020 8FA5              ;no point shifting, OR'ing, and STA'ing a bunch of zeros:
6021 8FA5 F0 1E                 beq   NullWord
6022 8FA7              ;
6023 8FA7              NextWord                                ; 
6024 8FA7 85 9A                 sta   strikeWord
6025 8FA9 22 E3 4B FE           jsl   ShiftStay                ;rotate to match buffer
6026 8FAD 11 B2                 ora   (tbRowPtr),y             ;OR with current buffer
6027 8FAF 91 B2                 sta   (tbRowPtr),y             ;and replace
6028 8FB1              ;
6029 8FB1 A5 9A                 lda   strikeWord
6030 8FB3 22 6E 4C FE           jsl   ShiftOut                 ;to go into next buffer word
6031 8FB7 C8                    iny   
6032 8FB8 C8                    iny   
6033 8FB9 11 B2                 ora   (tbRowPtr),y
6034 8FBB 91 B2                 sta   (tbRowPtr),y
6035 8FBD              ;
6036 8FBD              CheckY                                  ; 
6037 8FBD              ;are we down to the last word in the row?
6038 8FBD C4 EA                 cpy   numOfBytes
6039 8FBF F0 08                 beq   RightMostWord            ;yes
6040 8FC1              ;nuhUH:
6041 8FC1 B7 B6                 lda   [pmRowPtr],y             ;pick up next font strike word
6042 8FC3 D0 E2                 bne   NextWord                 ;if it's worth looking at
6043 8FC5              NullWord                                ; ;it's not:
6044 8FC5 C8                    iny                            ;so try,
6045 8FC6 C8                    iny                            ;try
6046 8FC7 80 F4                 bra   CheckY                   ;again
6047 8FC9              ;
6048 8FC9              ;rightmost word in a row with 2 or more words:
6049 8FC9              RightMostWord                           ; 
6050 8FC9              ;
6051 8FC9 B7 B6                 lda   [pmRowPtr],y
6052 8FCB 25 A6                 and   maskRight
6053 8FCD F0 16                 beq   NullRightWord
6054 8FCF 85 9A                 sta   strikeWord
6055 8FD1 22 E3 4B FE           jsl   ShiftStay
6056 8FD5 11 B2                 ora   (tbRowPtr),y
6057 8FD7 91 B2                 sta   (tbRowPtr),y
6058 8FD9              ;
6059 8FD9 A5 9A                 lda   strikeWord
6060 8FDB 22 6E 4C FE           jsl   ShiftOut
6061 8FDF C8                    iny   
6062 8FE0 C8                    iny   
6063 8FE1 11 B2                 ora   (tbRowPtr),y
6064 8FE3 91 B2                 sta   (tbRowPtr),y
6065 8FE5              ;since that was the rightmost word, we must be at the end of a row:
6066 8FE5              NullRightWord                           ; 
6067 8FE5 C6 C8                 dec   rowCounter
6068 8FE7 F0 5F                 beq   CharDone                 ;end of all rows, for this char
6069 8FE9              ;update pointers:
6070 8FE9 A5 B2                 lda   tbRowPtr
6071 8FEB 18                    clc   
6072 8FEC 65 C4                 adc   bufRowBytes
6073 8FEE 85 B2                 sta   tbRowPtr
6074 8FF0 90 06                 bcc   NoCarry1
6075 8FF2 E6 B4                 inc   tbRowPtr+2               ;pointer high word changed, so
6076 8FF4 D4 B3                 pei   tbRowPtr+1               ;set new bank
6077 8FF6 AB                    plb   
6078 8FF7 AB                    plb   
6079 8FF8              NoCarry1                                ; 
6080 8FF8              ;
6081 8FF8 A5 B6                 lda   pmRowPtr
6082 8FFA 18                    clc   
6083 8FFB 65 86                 adc   rowBytes
6084 8FFD 85 B6                 sta   pmRowPtr
6085 8FFF 90 02                 bcc   NoCarry2
6086 9001 E6 B8                 inc   pmRowPtr+2
6087 9003              NoCarry2                                ; 
6088 9003 80 99                 bra   NextRow
6089 9005              ;
6090 9005              ;
6091 9005              OnlyOneWord                             ; 
6092 9005              ;special-case transfer for any character whose width
6093 9005              ;does not span a word boundary in the font strike
6094 9005              ;
6095 9005              ;it's like the general case, only less
6096 9005              ;
6097 9005 A5 A6                 lda   maskRight
6098 9007 25 A4                 and   maskLeft                 ;merge the masks
6099 9009 85 A4                 sta   maskLeft
6100 900B              ;
6101 900B A0 02 00              ldy   #2
6102 900E              ;
6103 900E              OOWNextRow                              ; 
6104 900E A7 B6                 lda   [pmRowPtr]
6105 9010 25 A4                 and   maskLeft
6106 9012 F0 14                 beq   OOWNullWord
6107 9014              ;
6108 9014 85 9A                 sta   strikeWord
6109 9016 22 E3 4B FE           jsl   ShiftStay
6110 901A 12 B2                 ora   (tbRowPtr)
6111 901C 92 B2                 sta   (tbRowPtr)
6112 901E              ;
6113 901E A5 9A                 lda   strikeWord
6114 9020 22 6E 4C FE           jsl   ShiftOut
6115 9024 11 B2                 ora   (tbRowPtr),y
6116 9026 91 B2                 sta   (tbRowPtr),y
6117 9028              ;
6118 9028              OOWNullWord                             ; 
6119 9028 C6 C8                 dec   rowCounter
6120 902A F0 1C                 beq   CharDone
6121 902C              ;
6122 902C A5 B2                 lda   tbRowPtr
6123 902E 18                    clc   
6124 902F 65 C4                 adc   bufRowBytes
6125 9031 85 B2                 sta   tbRowPtr
6126 9033 90 06                 bcc   NoCarry3
6127 9035 E6 B4                 inc   tbRowPtr+2
6128 9037 D4 B3                 pei   tbRowPtr+1
6129 9039 AB                    plb   
6130 903A AB                    plb   
6131 903B              NoCarry3                                ; 
6132 903B              ;
6133 903B A5 B6                 lda   pmRowPtr
6134 903D 18                    clc   
6135 903E 65 86                 adc   rowBytes
6136 9040 85 B6                 sta   pmRowPtr
6137 9042 90 02                 bcc   NoCarry4
6138 9044 E6 B8                 inc   pmRowPtr+2
6139 9046              NoCarry4                                ; 
6140 9046 80 C6                 bra   OOWNextRow
6141 9048              ;
6142 9048              ;
6143 9048              ;
6144 9048              ZeroWidth                               ; 
6145 9048              ;
6146 9048              CharDone                                ; ;ain't it da truth!
6147 9048 AB                    plb   
6148 9049 6B                    rtl   
6149 904A                       ENDP 
6150 904A              *****************************************
6151 904A              *                                       *
6152 904A              *  end of PutChar                       *
6153 904A              *                                       *
6154 904A              *****************************************
6155 904A              ;                copy text/textbufcalls
6156 904A              *****************************************
6157 904A              *                                       *
6158 904A              *  current date and time:               *
6159 904A              *    4:00 PM, 5/9/86                    *
6160 904A              *                                       *
6161 904A              *****************************************
6162 904A              ;
6163 904A              *******************************************************************************
6164 904A              *                                                                             *
6165 904A              *              subroutine SetTB                                               *
6166 904A              *                                                                             *
6167 904A              *                                        started 5/9/86                       *
6168 904A              *                                        Bennet Marks x6245                   *
6169 904A              *                                                                             *
6170 904A              *  ABSTRACT:  this subroutine sets the size of the text buffer.  It is 1 of 2 *
6171 904A              *  that replace SizeTextBuffer.  More documentation to follow.                *
6172 904A              *                                                                             *
6173 904A              *  ASSUMPTIONS:  the subroutine requires qwerty qwerty qwerty qwerty qwerty   *
6174 904A              *                                                                             *
6175 904A              *  RETURNS:  iamozymandiaskingofkingslokuponmyworksyemightyanddespair         *
6176 904A              *                                                                             *
6177 904A              *  NOTES: doe a deer a female deer ray a drop of golden sun me a name I call  *
6178 904A              *                                                                             *
6179 904A              *******************************************************************************
6180 904A              ;
6181 904A              *****************************************
6182 904A              *                                       *
6183 904A              *  V.0.1.0 - 5/9/86                     *
6184 904A              *                                       *
6185 904A              *****************************************
6186 904A              ;
6187 904A                       EXPORT iSetTB 
6188 904A              iSetTB   PROC 
6189 904A              *              USING E0Vectors
6190 904A              ;
6191 904A A5 56                 lda   ForcedFont               ;Set or Force?
6192 904C D0 0E                 bne   ForcedWidth
6193 904E              ;non-forced - apply the default mods:
6194 904E A5 52                 lda   NewMaxFontWidth          ;fontWidth
6195 9050 18                    clc   
6196 9051 65 52                 adc   NewMaxFontWidth
6197 9053 65 52                 adc   NewMaxFontWidth          ;times 3
6198 9055 69 24 00              adc   #36                      ;default to handle bold, italic
6199 9058 85 D2                 sta   fontTemp
6200 905A 80 04                 bra   GotFontWidth
6201 905C              ;
6202 905C              ForcedWidth                             ; 
6203 905C A5 52                 lda   NewMaxFontWidth
6204 905E 85 D2                 sta   fontTemp
6205 9060              GotFontWidth                            ; 
6206 9060              ;
6207 9060 A5 D2                 lda   fontTemp
6208 9062 1A                    inc   a
6209 9063 18                    clc   
6210 9064 65 28                 adc   maxWidth
6211 9066 0A                    asl   a
6212 9067 0A                    asl   a
6213 9068              ;the number in the acc. is our good-guess at the number of pixels
6214 9068              ;needed across in the font buffer - may be changed later
6215 9068              ;
6216 9068 4A                    lsr   a
6217 9069 4A                    lsr   a
6218 906A 4A                    lsr   a
6219 906B 29 FE FF              and   #first15bits             ;in bytes
6220 906E 85 C4                 sta   bufRowBytes              ;useful though temp. here
6221 9070              ;
6222 9070 F4 00 00 F4           PushLong #0                    ;for result of mult.
6223 9076 D4 C4                 pei   bufRowBytes
6224 9078 D4 50                 pei   newTBHeight
6225 907A              ;
6226 907A A2 0B 09 22           _Multiply 
6227 9081              ;
6228 9081 D4 46                 pei   textBufHandle+2
6229 9083 D4 44                 pei   textBufHandle
6230 9085              ;
6231 9085 A2 02 19 22           _SetHandleSize 
6232 908C              ;
6233 908C 90 01                 bcc   NoMemErr
6234 908E              ;memory error - carry is set, err # is in acc.:
6235 908E 6B                    rtl   
6236 908F              ;
6237 908F              NoMemErr                                ; 
6238 908F              ;
6239 908F              ;install new values:
6240 908F A5 50                 lda   NewTBHeight
6241 9091 85 4A                 sta   textBufHeight
6242 9093 A5 C4                 lda   bufRowBytes
6243 9095 4A                    lsr   a
6244 9096 85 48                 sta   textBufRowWords
6245 9098 A5 56                 lda   ForcedFont
6246 909A D0 0A                 bne   SetForced
6247 909C              ;make sure we know it's not forced:
6248 909C A9 00 00              lda   #0
6249 909F A2 00 01              ldx   #256
6250 90A2 95 04                 sta   fontWidth,x
6251 90A4 80 07                 bra   FWSet
6252 90A6              ;
6253 90A6              SetForced                               ; 
6254 90A6 A5 52                 lda   newMaxFontWidth
6255 90A8 A2 00 01              ldx   #256
6256 90AB 95 04                 sta   fontWidth,x
6257 90AD              ;
6258 90AD              FWSet                                   ; 
6259 90AD              ;
6260 90AD              ;set up for call to ClearBufPart:
6261 90AD A6 46                 ldx   textBufHandle+2
6262 90AF A5 44                 lda   textBufHandle
6263 90B1 20 BD 85              jsr   TextDeref
6264 90B4              ;
6265 90B4 86 B0                 stx   bufPtr+2
6266 90B6 85 AE                 sta   bufPtr
6267 90B8              ;
6268 90B8 64 CE                 stz   leftExtent
6269 90BA A5 48                 lda   textBufRowWords
6270 90BC 3A                    dec   a
6271 90BD 85 D0                 sta   rightExtent
6272 90BF A5 4A                 lda   textBufHeight
6273 90C1 85 CA                 sta   chHeight                 ;to fool ClearBufPart
6274 90C3              ;
6275 90C3 22 70 1F E0           jsl   ClearBufPart
6276 90C7              ;
6277 90C7              ;
6278 90C7 18                    clc                            ;no error to report
6279 90C8 A9 00 00              lda   #0
6280 90CB              ;
6281 90CB 6B                    rtl   
6282 90CC                       ENDP 
6283 90CC              *****************************************
6284 90CC              *                                       *
6285 90CC              *  end of SetTB                         *
6286 90CC              *                                       *
6287 90CC              *****************************************
6288 90CC              ;
6289 90CC              ;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
6290 90CC              ;
6291 90CC              *****************************************
6292 90CC              *                                       *
6293 90CC              *  current date and time:               *
6294 90CC              *    4:30 PM, 5/9/86                    *
6295 90CC              *                                       *
6296 90CC              *****************************************
6297 90CC              ;
6298 90CC              *******************************************************************************
6299 90CC              *                                                                             *
6300 90CC              *              subroutine ResetTB                                             *
6301 90CC              *                                                                             *
6302 90CC              *                                        started 5/9/86                       *
6303 90CC              *                                        Bennet Marks x6245                   *
6304 90CC              *                                                                             *
6305 90CC              *  ABSTRACT:  documentation to follow                                         *
6306 90CC              *                                                                             *
6307 90CC              *  ASSUMPTIONS:  the subroutine requires qwerty qwerty qwerty qwerty qwerty   *
6308 90CC              *                                                                             *
6309 90CC              *  RETURNS:  iamozymandiaskingofkingslokuponmyworksyemightyanddespair         *
6310 90CC              *                                                                             *
6311 90CC              *  NOTES: doe a deer a female deer ray a drop of golden sun me a name I call  *
6312 90CC              *                                                                             *
6313 90CC              *******************************************************************************
6314 90CC              ;
6315 90CC              *****************************************
6316 90CC              *                                       *
6317 90CC              *  V.0.1.0 - 5/9/86                     *
6318 90CC              *                                       *
6319 90CC              *****************************************
6320 90CC              ;
6321 90CC                       EXPORT iResetTB 
6322 90CC              iResetTB PROC 
6323 90CC              *              USING E0Vectors
6324 90CC              ;
6325 90CC F4 00 00 F4           PushLong #0                    ;for multiply result
6326 90D2              ;
6327 90D2 A5 54                 lda   newTBRowWords
6328 90D4 0A                    asl   a
6329 90D5 85 C4                 sta   bufRowBytes
6330 90D7 48                    pha   
6331 90D8              ;
6332 90D8 D4 50                 pei   NewTBHeight
6333 90DA              ;
6334 90DA A2 0B 09 22           _Multiply 
6335 90E1              ;
6336 90E1 D4 46                 pei   textBufHandle+2
6337 90E3 D4 44                 pei   textBufHandle
6338 90E5              ;
6339 90E5 A2 02 19 22           _SetHandleSize 
6340 90EC              ;
6341 90EC 90 01                 bcc   NoMemErr
6342 90EE              ;there was a mem error - carry set, number in acc.
6343 90EE 6B                    rtl   
6344 90EF              ;
6345 90EF              NoMemErr                                ; 
6346 90EF              ;
6347 90EF              ;install new values:
6348 90EF A5 50                 lda   NewTBHeight
6349 90F1 85 4A                 sta   textBufHeight
6350 90F3 A5 54                 lda   newTBRowWords
6351 90F5 85 48                 sta   textBufRowWords
6352 90F7 A5 56                 lda   newFontWidth
6353 90F9 A2 00 01              ldx   #256
6354 90FC 95 04                 sta   fontWidth,x
6355 90FE              ;
6356 90FE              ;set up for call to ClearBufPart:
6357 90FE A6 46                 ldx   textBufHandle+2
6358 9100 A5 44                 lda   textBufHandle
6359 9102 20 BD 85              jsr   TextDeref
6360 9105              ;
6361 9105 86 B0                 stx   bufPtr+2
6362 9107 85 AE                 sta   bufPtr
6363 9109              ;
6364 9109 64 CE                 stz   leftExtent
6365 910B A5 48                 lda   textBufRowWords
6366 910D 3A                    dec   a
6367 910E 85 D0                 sta   rightExtent
6368 9110 A5 4A                 lda   textBufHeight
6369 9112 85 CA                 sta   chHeight                 ;to fool ClearBufPart
6370 9114              ;
6371 9114 22 70 1F E0           jsl   ClearBufPart
6372 9118              ;
6373 9118              ;
6374 9118 18                    clc                            ;no error to report
6375 9119 A9 00 00              lda   #0
6376 911C              ;
6377 911C 6B                    rtl   
6378 911D                       ENDP 
6379 911D              *****************************************
6380 911D              *                                       *
6381 911D              *  end of ResetTB                       *
6382 911D              *                                       *
6383 911D              *****************************************
6384 911D              ;                copy text/blowitup
6385 911D              ****************************************************************
6386 911D              *
6387 911D              * BlowItUp
6388 911D              *
6389 911D              * This is the routine that takes the 1-bit per pixel text
6390 911D              * image in the text buffer and paints it to the destination
6391 911D              * bit map as 2 or 4 bits per pixel with the right
6392 911D              * foreground and background color in the right text mode.
6393 911D              *
6394 911D              * Several modes are supported as follows
6395 911D              *
6396 911D              *        Mode
6397 911D              *        Code
6398 911D              *         0    Copies foreground and background into destination
6399 911D              *         1    OR's foreground and background with destination
6400 911D              *         2    XOR's foreground and background with destination
6401 911D              *         3    BIC's foreground and background with destination
6402 911D              *         4    Copies only the foreground into the destination
6403 911D              *              (background is untouched).
6404 911D              *         5    OR's foreground into destination (background is
6405 911D              *              untouched).
6406 911D              *         6    XOR's foreground into destination (background is
6407 911D              *              untouched).
6408 911D              *         7    BIC's foreground into destination (background is
6409 911D              *              untouched).
6410 911D              *
6411 911D              * Each mode is acheived by its own handler.  The first part of SetItUp
6412 911D              * puts the vector to the handler in the current JMP vector location
6413 911D              * in bank E0.
6414 911D              *
6415 911D              * There is no left and right mask as I rely on the MinRect to
6416 911D              * be set up correctly.  The right MinRect means that the left
6417 911D              * and right mask are already incorporated in the scan line
6418 911D              * buffer.
6419 911D              *
6420 911D              * Variables On zero page that I use are:
6421 911D              *
6422 911D              *     CurPMByte      ; a pointer in the inner loop of BlowItUp
6423 911D              *     CurTBByte      ; a pointer in the inner loop of BlowItUP
6424 911D              *     WordCounter    ; counter in the inner loop of BlowItUp
6425 911D              *     FG             ; local copy of foreground color
6426 911D              *     BG             ; local copy of background color
6427 911D              *     TextMode       ; local copy of text mode
6428 911D              *
6429 911D              * Change History
6430 911D              *
6431 911D              * 18 Feb 87    Steven Glass
6432 911D              *
6433 911D              * Using font flag 2 (counting from zero) we decide if we should
6434 911D              * force the text color to be adjusted or not.  When I adjust
6435 911D              * the color I call ExtendColorWord which copies the lowest
6436 911D              * pixel into the other pixels of the word.  When I don't make
6437 911D              * this call, the programmer can have dithered color text in
6438 911D              * 640 mode or multi colored text (a vertical striped pattern)
6439 911D              * in any mode.
6440 911D              *
6441 911D              ****************************************************************
6442 911D                       EXPORT iBlowItUp 
6443 911D              iBlowItUp PROC 
6444 911D              *              using CoreDATA
6445 911D              *              using E0Vectors
6446 911D
6447 911D
6448 911D              ;-----------------------------------------------
6449 911D              ;
6450 911D              ; First setup the ToStuffBig vector based on the
6451 911D              ; text mode.
6452 911D              ;
6453 911D A0 82 00              ldy   #o_txmode
6454 9120 B7 24                 lda   [PortRef],y
6455 9122 85 30                 sta   TextMode
6456 9124
6457 9124 22 F0 1E E0           jsl   SetStuffAdr
6458 9128
6459 9128              ;----------------------------------------------------------
6460 9128              ;
6461 9128              ; Check font flag 2 (numbered from zero) to see if the
6462 9128              ; programmer wants me to force the color to be right or if
6463 9128              ; s/he wants me to use the foreground and background colors
6464 9128              ; as they are passed in the port.
6465 9128              ;
6466 9128
6467 9128 64 2A                 stz   Temp
6468 912A A0 7C 00              ldy   #o_FontFlags
6469 912D B7 24                 lda   [PortRef],y
6470 912F 29 04 00              and   #%0000000000000100
6471 9132 F0 02                 beq   NotSpecial
6472 9134 C6 2A                 dec   Temp
6473 9136              NotSpecial                              ; 
6474 9136
6475 9136 A0 8C 00              ldy   #o_FGColor
6476 9139 B7 24                 lda   [PortRef],y
6477 913B 24 2A                 bit   Temp
6478 913D 30 06                 bmi   UseAsIs1
6479 913F AA                    tax   
6480 9140 A5 0C                 lda   PortSCB
6481 9142 20 96 1B              jsr   ExtendColorWord
6482 9145 85 2E        UseAsIs1 sta   FG
6483 9147
6484 9147 A0 8E 00              ldy   #o_BGColor
6485 914A B7 24                 lda   [PortRef],y
6486 914C 24 2A                 bit   temp
6487 914E 30 06                 bmi   UseAsIs2
6488 9150 AA                    tax   
6489 9151 A5 0C                 lda   PortSCB
6490 9153 20 96 1B              jsr   ExtendColorWord
6491 9156 85 BE        UseAsIs2 sta   BG
6492 9158
6493 9158 22 C0 1E E0           jsl   Init2Regions
6494 915C A5 00                 lda   MinRect
6495 915E 85 40                 sta   CurrentY
6496 9160
6497 9160 22 98 1E E0           jsl   ShieldCursor
6498 9164
6499 9164 A5 30                 lda   TextMode
6500 9166 29 FF 7F              and   #$7FFF
6501 9169 C9 04 00              cmp   #4
6502 916C B0 03                 bcs   FastBigLoop
6503 916E 4C 33 92              jmp   SlowBigLoop
6504 9171
6505 9171                       ENDP 
6506 9171
6507 9171
6508 9171              ****************************************************************
6509 9171              *
6510 9171              * FastBigLoop
6511 9171              *
6512 9171              * The FastBigLoop can only be used for the foreground xfer
6513 9171              * modes.  The major difference between fast and slow is that
6514 9171              * in the fast loop we check each word, if it is zero, we bypass
6515 9171              * the stuff big code.  This saves lots of time.
6516 9171              *
6517 9171              ****************************************************************
6518 9171                       EXPORT FastBigLoop 
6519 9171              FastBigLoop PROC 
6520 9171              *              using CoreDATA
6521 9171              *              using E0Vectors
6522 9171
6523 9171 A5 A4                 lda   NonRectRegions
6524 9173 D0 04                 bne   BigLoop
6525 9175 22 CC 1E E0           jsl   Seek2Regions
6526 9179
6527 9179
6528 9179              BigLoop                                 ; 
6529 9179
6530 9179 A5 C6                 lda   NumOfWords               ; set up the counters that the
6531 917B 85 CC                 sta   WordCounter              ; inner loop uses
6532 917D A5 BA                 lda   tbStartByte
6533 917F 85 2C                 sta   CurTBByte
6534 9181 A5 BC                 lda   pmStartByte
6535 9183 85 2A                 sta   CurPMByte
6536 9185
6537 9185 A5 A4                 lda   NonRectRegions
6538 9187 F0 04                 beq   SkipSeek
6539 9189
6540 9189 22 CC 1E E0           jsl   Seek2Regions
6541 918D
6542 918D              SkipSeek                                ; 
6543 918D              ;------------------------------------------------------
6544 918D              ;
6545 918D              ; See which of the inner loops I should use.
6546 918D              ;
6547 918D 24 30                 bit   TextMode
6548 918F 30 60                 bmi   InvertLoop
6549 9191
6550 9191 24 0B                 bit   PortSCB-1
6551 9193 30 2E                 bmi   Loop640
6552 9195
6553 9195              Loop320                                 ; ; this loop is for standard xfer modes
6554 9195 A4 2C                 ldy   CurTBByte
6555 9197 B7 B2                 lda   [tbRowPtr],y             ; waste 2 cycles here to see if shortcut
6556 9199 F0 16                 beq   NoBother320              ; is available.
6557 919B 22 00 1E E0           jsl   ToStuffBig
6558 919F A4 2C                 ldy   CurTBByte
6559 91A1 C8                    iny   
6560 91A2 B7 B2                 lda   [tbRowPtr],y
6561 91A4 C8                    iny   
6562 91A5 84 2C                 sty   CurTBByte
6563 91A7 22 00 1E E0           jsl   ToStuffBig
6564 91AB C6 CC                 dec   WordCounter
6565 91AD 10 E6                 bpl   Loop320
6566 91AF 80 5E                 bra   NextRow
6567 91B1
6568 91B1
6569 91B1              NoBother320                             ; 
6570 91B1 C8                    iny                            ; bump y and store it for next
6571 91B2 C8                    iny                            ; time around.
6572 91B3 84 2C                 sty   CurTBByte
6573 91B5 A5 2A                 lda   CurPMByte                ; add eight since we did not get
6574 91B7 18                    clc                            ; to go off to stuff big twice where
6575 91B8 69 08 00              adc   #8                       ; this would happen
6576 91BB 85 2A                 sta   CurPMByte
6577 91BD C6 CC                 dec   WordCounter
6578 91BF 10 D4                 bpl   Loop320
6579 91C1 80 4C                 bra   NextRow
6580 91C3
6581 91C3
6582 91C3              Loop640                                 ; ; this loop is for standard xfer modes
6583 91C3 A4 2C                 ldy   CurTBByte
6584 91C5 B7 B2                 lda   [tbRowPtr],y             ; waste 2 cycles here to see if shortcut
6585 91C7 F0 16                 beq   NoBother640              ; is available.
6586 91C9 22 00 1E E0           jsl   ToStuffBig
6587 91CD A4 2C                 ldy   CurTBByte
6588 91CF C8                    iny   
6589 91D0 B7 B2                 lda   [tbRowPtr],y
6590 91D2 C8                    iny   
6591 91D3 84 2C                 sty   CurTBByte
6592 91D5 22 00 1E E0           jsl   ToStuffBig
6593 91D9 C6 CC                 dec   WordCounter
6594 91DB 10 E6                 bpl   Loop640
6595 91DD 80 30                 bra   NextRow
6596 91DF
6597 91DF
6598 91DF              NoBother640                             ; 
6599 91DF C8                    iny                            ; bump y and store it for next
6600 91E0 C8                    iny                            ; time around.
6601 91E1 84 2C                 sty   CurTBByte
6602 91E3 A5 2A                 lda   CurPMByte                ; bump this 4 times by moving to
6603 91E5 1A                    inc   a                        ; reg to speed it up
6604 91E6 1A                    inc   a
6605 91E7 1A                    inc   a
6606 91E8 1A                    inc   a
6607 91E9 85 2A                 sta   CurPMByte                ; store it back out
6608 91EB C6 CC                 dec   WordCounter
6609 91ED 10 D4                 bpl   Loop640
6610 91EF 80 1E                 bra   NextRow
6611 91F1
6612 91F1
6613 91F1
6614 91F1
6615 91F1
6616 91F1              InvertLoop                              ; ; this loop is for the NOT xfer modes
6617 91F1 A4 2C                 ldy   CurTBByte
6618 91F3 B7 B2                 lda   [tbRowPtr],y
6619 91F5 49 FF FF              eor   #$FFFF
6620 91F8 22 00 1E E0           jsl   ToStuffBig
6621 91FC A4 2C                 ldy   CurTBByte
6622 91FE C8                    iny   
6623 91FF B7 B2                 lda   [tbRowPtr],y
6624 9201 49 FF FF              eor   #$FFFF
6625 9204 C8                    iny   
6626 9205 84 2C                 sty   CurTBByte
6627 9207 22 00 1E E0           jsl   ToStuffBig
6628 920B C6 CC                 dec   WordCounter
6629 920D 10 E2                 bpl   InvertLoop
6630 920F
6631 920F
6632 920F
6633 920F              NextRow                                 ; 
6634 920F A5 B2                 lda   tbRowPtr
6635 9211 18                    clc   
6636 9212 65 C4                 adc   BufRowBytes
6637 9214 85 B2                 sta   tbRowPtr
6638 9216 90 02                 bcc   NoCarry1
6639 9218 E6 B4                 inc   tbRowPtr+2
6640 921A              NoCarry1                                ; 
6641 921A
6642 921A A5 B6                 lda   pmRowPtr
6643 921C 18                    clc   
6644 921D 65 12                 adc   Width
6645 921F 85 B6                 sta   pmRowPtr
6646 9221 90 02                 bcc   NoCarry2
6647 9223 E6 B8                 inc   pmRowPtr+2
6648 9225              NoCarry2                                ; 
6649 9225
6650 9225 E6 40                 inc   CurrentY
6651 9227
6652 9227 C6 C8                 dec   RowCounter
6653 9229 30 03                 bmi   AllDone
6654 922B 4C 79 91              jmp   BigLoop
6655 922E
6656 922E 22 9C 1E E0  AllDone  jsl   UnShieldCursor
6657 9232
6658 9232 6B                    rtl   
6659 9233
6660 9233                       ENDP 
6661 9233
6662 9233
6663 9233
6664 9233
6665 9233              ****************************************************************
6666 9233              *
6667 9233              * SlowBigLoop
6668 9233              *
6669 9233              * SlowBigLoop is used when the foreground and background are
6670 9233              * transfered.  The major difference between fast and slow is that
6671 9233              * in the fast loop we check each word, if it is zero, we bypass
6672 9233              * the stuff big code.  This saves lots of time.  Here we bypass
6673 9233              * nothing.
6674 9233              *
6675 9233              ****************************************************************
6676 9233                       EXPORT SlowBigLoop 
6677 9233              SlowBigLoop PROC 
6678 9233              *              using CoreDATA
6679 9233              *              using E0Vectors
6680 9233
6681 9233
6682 9233              BigLoop                                 ; 
6683 9233 A5 C6                 lda   NumOfWords               ; set up the counters that the
6684 9235 85 CC                 sta   WordCounter              ; inner loop uses
6685 9237 A5 BA                 lda   tbStartByte
6686 9239 85 2C                 sta   CurTBByte
6687 923B A5 BC                 lda   pmStartByte
6688 923D 85 2A                 sta   CurPMByte
6689 923F
6690 923F 22 CC 1E E0           jsl   Seek2Regions
6691 9243
6692 9243
6693 9243              ;------------------------------------------------------
6694 9243              ;
6695 9243              ; See which of the two inner loops I should use.
6696 9243              ;
6697 9243 24 30                 bit   TextMode
6698 9245 30 1A                 bmi   InvertLoop
6699 9247
6700 9247              Loop                                    ; ; this loop is for standard xfer modes
6701 9247 A4 2C                 ldy   CurTBByte
6702 9249 B7 B2                 lda   [tbRowPtr],y
6703 924B 22 00 1E E0           jsl   ToStuffBig
6704 924F A4 2C                 ldy   CurTBByte
6705 9251 C8                    iny   
6706 9252 B7 B2                 lda   [tbRowPtr],y
6707 9254 C8                    iny   
6708 9255 84 2C                 sty   CurTBByte
6709 9257 22 00 1E E0           jsl   ToStuffBig
6710 925B C6 CC                 dec   WordCounter
6711 925D 10 E8                 bpl   Loop
6712 925F 80 1E                 bra   NextRow
6713 9261
6714 9261
6715 9261              InvertLoop                              ; ; this loop is for the NOT xfer modes
6716 9261 A4 2C                 ldy   CurTBByte
6717 9263 B7 B2                 lda   [tbRowPtr],y
6718 9265 49 FF FF              eor   #$FFFF
6719 9268 22 00 1E E0           jsl   ToStuffBig
6720 926C A4 2C                 ldy   CurTBByte
6721 926E C8                    iny   
6722 926F B7 B2                 lda   [tbRowPtr],y
6723 9271 49 FF FF              eor   #$FFFF
6724 9274 C8                    iny   
6725 9275 84 2C                 sty   CurTBByte
6726 9277 22 00 1E E0           jsl   ToStuffBig
6727 927B C6 CC                 dec   WordCounter
6728 927D 10 E2                 bpl   InvertLoop
6729 927F
6730 927F
6731 927F
6732 927F              NextRow                                 ; 
6733 927F A5 B2                 lda   tbRowPtr
6734 9281 18                    clc   
6735 9282 65 C4                 adc   BufRowBytes
6736 9284 85 B2                 sta   tbRowPtr
6737 9286 90 02                 bcc   NoCarry1
6738 9288 E6 B4                 inc   tbRowPtr+2
6739 928A              NoCarry1                                ; 
6740 928A
6741 928A A5 B6                 lda   pmRowPtr
6742 928C 18                    clc   
6743 928D 65 12                 adc   Width
6744 928F 85 B6                 sta   pmRowPtr
6745 9291 90 02                 bcc   NoCarry2
6746 9293 E6 B8                 inc   pmRowPtr+2
6747 9295              NoCarry2                                ; 
6748 9295
6749 9295 E6 40                 inc   CurrentY
6750 9297
6751 9297 C6 C8                 dec   RowCounter
6752 9299 10 98                 bpl   BigLoop
6753 929B
6754 929B 22 9C 1E E0           jsl   UnShieldCursor
6755 929F
6756 929F 6B                    rtl   
6757 92A0
6758 92A0                       ENDP 
6759 92A0
6760 92A0
6761 92A0              ****************************************************************
6762 92A0              *
6763 92A0              * Text640ModeTable
6764 92A0              *
6765 92A0              * This is a table of jml vectors that will transfer control
6766 92A0              * back to the appropriate stuffbig routine.
6767 92A0              *
6768 92A0              ****************************************************************
6769 92A0                       EXPORT Text640ModeTable 
6770 92A0              Text640ModeTable PROC 
6771 92A0
6772 92A0 5C 6B 93 FE           jml   StuffBig0640
6773 92A4 5C DA 93 FE           jml   StuffBig1640
6774 92A8 5C 3C 94 FE           jml   StuffBig2640
6775 92AC 5C A4 94 FE           jml   StuffBig3640
6776 92B0 5C 11 95 FE           jml   StuffBig4640
6777 92B4 5C 62 95 FE           jml   StuffBig5640
6778 92B8 5C A4 95 FE           jml   StuffBig6640
6779 92BC 5C EC 95 FE           jml   StuffBig7640
6780 92C0
6781 92C0                       ENDP 
6782 92C0
6783 92C0              ****************************************************************
6784 92C0              *
6785 92C0              * Text320ModeTable
6786 92C0              *
6787 92C0              * This is a table of jml vectors that will transfer control
6788 92C0              * back to the appropriate stuffbig routine.
6789 92C0              *
6790 92C0              ****************************************************************
6791 92C0                       EXPORT Text320ModeTable 
6792 92C0              Text320ModeTable PROC 
6793 92C0
6794 92C0 5C 12 93 FE           jml   StuffBig0320
6795 92C4 5C 9B 93 FE           jml   StuffBig1320
6796 92C8 5C FD 93 FE           jml   StuffBig2320
6797 92CC 5C 5F 94 FE           jml   StuffBig3320
6798 92D0 5C CA 94 FE           jml   StuffBig4320
6799 92D4 5C 38 95 FE           jml   StuffBig5320
6800 92D8 5C 7A 95 FE           jml   StuffBig6320
6801 92DC 5C BC 95 FE           jml   StuffBig7320
6802 92E0
6803 92E0                       ENDP 
6804 92E0
6805 92E0
6806 92E0
6807 92E0              ****************************************************************
6808 92E0              *
6809 92E0              * SetStuffAdr
6810 92E0              *
6811 92E0              ****************************************************************
6812 92E0                       EXPORT iSetStuffAdr 
6813 92E0              iSetStuffAdr PROC 
6814 92E0              *              using E0Vectors
6815 92E0
6816 92E0 24 0B                 bit   PortSCB-1
6817 92E2 10 17                 bpl   Mode320
6818 92E4
6819 92E4 29 7F 00              and   #$7F
6820 92E7 0A                    asl   a
6821 92E8 0A                    asl   a
6822 92E9 AA                    tax   
6823 92EA BF A0 92 FE           lda   >Text640ModeTable,x
6824 92EE 8F 00 1E E0           sta   >ToStuffBig
6825 92F2 BF A2 92 FE           lda   >Text640ModeTable+2,x
6826 92F6 8F 02 1E E0           sta   >ToStuffBig+2
6827 92FA
6828 92FA 6B                    rtl   
6829 92FB
6830 92FB 29 7F 00     Mode320  and   #$7F
6831 92FE 0A                    asl   a
6832 92FF 0A                    asl   a
6833 9300 AA                    tax   
6834 9301 BF C0 92 FE           lda   >Text320ModeTable,x
6835 9305 8F 00 1E E0           sta   >ToStuffBig
6836 9309 BF C2 92 FE           lda   >Text320ModeTable+2,x
6837 930D 8F 02 1E E0           sta   >ToStuffBig+2
6838 9311
6839 9311 6B                    rtl   
6840 9312                       ENDP 
6841 9312              ;                copy text/stuffbig0
6842 9312              ****************************************************************
6843 9312              *
6844 9312              * StuffBig0
6845 9312              *
6846 9312              * This is the routine that copies into the destination
6847 9312              * coloring the forground and background.
6848 9312              *
6849 9312              ****************************************************************
6850 9312                       EXPORT StuffBig0320 
6851 9312              StuffBig0320 PROC 
6852 9312
6853 9312 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
6854 9315 0A                    asl   a                        ; quadruple the value so can index
6855 9316 0A                    asl   a                        ; into conversion table
6856 9317 AA                    tax   
6857 9318 BF 74 63 FE           lda   >ConTable320+2,x
6858 931C A8                    tay   
6859 931D BF 72 63 FE           lda   >ConTable320,x
6860 9321 BB                    tyx   
6861 9322
6862 9322 A8                    tay                            ; save copy in y
6863 9323 25 2E                 and   FG                       ; now the foreground pixels are colored
6864 9325 85 C0                 sta   tempFG                   ; save it here
6865 9327 98                    tya                            ; get back orig
6866 9328 49 FF FF              eor   #$FFFF                   ; invert it
6867 932B 25 BE                 and   BG                       ; now the background pixels are colored
6868 932D 05 C0                 ora   tempFG
6869 932F 85 C0                 sta   tempFG                   ; this has rightly colored word
6870 9331
6871 9331 A4 2A                 ldy   CurPMByte                ; get index to dest
6872 9333 B7 4C                 lda   [ScanMaskRef],y          ; get mask for this scan line
6873 9335 49 FF FF              eor   #$FFFF                   ; invert it
6874 9338 37 B6                 and   [pmRowPtr],y             ; and with orig dest
6875 933A 85 C2                 sta   NotMaskAndDest           ; save this here
6876 933C B7 4C                 lda   [ScanMaskRef],y          ; get mask back
6877 933E 25 C0                 and   tempFG                   ; and with rightly colored word
6878 9340 05 C2                 ora   NotMaskAndDest           ; or with burned out dest
6879 9342 97 B6                 sta   [pmRowPtr],y             ; and put it back!
6880 9344
6881 9344 C8                    iny   
6882 9345 C8                    iny   
6883 9346 8A                    txa   
6884 9347 25 2E                 and   FG                       ; now the foreground pixels are colored
6885 9349 85 C0                 sta   tempFG                   ; save it here
6886 934B 8A                    txa                            ; get back orig
6887 934C 49 FF FF              eor   #$FFFF                   ; invert it
6888 934F 25 BE                 and   BG                       ; now the background pixels are colored
6889 9351 05 C0                 ora   tempFG
6890 9353 85 C0                 sta   tempFG                   ; this has rightly colored word
6891 9355
6892 9355 B7 4C                 lda   [ScanMaskRef],y          ; get mask for this scan line
6893 9357 49 FF FF              eor   #$FFFF                   ; invert it
6894 935A 37 B6                 and   [pmRowPtr],y             ; and with orig dest
6895 935C 85 C2                 sta   NotMaskAndDest           ; save this here
6896 935E B7 4C                 lda   [ScanMaskRef],y          ; get mask back
6897 9360 25 C0                 and   tempFG                   ; and with rightly colored word
6898 9362 05 C2                 ora   NotMaskAndDest           ; or with burned out dest
6899 9364 97 B6                 sta   [pmRowPtr],y             ; and put it back!
6900 9366
6901 9366 C8                    iny   
6902 9367 C8                    iny   
6903 9368 84 2A                 sty   CurPMByte
6904 936A
6905 936A 6B                    rtl   
6906 936B
6907 936B                       EXPORT StuffBig0640 
6908 936B              StuffBig0640                            ; 
6909 936B 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
6910 936E 0A                    asl   a                        ; double the value so can index
6911 936F              *			; into conversion table
6912 936F AA                    tax   
6913 9370 BF 72 67 FE           lda   >ConTable640,x
6914 9374
6915 9374
6916 9374 A8                    tay                            ; save copy in y
6917 9375 25 2E                 and   FG                       ; now the foreground pixels are colored
6918 9377 85 C0                 sta   tempFG                   ; save it here
6919 9379 98                    tya                            ; get back orig
6920 937A 49 FF FF              eor   #$FFFF                   ; invert it
6921 937D 25 BE                 and   BG                       ; now the background pixels are colored
6922 937F 05 C0                 ora   tempFG
6923 9381 85 C0                 sta   tempFG                   ; this has rightly colored word
6924 9383
6925 9383 A4 2A                 ldy   CurPMByte                ; get index to dest
6926 9385 B7 4C                 lda   [ScanMaskRef],y          ; get mask for this scan line
6927 9387 49 FF FF              eor   #$FFFF                   ; invert it
6928 938A 37 B6                 and   [pmRowPtr],y             ; and with orig dest
6929 938C 85 C2                 sta   NotMaskAndDest           ; save this here
6930 938E B7 4C                 lda   [ScanMaskRef],y          ; get mask back
6931 9390 25 C0                 and   tempFG                   ; and with rightly colored word
6932 9392 05 C2                 ora   NotMaskAndDest           ; or with burned out dest
6933 9394 97 B6                 sta   [pmRowPtr],y             ; and put it back!
6934 9396
6935 9396 C8                    iny   
6936 9397 C8                    iny   
6937 9398 84 2A                 sty   CurPMByte
6938 939A
6939 939A 6B                    rtl   
6940 939B
6941 939B                       ENDP 
6942 939B              ;                copy text/stuffbig1
6943 939B              ****************************************************************
6944 939B              *
6945 939B              * StuffBig1
6946 939B              *
6947 939B              * This is the routine that ORs into the destination
6948 939B              * coloring the forground and background.
6949 939B              *
6950 939B              ****************************************************************
6951 939B                       EXPORT StuffBig1320 
6952 939B              StuffBig1320 PROC 
6953 939B
6954 939B 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
6955 939E 0A                    asl   a                        ; quadruple the value so can index
6956 939F 0A                    asl   a                        ; into conversion table
6957 93A0 AA                    tax   
6958 93A1 BF 74 63 FE           lda   >ConTable320+2,x
6959 93A5 A8                    tay   
6960 93A6 BF 72 63 FE           lda   >ConTable320,x
6961 93AA BB                    tyx   
6962 93AB
6963 93AB A8                    tay                            ; save copy in y
6964 93AC 25 2E                 and   FG                       ; now the foreground pixels are colored
6965 93AE 85 C0                 sta   tempFG                   ; save it here
6966 93B0 98                    tya                            ; get back orig
6967 93B1 49 FF FF              eor   #$FFFF                   ; invert it
6968 93B4 25 BE                 and   BG                       ; now the background pixels are colored
6969 93B6 05 C0                 ora   tempFG                   ; a now has rightly colored word
6970 93B8
6971 93B8 A4 2A                 ldy   CurPMByte                ; get index to dest
6972 93BA 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
6973 93BC 17 B6                 ora   [pmRowPtr],y             ; or with orig dest
6974 93BE 97 B6                 sta   [pmRowPtr],y             ; and put it back!
6975 93C0
6976 93C0 C8                    iny   
6977 93C1 C8                    iny   
6978 93C2 8A                    txa   
6979 93C3 25 2E                 and   FG                       ; now the foreground pixels are colored
6980 93C5 85 C0                 sta   tempFG                   ; save it here
6981 93C7 8A                    txa                            ; get back orig
6982 93C8 49 FF FF              eor   #$FFFF                   ; invert it
6983 93CB 25 BE                 and   BG                       ; now the background pixels are colored
6984 93CD 05 C0                 ora   tempFG                   ; this has rightly colored word
6985 93CF
6986 93CF 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
6987 93D1 17 B6                 ora   [pmRowPtr],y             ; or original destination
6988 93D3 97 B6                 sta   [pmRowPtr],y             ; and put it back!
6989 93D5
6990 93D5 C8                    iny   
6991 93D6 C8                    iny   
6992 93D7 84 2A                 sty   CurPMByte
6993 93D9
6994 93D9 6B                    rtl   
6995 93DA
6996 93DA
6997 93DA                       EXPORT StuffBig1640 
6998 93DA              StuffBig1640                            ; 
6999 93DA 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7000 93DD 0A                    asl   a                        ; double the value so can index
7001 93DE              *			; into conversion table
7002 93DE AA                    tax   
7003 93DF BF 72 67 FE           lda   >ConTable640,x
7004 93E3
7005 93E3
7006 93E3 A8                    tay                            ; save copy in y
7007 93E4 25 2E                 and   FG                       ; now the foreground pixels are colored
7008 93E6 85 C0                 sta   tempFG                   ; save it here
7009 93E8 98                    tya                            ; get back orig
7010 93E9 49 FF FF              eor   #$FFFF                   ; invert it
7011 93EC 25 BE                 and   BG                       ; now the background pixels are colored
7012 93EE 05 C0                 ora   tempFG                   ; this now gives us rightly colored word
7013 93F0
7014 93F0 A4 2A                 ldy   CurPMByte                ; get index to dest
7015 93F2 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7016 93F4 17 B6                 ora   [pmRowPtr],y             ; or with orig dest
7017 93F6 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7018 93F8
7019 93F8 C8                    iny   
7020 93F9 C8                    iny   
7021 93FA 84 2A                 sty   CurPMByte
7022 93FC
7023 93FC 6B                    rtl   
7024 93FD
7025 93FD                       ENDP 
7026 93FD              ;                copy text/stuffbig2
7027 93FD              ****************************************************************
7028 93FD              *
7029 93FD              * StuffBig2
7030 93FD              *
7031 93FD              * This is the routine that XORs into the destination with
7032 93FD              * colored forground and background.
7033 93FD              *
7034 93FD              ****************************************************************
7035 93FD                       EXPORT StuffBig2320 
7036 93FD              StuffBig2320 PROC 
7037 93FD
7038 93FD 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7039 9400 0A                    asl   a                        ; quadruple the value so can index
7040 9401 0A                    asl   a                        ; into conversion table
7041 9402 AA                    tax   
7042 9403 BF 74 63 FE           lda   >ConTable320+2,x
7043 9407 A8                    tay   
7044 9408 BF 72 63 FE           lda   >ConTable320,x
7045 940C BB                    tyx   
7046 940D
7047 940D A8                    tay                            ; save copy in y
7048 940E 25 2E                 and   FG                       ; now the foreground pixels are colored
7049 9410 85 C0                 sta   tempFG                   ; save it here
7050 9412 98                    tya                            ; get back orig
7051 9413 49 FF FF              eor   #$FFFF                   ; invert it
7052 9416 25 BE                 and   BG                       ; now the background pixels are colored
7053 9418 05 C0                 ora   tempFG                   ; a now has rightly colored word
7054 941A
7055 941A A4 2A                 ldy   CurPMByte                ; get index to dest
7056 941C 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7057 941E 57 B6                 eor   [pmRowPtr],y             ; or with orig dest
7058 9420 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7059 9422
7060 9422 C8                    iny   
7061 9423 C8                    iny   
7062 9424 8A                    txa   
7063 9425 25 2E                 and   FG                       ; now the foreground pixels are colored
7064 9427 85 C0                 sta   tempFG                   ; save it here
7065 9429 8A                    txa                            ; get back orig
7066 942A 49 FF FF              eor   #$FFFF                   ; invert it
7067 942D 25 BE                 and   BG                       ; now the background pixels are colored
7068 942F 05 C0                 ora   tempFG                   ; this has rightly colored word
7069 9431
7070 9431 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7071 9433 57 B6                 eor   [pmRowPtr],y             ; or original destination
7072 9435 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7073 9437
7074 9437 C8                    iny   
7075 9438 C8                    iny   
7076 9439 84 2A                 sty   CurPMByte
7077 943B
7078 943B 6B                    rtl   
7079 943C
7080 943C
7081 943C                       EXPORT StuffBig2640 
7082 943C              StuffBig2640                            ; 
7083 943C 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7084 943F 0A                    asl   a                        ; double the value so can index
7085 9440              *			; into conversion table
7086 9440 AA                    tax   
7087 9441 BF 72 67 FE           lda   >ConTable640,x
7088 9445
7089 9445
7090 9445 A8                    tay                            ; save copy in y
7091 9446 25 2E                 and   FG                       ; now the foreground pixels are colored
7092 9448 85 C0                 sta   tempFG                   ; save it here
7093 944A 98                    tya                            ; get back orig
7094 944B 49 FF FF              eor   #$FFFF                   ; invert it
7095 944E 25 BE                 and   BG                       ; now the background pixels are colored
7096 9450 05 C0                 ora   tempFG                   ; this now gives us rightly colored word
7097 9452
7098 9452 A4 2A                 ldy   CurPMByte                ; get index to dest
7099 9454 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7100 9456 57 B6                 eor   [pmRowPtr],y             ; or with orig dest
7101 9458 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7102 945A
7103 945A C8                    iny   
7104 945B C8                    iny   
7105 945C 84 2A                 sty   CurPMByte
7106 945E
7107 945E 6B                    rtl   
7108 945F
7109 945F                       ENDP 
7110 945F              ;                copy text/stuffbig3
7111 945F              ****************************************************************
7112 945F              *
7113 945F              * StuffBig3
7114 945F              *
7115 945F              * This is the routine that BICs into the destination with
7116 945F              * colored forground and background.
7117 945F              *
7118 945F              ****************************************************************
7119 945F                       EXPORT StuffBig3320 
7120 945F              StuffBig3320 PROC 
7121 945F
7122 945F 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7123 9462 0A                    asl   a                        ; quadruple the value so can index
7124 9463 0A                    asl   a                        ; into conversion table
7125 9464 AA                    tax   
7126 9465 BF 74 63 FE           lda   >ConTable320+2,x
7127 9469 A8                    tay   
7128 946A BF 72 63 FE           lda   >ConTable320,x
7129 946E BB                    tyx   
7130 946F
7131 946F A8                    tay                            ; save copy in y
7132 9470 25 2E                 and   FG                       ; now the foreground pixels are colored
7133 9472 85 C0                 sta   tempFG                   ; save it here
7134 9474 98                    tya                            ; get back orig
7135 9475 49 FF FF              eor   #$FFFF                   ; invert it
7136 9478 25 BE                 and   BG                       ; now the background pixels are colored
7137 947A 05 C0                 ora   tempFG                   ; a now has rightly colored word
7138 947C
7139 947C A4 2A                 ldy   CurPMByte                ; get index to dest
7140 947E 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7141 9480 49 FF FF              eor   #$FFFF                   ; BIC is not src AND dest
7142 9483 37 B6                 and   [pmRowPtr],y             ;
7143 9485 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7144 9487
7145 9487 C8                    iny   
7146 9488 C8                    iny   
7147 9489 8A                    txa   
7148 948A 25 2E                 and   FG                       ; now the foreground pixels are colored
7149 948C 85 C0                 sta   tempFG                   ; save it here
7150 948E 8A                    txa                            ; get back orig
7151 948F 49 FF FF              eor   #$FFFF                   ; invert it
7152 9492 25 BE                 and   BG                       ; now the background pixels are colored
7153 9494 05 C0                 ora   tempFG                   ; this has rightly colored word
7154 9496
7155 9496 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7156 9498 49 FF FF              eor   #$FFFF                   ; BIC is not src AND dest
7157 949B 37 B6                 and   [pmRowPtr],y             ;
7158 949D 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7159 949F
7160 949F C8                    iny   
7161 94A0 C8                    iny   
7162 94A1 84 2A                 sty   CurPMByte
7163 94A3
7164 94A3 6B                    rtl   
7165 94A4
7166 94A4
7167 94A4                       EXPORT StuffBig3640 
7168 94A4              StuffBig3640                            ; 
7169 94A4 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7170 94A7 0A                    asl   a                        ; double the value so can index
7171 94A8              *			; into conversion table
7172 94A8 AA                    tax   
7173 94A9 BF 72 67 FE           lda   >ConTable640,x
7174 94AD
7175 94AD
7176 94AD A8                    tay                            ; save copy in y
7177 94AE 25 2E                 and   FG                       ; now the foreground pixels are colored
7178 94B0 85 C0                 sta   tempFG                   ; save it here
7179 94B2 98                    tya                            ; get back orig
7180 94B3 49 FF FF              eor   #$FFFF                   ; invert it
7181 94B6 25 BE                 and   BG                       ; now the background pixels are colored
7182 94B8 05 C0                 ora   tempFG                   ; this now gives us rightly colored word
7183 94BA
7184 94BA A4 2A                 ldy   CurPMByte                ; get index to dest
7185 94BC 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7186 94BE 49 FF FF              eor   #$FFFF                   ; BIC is not src AND dest
7187 94C1 37 B6                 and   [pmRowPtr],y
7188 94C3 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7189 94C5
7190 94C5 C8                    iny   
7191 94C6 C8                    iny   
7192 94C7 84 2A                 sty   CurPMByte
7193 94C9
7194 94C9 6B                    rtl   
7195 94CA
7196 94CA                       ENDP 
7197 94CA              ;                copy text/stuffbig4
7198 94CA              ****************************************************************
7199 94CA              *
7200 94CA              * StuffBig4
7201 94CA              *
7202 94CA              * This is the routine that copies only the foreground
7203 94CA              * pixels into the destination.
7204 94CA              *
7205 94CA              ****************************************************************
7206 94CA                       EXPORT StuffBig4320 
7207 94CA              StuffBig4320 PROC 
7208 94CA
7209 94CA 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7210 94CD 0A                    asl   a                        ; quadruple the value so can index
7211 94CE 0A                    asl   a                        ; into conversion table
7212 94CF AA                    tax   
7213 94D0 BF 74 63 FE           lda   >ConTable320+2,x
7214 94D4 A8                    tay   
7215 94D5 BF 72 63 FE           lda   >ConTable320,x
7216 94D9 BB                    tyx   
7217 94DA
7218 94DA
7219 94DA A8                    tay                            ; save copy in y
7220 94DB 25 2E                 and   FG                       ; now the foreground pixels are colored
7221 94DD 85 C0                 sta   TempFG                   ; save colored copy here
7222 94DF 98                    tya                            ; get un colored copy back to burn
7223 94E0              *			; whole in source
7224 94E0 A4 2A                 ldy   CurPMByte                ; get index to dest
7225 94E2 37 4C                 and   [ScanMaskRef],y          ; and this with mask for cur scan line
7226 94E4 49 FF FF              eor   #$FFFF                   ; invert it
7227 94E7 37 B6                 and   [pmRowPtr],y             ; and with orig dest
7228 94E9 85 C2                 sta   NotMaskAndDest           ; save this here
7229 94EB
7230 94EB B7 4C                 lda   [ScanMaskRef],y          ; get mask back
7231 94ED 25 C0                 and   tempFG                   ; and with rightly colored word
7232 94EF 05 C2                 ora   NotMaskAndDest           ; or with burned out dest
7233 94F1 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7234 94F3
7235 94F3 C8                    iny   
7236 94F4 C8                    iny   
7237 94F5 8A                    txa   
7238 94F6 25 2E                 and   FG                       ; now the foreground pixels are colored
7239 94F8 85 C0                 sta   tempFG                   ; save it here
7240 94FA 8A                    txa                            ; get uncolored copy back to burn again
7241 94FB
7242 94FB 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7243 94FD 49 FF FF              eor   #$FFFF                   ; invert it
7244 9500 37 B6                 and   [pmRowPtr],y             ; and with orig dest
7245 9502 85 C2                 sta   NotMaskAndDest           ; save this here
7246 9504 B7 4C                 lda   [ScanMaskRef],y          ; get mask back
7247 9506 25 C0                 and   tempFG                   ; and with rightly colored word
7248 9508 05 C2                 ora   NotMaskAndDest           ; or with burned out dest
7249 950A 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7250 950C
7251 950C C8                    iny   
7252 950D C8                    iny   
7253 950E 84 2A                 sty   CurPMByte
7254 9510
7255 9510 6B                    rtl   
7256 9511
7257 9511
7258 9511                       EXPORT StuffBig4640 
7259 9511              StuffBig4640                            ; 
7260 9511 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7261 9514 0A                    asl   a                        ; double the value so can index
7262 9515              *			; into conversion table
7263 9515 AA                    tax   
7264 9516 BF 72 67 FE           lda   >ConTable640,x
7265 951A
7266 951A AA                    tax                            ; save uncolored copy in x
7267 951B 25 2E                 and   FG                       ; now the foreground pixels are colored
7268 951D 85 C0                 sta   tempFG                   ; save it here
7269 951F 8A                    txa                            ; get uncolored copy back to burn
7270 9520              *			; whole in src.
7271 9520 A4 2A                 ldy   CurPMByte                ; get index to dest
7272 9522 37 4C                 and   [ScanMaskRef],y          ; and with mask for this scan line
7273 9524 49 FF FF              eor   #$FFFF                   ; invert it
7274 9527 37 B6                 and   [pmRowPtr],y             ; and with orig dest
7275 9529 85 C2                 sta   NotMaskAndDest           ; save this here
7276 952B B7 4C                 lda   [ScanMaskRef],y          ; get mask back
7277 952D 25 C0                 and   tempFG                   ; and with rightly colored word
7278 952F 05 C2                 ora   NotMaskAndDest           ; or with burned out dest
7279 9531 97 B6                 sta   [pmRowPtr],y             ; and put it back!
7280 9533
7281 9533 C8                    iny   
7282 9534 C8                    iny   
7283 9535 84 2A                 sty   CurPMByte
7284 9537
7285 9537 6B                    rtl   
7286 9538
7287 9538                       ENDP 
7288 9538              ;                copy text/stuffbig5
7289 9538              ****************************************************************
7290 9538              *
7291 9538              * StuffBig5
7292 9538              *
7293 9538              * This is the routine that OR's the foreground into the dest.
7294 9538              * It is probably the fastest of the routines.
7295 9538              *
7296 9538              ****************************************************************
7297 9538                       EXPORT StuffBig5320 
7298 9538              StuffBig5320 PROC 
7299 9538
7300 9538 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7301 953B 0A                    asl   a                        ; quadruple the value so can index
7302 953C 0A                    asl   a                        ; into conversion table
7303 953D AA                    tax   
7304 953E BF 74 63 FE           lda   >ConTable320+2,x
7305 9542 A8                    tay   
7306 9543 BF 72 63 FE           lda   >ConTable320,x
7307 9547 BB                    tyx   
7308 9548
7309 9548 25 2E                 and   FG                       ; put color into foreground
7310 954A
7311 954A A4 2A                 ldy   CurPMByte                ; get index to dest
7312 954C 37 4C                 and   [ScanMaskRef],y          ; clip to scan line mask
7313 954E 17 B6                 ora   [pmRowPtr],y             ; or with dest
7314 9550 97 B6                 sta   [pmRowPtr],y             ; replace dest
7315 9552 C8                    iny                            ; now bump pointer into dest
7316 9553 C8                    iny   
7317 9554 8A                    txa                            ; get next word from x reg
7318 9555 25 2E                 and   FG                       ; put the color into the forground
7319 9557 37 4C                 and   [ScanMaskRef],y          ; mask the sucker
7320 9559 17 B6                 ora   [pmRowPtr],y             ; or with dest
7321 955B 97 B6                 sta   [pmRowPtr],y             ; store it
7322 955D C8                    iny                            ; bump the pointer to dest while
7323 955E C8                    iny                            ; still in reg
7324 955F 84 2A                 sty   CurPMByte                ; and save it.
7325 9561
7326 9561 6B                    rtl   
7327 9562
7328 9562
7329 9562
7330 9562
7331 9562                       EXPORT StuffBig5640 
7332 9562              StuffBig5640                            ; 
7333 9562 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7334 9565 0A                    asl   a                        ; double the value so can index
7335 9566              ;                                       ; into conversion table
7336 9566 AA                    tax   
7337 9567 BF 72 67 FE           lda   >ConTable640,x
7338 956B 25 2E                 and   FG                       ; put color into foreground
7339 956D
7340 956D A4 2A                 ldy   CurPMByte                ; get index to dest
7341 956F 37 4C                 and   [ScanMaskRef],y          ; and with mask
7342 9571 17 B6                 ora   [pmRowPtr],y             ; or with orig dest
7343 9573 97 B6                 sta   [pmRowPtr],y             ; and store it
7344 9575 C8                    iny                            ; bump pointer while still in reg
7345 9576 C8                    iny   
7346 9577 84 2A                 sty   CurPMByte                ; and store it
7347 9579
7348 9579 6B                    rtl   
7349 957A
7350 957A
7351 957A
7352 957A
7353 957A                       ENDP 
7354 957A              ;                copy text/stuffbig6
7355 957A              ****************************************************************
7356 957A              *
7357 957A              * StuffBig6
7358 957A              *
7359 957A              * This is the routine that XOR's the foreground into the dest.
7360 957A              * It is one of the fastest of the routines.
7361 957A              *
7362 957A              ****************************************************************
7363 957A                       EXPORT StuffBig6320 
7364 957A              StuffBig6320 PROC 
7365 957A
7366 957A 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7367 957D 0A                    asl   a                        ; quadruple the value so can index
7368 957E 0A                    asl   a                        ; into conversion table
7369 957F AA                    tax   
7370 9580 BF 74 63 FE           lda   >ConTable320+2,x
7371 9584 A8                    tay   
7372 9585 BF 72 63 FE           lda   >ConTable320,x
7373 9589 BB                    tyx   
7374 958A
7375 958A 25 2E                 and   FG                       ; put color into foreground
7376 958C
7377 958C A4 2A                 ldy   CurPMByte                ; get index to dest
7378 958E 37 4C                 and   [ScanMaskRef],y          ; clip to scan line mask
7379 9590 57 B6                 eor   [pmRowPtr],y             ; or with dest
7380 9592 97 B6                 sta   [pmRowPtr],y             ; replace dest
7381 9594 C8                    iny                            ; now bump pointer into dest
7382 9595 C8                    iny   
7383 9596 8A                    txa                            ; get next word from x reg
7384 9597 25 2E                 and   FG                       ; put the color into the forground
7385 9599 37 4C                 and   [ScanMaskRef],y          ; mask the sucker
7386 959B 57 B6                 eor   [pmRowPtr],y             ; or with dest
7387 959D 97 B6                 sta   [pmRowPtr],y             ; store it
7388 959F C8                    iny                            ; bump the pointer to dest while
7389 95A0 C8                    iny                            ; still in reg
7390 95A1 84 2A                 sty   CurPMByte                ; and save it.
7391 95A3
7392 95A3 6B                    rtl   
7393 95A4
7394 95A4
7395 95A4
7396 95A4
7397 95A4                       EXPORT StuffBig6640 
7398 95A4              StuffBig6640                            ; 
7399 95A4 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7400 95A7 0A                    asl   a                        ; double the value so can index
7401 95A8              ;                                       ; into conversion table
7402 95A8 AA                    tax   
7403 95A9 BF 72 67 FE           lda   >ConTable640,x
7404 95AD 25 2E                 and   FG                       ; put color into foreground
7405 95AF
7406 95AF A4 2A                 ldy   CurPMByte                ; get index to dest
7407 95B1 37 4C                 and   [ScanMaskRef],y          ; and with mask
7408 95B3 57 B6                 eor   [pmRowPtr],y             ; or with orig dest
7409 95B5 97 B6                 sta   [pmRowPtr],y             ; and store it
7410 95B7 C8                    iny                            ; bump pointer while still in reg
7411 95B8 C8                    iny   
7412 95B9 84 2A                 sty   CurPMByte                ; and store it
7413 95BB
7414 95BB 6B                    rtl   
7415 95BC
7416 95BC
7417 95BC                       ENDP 
7418 95BC              ;                copy text/stuffbig7
7419 95BC              ****************************************************************
7420 95BC              *
7421 95BC              * StuffBig7
7422 95BC              *
7423 95BC              * This is the routine that BIC's the foreground into the dest.
7424 95BC              * It is not as fast as OR and XOR but is a lot faster than
7425 95BC              * copy.
7426 95BC              *
7427 95BC              ****************************************************************
7428 95BC                       EXPORT StuffBig7320 
7429 95BC              StuffBig7320 PROC 
7430 95BC
7431 95BC 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7432 95BF 0A                    asl   a                        ; quadruple the value so can index
7433 95C0 0A                    asl   a                        ; into conversion table
7434 95C1 AA                    tax   
7435 95C2 BF 74 63 FE           lda   >ConTable320+2,x
7436 95C6 A8                    tay   
7437 95C7 BF 72 63 FE           lda   >ConTable320,x
7438 95CB BB                    tyx   
7439 95CC
7440 95CC 25 2E                 and   FG                       ; put color into foreground
7441 95CE
7442 95CE A4 2A                 ldy   CurPMByte                ; get index to dest
7443 95D0 37 4C                 and   [ScanMaskRef],y          ; clip to scan line mask
7444 95D2 49 FF FF              eor   #$FFFF
7445 95D5 37 B6                 and   [pmRowPtr],y             ; or with dest
7446 95D7 97 B6                 sta   [pmRowPtr],y             ; replace dest
7447 95D9 C8                    iny                            ; now bump pointer into dest
7448 95DA C8                    iny   
7449 95DB 8A                    txa                            ; get next word from x reg
7450 95DC 25 2E                 and   FG                       ; put the color into the forground
7451 95DE 37 4C                 and   [ScanMaskRef],y          ; mask the sucker
7452 95E0 49 FF FF              eor   #$FFFF
7453 95E3 37 B6                 and   [pmRowPtr],y             ; or with dest
7454 95E5 97 B6                 sta   [pmRowPtr],y             ; store it
7455 95E7 C8                    iny                            ; bump the pointer to dest while
7456 95E8 C8                    iny                            ; still in reg
7457 95E9 84 2A                 sty   CurPMByte                ; and save it.
7458 95EB
7459 95EB 6B                    rtl   
7460 95EC
7461 95EC
7462 95EC
7463 95EC                       EXPORT StuffBig7640 
7464 95EC              StuffBig7640                            ; 
7465 95EC 29 FF 00              and   #$00FF                   ; deal with only one byte at a time
7466 95EF 0A                    asl   a                        ; double the value so can index
7467 95F0              ;                                       ; into conversion table
7468 95F0 AA                    tax   
7469 95F1 BF 72 67 FE           lda   >ConTable640,x
7470 95F5 25 2E                 and   FG                       ; put color into foreground
7471 95F7
7472 95F7 A4 2A                 ldy   CurPMByte                ; get index to dest
7473 95F9 37 4C                 and   [ScanMaskRef],y          ; and with mask
7474 95FB 49 FF FF              eor   #$FFFF
7475 95FE 37 B6                 and   [pmRowPtr],y             ; or with orig dest
7476 9600 97 B6                 sta   [pmRowPtr],y             ; and store it
7477 9602 C8                    iny                            ; bump pointer while still in reg
7478 9603 C8                    iny   
7479 9604 84 2A                 sty   CurPMByte                ; and store it
7480 9606
7481 9606 6B                    rtl   
7482 9607
7483 9607
7484 9607
7485 9607                       ENDP 
7486 9607
7487 9607                       END   
